/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.model;

import java.util.List;
import java.util.Locale;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.util.string.StringUtilities;

public class JDVObject
extends PropertiesObject {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isMinimumDefined() {
        return false;
    }

    @Override
    public void setProperty(String key, String value) {
        String type = this.getPropertyDataType(key);
        String val = value;
        if ("BOOLEAN".equalsIgnoreCase(type)) {
            if ("1".equals(value) || "Y".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value)) {
                val = TRUE;
            } else if ("0".equals(value) || "N".equalsIgnoreCase(value) || "NO".equalsIgnoreCase(value)) {
                val = FALSE;
            }
        }
        super.setProperty(key, val);
    }

    @Override
    public String toJSONString(boolean excludeNulls) {
        Object res = "{";
        boolean first = true;
        for (String prop : this.propsList) {
            PropertiesObject po;
            String value = this.getProperty(prop);
            String type = this.getPropertyDataType(prop);
            String jsonKey = this.getJsonPropertyName(prop);
            if (jsonKey == null) {
                jsonKey = prop.toLowerCase(Locale.ROOT);
            }
            if (value == null && !"PropertiesObject".equalsIgnoreCase(type)) {
                if (excludeNulls) continue;
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + "\n\"" + jsonKey + "\":";
                res = (String)res + "null";
                continue;
            }
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + jsonKey + "\":";
            if ("PropertiesObject".equalsIgnoreCase(type) && (po = this.getObjectForProperty(prop)) != null) {
                String json = po.toJSONString(excludeNulls);
                res = (String)res + json;
                continue;
            }
            if (type.equalsIgnoreCase("BOOLEAN")) {
                if ("0".equals(value) || "N".equalsIgnoreCase(value) || "NO".equalsIgnoreCase(value)) {
                    res = (String)res + FALSE;
                    continue;
                }
                if ("1".equals(value) || "Y".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value)) {
                    res = (String)res + TRUE;
                    continue;
                }
                res = (String)res + value;
                continue;
            }
            if (type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("BOOLEAN") || type.equalsIgnoreCase("JSON")) {
                res = (String)res + value;
                continue;
            }
            res = (String)res + "\"" + StringUtilities.encodeAttributeValueJSON(value) + "\"";
        }
        for (PropertiesObject.CollectionDescriptor cd : this.getCollectionDescriptors()) {
            List list = cd.coll.getCollection();
            String name = cd.name;
            if (name == null || name.isEmpty() || list == null || list.size() <= 0) continue;
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + name + "\":[\n";
            boolean ofirst = true;
            for (Object obj : list) {
                if (!ofirst) {
                    res = (String)res + ",";
                } else {
                    ofirst = false;
                }
                if (obj instanceof PropertiesObject) {
                    res = (String)res + ((PropertiesObject)obj).toJSONString(excludeNulls);
                    continue;
                }
                res = (String)res + "\"" + obj.toString() + "\"";
            }
            res = (String)res + "\n]";
        }
        res = (String)res + "\n}";
        return res;
    }

    public boolean trueVal(String prop) {
        String val = this.getProperty(prop);
        return TRUE.equalsIgnoreCase(val) || "1".equals(val);
    }

    public static void main(String[] args) {
    }

    public static interface Setter {
        public void setValue(String var1);
    }
}

