/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.dbimport;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.mle_js.ExpNode;

public class Transform {
    static Collection<String> exclude = new HashSet<String>();
    static String PHYS_PROPS = "physicalProperties";

    static JSONObjToStreamTransformer getToJsonTransformer(Class clazz) {
        MDTransformationManager trMan = XMLTransformationManager.getInstance().getMDTransformationManager();
        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(clazz);
        if (trs != null && trs.getFromObjectToJsonStreamTransformer() != null && trs.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
            return (JSONObjToStreamTransformer)trs.getFromObjectToJsonStreamTransformer();
        }
        return null;
    }

    static List<String> getExcludeProperties() {
        ArrayList<String> res = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
        res.addAll(exclude);
        return res;
    }

    public static void transformFromListOfObjects(List<Table> list, String propName, Writer sb, boolean processExternals) throws IOException {
        sb.write("{\"" + propName + "\":[");
        boolean first = true;
        JSONObjToStreamTransformer tr = Transform.getToJsonTransformer(Table.class);
        for (Table table : list) {
            tr.transformFromObject(table, null, sb, processExternals, true, Transform.getExcludeProperties(), first);
            first = false;
        }
        sb.write("]}");
    }

    public static void transformListOfTablesToJSON_Array(Collection<Table> list, Writer sb, boolean processExternals) throws IOException {
        sb.write("[");
        boolean first = true;
        JSONObjToStreamTransformer tr = Transform.getToJsonTransformer(Table.class);
        for (Table table : list) {
            tr.transformFromObject(table, null, sb, processExternals, true, Transform.getExcludeProperties(), first);
            first = false;
        }
        sb.write("]");
    }

    public static void transformObjectsToJSON_Array(Collection<DesignObject> list, Writer sb, boolean processExternals) throws IOException {
        sb.write("[");
        boolean first = true;
        for (DesignObject obj : list) {
            JSONObjToStreamTransformer tr = Transform.getToJsonTransformer(obj.getClass());
            if (tr != null) {
                tr.transformFromObject(obj, null, sb, processExternals, true, Transform.getExcludeProperties(), first);
            }
            first = false;
        }
        sb.write("]");
    }

    public static String getUsedTablesAsJSONArray(Collection<Table> list) throws IOException {
        if (list.size() > 0) {
            try (StringWriter sw = new StringWriter();){
                String res;
                Transform.transformListOfTablesToJSON_Array(list, sw, false);
                String string = res = sw.toString();
                return string;
            }
        }
        return "[]";
    }

    public static String rootToJsonSchema(JDVElement dvRoot) {
        ExpNode.StringAdd res = new ExpNode.StringAdd();
        Transform.addTable(dvRoot, 0, res, 0);
        return res.toString();
    }

    static void addTable(JDVElement table, int position, ExpNode.StringAdd res, int order) {
        String key = table.getJsonAlias();
        res.addNL_Tabs(Transform.getKey(key) + "{", position);
        if (table.isRootTable() || table.getOther_FkColumns() != null || "singleton".equalsIgnoreCase(table.getRelationship())) {
            Transform.addObjectIntro(position + 1, res, order);
            Transform.addElements(table, table.getTable_name(), table.getElements(), position + 1, res);
            Transform.addObjectEnd(table, position, res);
        } else {
            Transform.addArrayIntro(position + 1, res, order);
            Transform.addElements(table, table.getName(), table.getElements(), position + 2, res);
            Transform.addArrayEnd(table, position, res);
        }
    }

    static void addObjectIntro(int position, ExpNode.StringAdd res, int order) {
        res.addNL_Tabs("\"type\": \"object\",", position);
        if (order > 0) {
            res.addNL_Tabs("\"order\": " + order + ",", position);
        }
        res.addNL_Tabs("\"properties\": {", position);
    }

    static void addObjectEnd(JDVElement table, int position, ExpNode.StringAdd res) {
        res.addNL_Tabs("}", position + 1);
        if (table.getRequired() != null) {
            res.addText(",");
            res.addNL_Tabs("\"required\": " + table.getRequired(), position + 1);
        }
        res.addNL_Tabs("}", position);
    }

    static void addObjectEnd(int position, ExpNode.StringAdd res) {
        res.addNL_Tabs("}", position + 1);
        res.addNL_Tabs("}", position);
    }

    static void addArrayIntro(int position, ExpNode.StringAdd res, int order) {
        res.addNL_Tabs("\"type\": \"array\",", position);
        if (order > 0) {
            res.addNL_Tabs("\"order\": " + order + ",", position);
        }
        res.addNL_Tabs("\"items\": {", position);
        res.addNL_Tabs("\"type\": \"object\",", position + 1);
        res.addNL_Tabs("\"properties\": {", position + 1);
    }

    static void addArrayEnd(JDVElement table, int position, ExpNode.StringAdd res) {
        res.addNL_Tabs("}", position + 2);
        if (table.getRequired() != null) {
            res.addText(",");
            res.addNL_Tabs("\"required\": " + table.getRequired(), position + 2);
        }
        res.addNL_Tabs("}", position + 1);
        res.addNL_Tabs("}", position);
    }

    static void addPropertiesAlias(int position, ExpNode.StringAdd res) {
        res.addNL_Tabs("\"properties\": {", position);
    }

    private static void addElements(JDVElement table, String tableName, List<JDVElement> list, int position, ExpNode.StringAdd res) {
        HashSet<String> addedNested = new HashSet<String>();
        Map<String, List<JDVElement>> nested = Transform.createNestingMap(list);
        boolean first = true;
        int order = 0;
        for (JDVElement el : list) {
            if (!el.isTable()) {
                if (el.getNestedKey() != null && !el.getNestedKey().isEmpty()) {
                    if (!addedNested.contains(el.getJsonAlias())) {
                        if (!first) {
                            res.addText(",");
                        }
                        Transform.addNestedColumns(tableName, el.getNestedKey(), nested, addedNested, position + 1, res, table, ++order);
                        addedNested.add(el.getJsonAlias());
                    }
                } else {
                    Transform.addColumn(el, position + 1, res, table, ++order, first);
                }
            } else {
                if (!first) {
                    res.addText(",");
                }
                Transform.addTable(el, position + 1, res, ++order);
            }
            first = false;
        }
    }

    private static void addColumn(JDVElement element, int position, ExpNode.StringAdd res, JDVElement table, int order, boolean first) {
        String key = Transform.getKey(element.getJsonAlias());
        if (key != null && !key.isEmpty() && !element.isFlexColumn()) {
            if (!first) {
                res.addText(",");
            }
            res.addNL_Tabs(key + "{", position);
            String type = element.getData_type();
            if (type != null) {
                String jsonType = Transform.getJSONType(type);
                String extendedType = Transform.getExtendedType(type);
                if (jsonType != null) {
                    res.addNL().addProperty("type", jsonType, position + 1);
                    if (extendedType != null) {
                        res.addPropNewLineString("extendedType", extendedType, position + 1);
                    }
                } else if (extendedType != null) {
                    res.addNL().addProperty("extendedType", extendedType, position + 1);
                }
                if (element.isGeneratedOnNull()) {
                    res.addText(",");
                    res.addNL_Tabs("\"generatedOnNull\": true", position + 1);
                }
                res.addText(",");
                res.addNL_Tabs("\"order\":" + order, position + 1);
            } else {
                res.addNL_Tabs("\"order\":" + order, position + 1);
                if (element.isGeneratedOnNull()) {
                    res.addText(",");
                    res.addNL_Tabs("\"generatedOnNull\": true", position + 1);
                }
            }
            if (element.getDescription() != null) {
                res.addText(",");
                res.addNL_Tabs("\"description\": \"" + element.getDescription() + "\"", position + 1);
            }
            if (element.getAllOf() != null) {
                res.addText(",");
                res.addNL_Tabs("\"allOf\":" + element.getAllOf(), position + 1);
            }
            res.addNL_Tabs("}", position);
        }
    }

    private static String getJSONType(String oracleType) {
        String type = oracleType.toUpperCase(Locale.ROOT);
        if (type.indexOf("VARCHAR") > -1) {
            return "string";
        }
        if (type.indexOf("NUMBER") > -1) {
            return "number";
        }
        if (type.indexOf("CLOB") > -1) {
            return "string";
        }
        if (type.indexOf("INTEGER") > -1) {
            return "integer";
        }
        if (type.indexOf("BOOLEAN") > -1) {
            return "boolean";
        }
        if (type.indexOf("VARCHAR") > -1) {
            return "string";
        }
        if (type.indexOf("DOUBLE") > -1) {
            return "number";
        }
        if (type.indexOf("FLOAT") > -1) {
            return "number";
        }
        return null;
    }

    private static String getExtendedType(String oracleType) {
        String type = oracleType.toUpperCase(Locale.ROOT);
        if (type.indexOf("VARCHAR") > -1) {
            return "string";
        }
        if (type.indexOf("NUMBER") > -1) {
            return "number";
        }
        if (type.indexOf("CLOB") > -1) {
            return "string";
        }
        if (type.indexOf("INTEGER") > -1) {
            return "integer";
        }
        if (type.indexOf("BOOLEAN") > -1) {
            return "boolean";
        }
        if (type.indexOf("VARCHAR") > -1) {
            return "string";
        }
        if (type.indexOf("DOUBLE") > -1) {
            return "number";
        }
        if (type.indexOf("FLOAT") > -1) {
            return "number";
        }
        if (type.indexOf("DATE") > -1) {
            return "date";
        }
        if (type.indexOf("TIMESTAMP") > -1) {
            return "timestamp";
        }
        return null;
    }

    private static void addNestedColumns(String tableName, String nestedKey, Map<String, List<JDVElement>> nested, Set<String> addedNested, int position, ExpNode.StringAdd res, JDVElement table, int order) {
        String key = Transform.getKey(nestedKey);
        List<JDVElement> list = nested.get(nestedKey);
        boolean first = true;
        if (key != null && !key.isEmpty() && list != null && list.size() > 0) {
            res.addNL_Tabs(key + " {", position);
            Transform.addObjectIntro(position + 1, res, order);
            int nestedOrder = 0;
            for (JDVElement el : list) {
                Transform.addColumn(el, position + 2, res, table, ++nestedOrder, first);
                addedNested.add(el.getJsonAlias());
                first = false;
            }
            Transform.addObjectEnd(position, res);
        }
    }

    private static Map<String, List<JDVElement>> createNestingMap(List<JDVElement> list) {
        HashMap<String, List<JDVElement>> map = new HashMap<String, List<JDVElement>>();
        for (JDVElement el : list) {
            if (el.getNestedKey() == null || el.getNestedKey().isEmpty()) continue;
            ArrayList<JDVElement> nested = (ArrayList<JDVElement>)map.get(el.getNestedKey());
            if (nested == null) {
                nested = new ArrayList<JDVElement>();
                map.put(el.getNestedKey(), nested);
            }
            nested.add(el);
        }
        return map;
    }

    private static String getKey(String key) {
        if (key != null && !key.isEmpty()) {
            return "\"" + key + "\": ";
        }
        return "";
    }

    static {
        exclude.add(PHYS_PROPS);
        exclude.add("class");
        exclude.add("sourceObjSchema");
        exclude.add("sourceObjName");
        exclude.add("allowTypeSubstitution");
        exclude.add("typeID");
        exclude.add("dwhType");
        exclude.add("abbreviation");
        exclude.add("oidIsPK");
        exclude.add("spatialTable");
        exclude.add("userDefinedOid");
        exclude.add("onPrebuiltTable");
        exclude.add("tableSpace");
        exclude.add("logging");
        exclude.add("organization");
        exclude.add("oracleLogTable");
        exclude.add("rowArchival");
        exclude.add("partitioned");
        exclude.add("impliedFKeys");
        exclude.add("materializedQueryTable");
        exclude.add("partitioned");
        exclude.add("blockChainTable");
        exclude.add("blockChainDatFormatVersion");
        exclude.add("blockChainHashAlgorithm");
        exclude.add("rowDeleteretentionDays");
        exclude.add("rowDeleteretentionLock");
        exclude.add("tableDropRetentionDays");
        exclude.add("formulaDesc");
        exclude.add("sourceType");
        exclude.add("allowSubtypeSubstitution");
        exclude.add("use");
        exclude.add("reference");
        exclude.add("restrictedTypeSubstitution");
        exclude.add("defaultValue");
        exclude.add("constraintValue");
        exclude.add("defaultOnNull");
        exclude.add("computed");
        exclude.add("maskingType");
        exclude.add("previousColumn");
        exclude.add("autoIncrementColumn");
        exclude.add("identityColumn");
        exclude.add("autoIncrementMinValue");
        exclude.add("autoIncrementMaxValue");
        exclude.add("nncDeferrable");
        exclude.add("nncInitiallyImediate");
        exclude.add("nncEnable");
        exclude.add("nncValidate");
        exclude.add("checkDeferrable");
        exclude.add("checkInitiallyImediate");
        exclude.add("checkEnable");
        exclude.add("listOfRanges");
        exclude.add("checkValidate");
        exclude.add("jsonColumn");
        exclude.add("jsonDataGuide");
        exclude.add("nestedColumns");
        exclude.add("constraintName");
        exclude.add("notNullConstraintName");
        exclude.add("fkElement");
        exclude.add("autoIncrementCache");
        exclude.add("oidKey");
        exclude.add("dimensionsNumber");
        exclude.add("geodetic");
        exclude.add("indexExpression");
        exclude.add("isSurrogateKey");
        exclude.add("constraintDeferrable");
        exclude.add("constraintInitiallyImediate");
        exclude.add("constraintEnable");
        exclude.add("constraintRely");
        exclude.add("constraintValidate");
        exclude.add("bitmapIndex");
        exclude.add("proxyProperties");
        exclude.add("indexType");
        exclude.add("indexDomainParameters");
        exclude.add("containerLongName");
        exclude.add("deleteRule");
        exclude.add("transferable");
        exclude.add("rely");
        exclude.add("skipFKIndex");
        exclude.add("tableCheckConstraints");
        exclude.add("validTimeDimensions");
        exclude.add("spatialDefinitions");
        exclude.add("identiyColumn");
    }
}

