/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;

public class StructuredTypeProxyOraclev9i
extends StructuredTypeProxyOracle {
    private String mapToJavaClass = "NO";
    private String javaClass = "";
    private String javaInstanceUsing;
    public static final String[] JAVA_INSTANCES = new String[]{"SQLData", "CustomDatum", "OraData", "SQLJ Attributes"};
    private static Set javaInstanceSet = null;

    public StructuredTypeProxyOraclev9i(StructuredType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
    }

    public StructuredTypeProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
        this.fireDataFieldChange();
    }

    public String getJavaInstanceUsing() {
        return this.javaInstanceUsing;
    }

    public void setJavaInstanceUsing(String javaInstanceUsing) {
        if (this.checkJavaInstances(javaInstanceUsing)) {
            this.javaInstanceUsing = javaInstanceUsing;
            this.fireDataFieldChange();
        }
    }

    public String getMapToJavaClass() {
        return this.mapToJavaClass;
    }

    public void setMapToJavaClass(String mapToJavaClass) {
        if (ConstantsOracle.checkYesNo(mapToJavaClass)) {
            this.mapToJavaClass = mapToJavaClass;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkJavaInstances(String value) {
        if (javaInstanceSet == null) {
            javaInstanceSet = new HashSet();
            javaInstanceSet.addAll(Arrays.asList(JAVA_INSTANCES));
        }
        return javaInstanceSet.contains(value);
    }

    public String getSuperType() {
        if (((StructuredType)this.getObject()).getParentType() == null) {
            return "";
        }
        return ((StructuredType)this.getObject()).getParentType().getName();
    }

    public String getFinal() {
        if (((StructuredType)this.getObject()).isFinal()) {
            return "YES";
        }
        return "NO";
    }

    public String getInstantiable() {
        if (((StructuredType)this.getObject()).isInstantiable()) {
            return "YES";
        }
        return "NO";
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StructuredTypeProxyOraclev9i strTypeProxy = null;
        StructuredTypeProxy storageObject = ((StorageDesignOraclev9i)targetDesign).getStructuredTypeProxySet().getByName(this.getName());
        if (storageObject != null && !this.isRawObject()) {
            strTypeProxy = (StructuredTypeProxyOraclev9i)storageObject;
        }
        if (strTypeProxy != null) {
            strTypeProxy.setName(this.getName());
            if (this.getOwner() != null) {
                UserOraclev9i owner = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    UserOraclev9i newOwner = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    strTypeProxy.setOwner(newOwner);
                } else {
                    strTypeProxy.setOwner(owner);
                }
            }
            strTypeProxy.setInvokerRights(this.getInvokerRights());
            if (this.getMapOrderFunction() != null) {
                MethodProxyOraclev9i method = (MethodProxyOraclev9i)((StorageDesignOraclev9i)targetDesign).getMethodProxySet().getByName(this.getMapOrderFunction().getName());
                if (method == null) {
                    MethodProxyOraclev9i newMethod = (MethodProxyOraclev9i)((MethodProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getMethodProxySet()).createProxy(this.getMapOrderFunction().getObject());
                    newMethod.setName(this.getMapOrderFunction().getName());
                    newMethod.setRawObject(true);
                    strTypeProxy.setMapOrderFunction(newMethod);
                } else {
                    strTypeProxy.setMapOrderFunction(method);
                }
            }
            strTypeProxy.setMapOrderType(this.getMapOrderType());
            strTypeProxy.setMapToJavaClass(this.getMapToJavaClass());
            strTypeProxy.setJavaClass(this.getJavaClass());
            strTypeProxy.setJavaInstanceUsing(this.getJavaInstanceUsing());
            strTypeProxy.setComment(this.getComment());
            strTypeProxy.setRawObject(false);
        }
    }
}

