/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;

public class UndoTablespaceOracle
extends AbstractStorageObjectOracle {
    protected static Set fileTypeSet = null;
    protected static final String[] FILE_TYPES = new String[]{"", "BIGFILE", "SMALLFILE"};
    protected String fileType = FILE_TYPES[0];
    protected static Set retentionSet = null;
    protected static final String[] RETENTION_TYPES = new String[]{"NOGUARANTEE", "GUARANTEE"};
    protected String retention = RETENTION_TYPES[0];
    protected String oracleManagesFiles = "NO";
    public static final String TYPE_NAME = "UTSpace";
    public static final String OLD_TYPE_NAME = "UndoTablespace";

    public UndoTablespaceOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "UndoTS";
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String value) {
        if (this.checkFileType(value)) {
            this.fileType = value;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkFileType(String value) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(UndoTablespaceOracle.getFileTypes()));
        }
        return fileTypeSet.contains(value);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public String getRetention() {
        return this.retention;
    }

    public void setRetention(String value) {
        if (this.checkRetention(value)) {
            this.retention = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkRetention(String value) {
        if (retentionSet == null) {
            retentionSet = new HashSet();
            retentionSet.addAll(Arrays.asList(UndoTablespaceOracle.getRetentionChoices()));
        }
        return retentionSet.contains(value);
    }

    public static String[] getRetentionChoices() {
        return RETENTION_TYPES;
    }

    public String getOracleManagesFiles() {
        return this.oracleManagesFiles;
    }

    public void setOracleManagesFiles(String oracleManagesFiles) {
        if (ConstantsOracle.checkYesNo(oracleManagesFiles)) {
            this.oracleManagesFiles = oracleManagesFiles;
            this.fireDataFieldChange();
        }
    }
}

