/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public abstract class PartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private InlineList subPartitionsTableSpacesSet = null;
    protected PartitionListOracle partitionList = null;
    private String valueList = "";
    private int position = 0;
    private TableSpaceOracle tableSpace = null;
    private String logging = "";
    private String dataSegmentCompression = "";
    private SegmentOracle segment = null;
    private int iotCompress = 0;
    private SegmentOracle iotOverflowSegment = null;
    protected int subPartitionsQuantity = 0;
    private String subPartitionsTableSpaces = "";
    protected StorageObjectCollection lobs;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection listPartitions;
    public static final String TYPE_NAME = "Partition";

    public PartitionOracle(StorageDesign stoDesign) {
        StorageDesignOracle storageDesign = (StorageDesignOracle)stoDesign;
        this.setStorageDesign(storageDesign);
        this.partitions = new StorageObjectCollection();
        this.partitions.setParent(this);
        this.partitions.setStorageObjectSet(storageDesign.getHashPartitionSet());
        this.partitions.setName(Messages.getString("PartitionOracle.HashSubpartitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.partitions.setSetMethod("setSubPartitionOf");
        storageDesign.getHashPartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection();
        this.lobs.setParent(this);
        this.lobs.setStorageObjectSet(storageDesign.getLobStorageSet());
        this.lobs.setName(Messages.getString("PartitionOracle.LobStorages"));
        this.lobs.setClassForParent(PartitionOracle.class);
        this.lobs.setSetMethod("setPartition");
        storageDesign.getLobStorageSet().addSetListener(this);
        this.listPartitions = new StorageObjectCollection();
        this.listPartitions.setParent(this);
        this.listPartitions.setStorageObjectSet(storageDesign.getListStorageTemplatePartitionSet());
        this.listPartitions.setName(Messages.getString("PartitionOracle.ListSubpartitions"));
        this.listPartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.listPartitions.setSetMethod("setSubPartitionOf");
    }

    protected void addListSubpartitionsFromDesign(ListStorageTemplatePartitionSetOracle listPartitionSet) {
        for (ListStorageTemplatePartitionOracle lp : listPartitionSet) {
            if (lp.getSubPartitionOf() == this) {
                lp.addObjectListener(this);
                lp.setParent(this.listPartitions);
                this.listPartitions.add(lp);
                continue;
            }
            this.listPartitions.remove(lp);
        }
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public abstract void setPartitionList(PartitionListOracle var1);

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String valueList) {
        if (!this.valueList.equals(valueList)) {
            this.valueList = valueList;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            StorageObjectCollection partitions;
            Object parent;
            this.position = position;
            if (position > 0 && (parent = this.getParent()) instanceof StorageObjectCollection && position <= (partitions = (StorageObjectCollection)parent).size() && partitions.getChild(position - 1) != this) {
                partitions.moveElementToIndex(this, position - 1);
            }
            this.fireDataFieldChange();
        }
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setLogging(String value) {
        if (!this.logging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.logging = value;
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setDataSegmentCompression(String dataSegmentCompression) {
        if (!this.dataSegmentCompression.equals(dataSegmentCompression) && (ConstantsOracle.checkYesNo(dataSegmentCompression) || "".equals(dataSegmentCompression))) {
            this.dataSegmentCompression = dataSegmentCompression;
            this.fireDataFieldChange();
        }
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setSegment(SegmentOracle segment) {
        if (this.segment != segment) {
            this.segment = segment;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public int getIOTCompress() {
        return this.iotCompress;
    }

    public void setIOTCompress(int iotCompress) {
        if (this.iotCompress != iotCompress) {
            this.iotCompress = iotCompress;
            this.fireDataFieldChange();
        }
    }

    public void setIOTOverflowSegment(SegmentOracle iotOverflowSegment) {
        if (this.iotOverflowSegment != iotOverflowSegment) {
            this.iotOverflowSegment = iotOverflowSegment;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getIOTOverflowSegment() {
        return this.iotOverflowSegment;
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int subPartitionsQuantity) {
        if (this.subPartitionsQuantity != subPartitionsQuantity) {
            this.subPartitionsQuantity = subPartitionsQuantity;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.subPartitionsTableSpaces, "|");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID.trim());
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public String convertTSNamesToIDs(String names) {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(name);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getObjectID());
        }
        return result.toString();
    }

    public void setSubPartitionsTableSpaces(String subPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(subPartitionsTableSpaces);
        } else {
            this.addSubPartitionsTS(subPartitionsTableSpaces);
        }
        String newValue = this.getSubPartTSSet().toString();
        if (!this.subPartitionsTableSpaces.equals(newValue)) {
            this.subPartitionsTableSpaces = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionsTS(String ts) {
        if (!this.getSubPartTSSet().contains(ts)) {
            this.getSubPartTSSet().add(ts);
        }
    }

    public void recreateSubPartitionsTSSet(String tableSpaces) {
        this.getSubPartTSSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, "|");
        while (st.hasMoreTokens()) {
            this.getSubPartTSSet().add(st.nextToken().trim());
        }
    }

    public InlineList getSubPartTSSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getSubPartTSSet().clear();
        this.subPartitionsTableSpaces = "";
        this.clearChildren();
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
            if (part.getSubPartitionOf() == this) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            if (lob.getPartition() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle) {
            ListStorageTemplatePartitionOracle listPart = (ListStorageTemplatePartitionOracle)event.getAffected();
            if (listPart.getSubPartitionOf() == this) {
                listPart.setParent(this.listPartitions);
                this.listPartitions.add(listPart);
            } else {
                this.listPartitions.remove(listPart);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            ListStorageTemplatePartitionOracle listPart;
            if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                    part.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                if (lob.getPartition() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                    lob.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle && (listPart = (ListStorageTemplatePartitionOracle)event.getAffected()).getSubPartitionOf() == this) {
                listPart.setParent(this.listPartitions);
                this.listPartitions.add(listPart);
                listPart.addObjectListener(this);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
                this.partitions.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                this.lobs.remove(lob);
                lob.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle listPart = (ListStorageTemplatePartitionOracle)event.getAffected();
                this.listPartitions.remove(listPart);
                listPart.removeObjectListener(this);
            }
        }
    }

    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitions.setForbiddenCreateElement(false);
        }
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
    }

    public void enableSubPartitionsByList() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(false);
    }

    public void disableSubPartitions() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.partitions;
            }
            case 2: {
                return this.listPartitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.partitions) {
            return 1;
        }
        if (child == this.listPartitions) {
            return 2;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.partitions) {
            return 1;
        }
        if (child == this.listPartitions) {
            return 2;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listPartitions.removeAll();
    }

    public StorageObjectCollection getLobs() {
        return this.lobs;
    }

    public StorageObjectCollection getPartitions() {
        return this.partitions;
    }

    public StorageObjectCollection getListPartitions() {
        return this.listPartitions;
    }

    public boolean hasSubPartitions() {
        return this.partitions.size() > 0 || this.listPartitions.size() > 0;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public HashPartitionOracle createHashSubpartition() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (HashPartitionOracle)this.partitions.createElement(null);
        }
        return null;
    }

    public ListStorageTemplatePartitionOracle createListSubpartition() {
        if (this.listPartitions.getStorageObjectSet() != null) {
            return (ListStorageTemplatePartitionOracle)this.listPartitions.createElement(null);
        }
        return null;
    }

    public StorageObject createLob() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (StorageObject)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> lips = new ArrayList<LocalIndexProperties>();
        for (LocalIndexProperties lip : ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet()) {
            if (lip.getPartition() != this || lip.getIndex() == null) continue;
            lips.add(lip);
        }
        return lips;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties lip = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        lip.setPartition(this);
        return lip;
    }

    @Override
    public void setParent(Object parent) {
        RepositoryObject parentObject;
        super.setParent(parent);
        RepositoryObject storableObject = null;
        if (parent instanceof StorageObjectCollection && (storableObject = (parentObject = (RepositoryObject)((StorageObjectCollection)parent).getParent()).getPAC_Element()) == null) {
            storableObject = parentObject;
        }
        this.setPAC_Element(storableObject);
    }

    @Override
    public void remove() {
        if (this.getPartitionList() != null && this.getPartitionList().getTable() != null) {
            this.getPartitionList().getTable().removeObject(this);
        }
        super.remove();
    }

    public void addLobStorageOracle(LobStorageOracle lob) {
        if (lob.getPartition() == this) {
            lob.setParent(this.lobs);
            this.lobs.add(lob);
            lob.addObjectListener(this);
        }
    }

    public void addListStorageTemplatePartitionOracle(ListStorageTemplatePartitionOracle listPart) {
        if (listPart.getSubPartitionOf() == this) {
            listPart.setParent(this.listPartitions);
            this.listPartitions.add(listPart);
            if (listPart.getPosition() == 0) {
                listPart.setPosition(this.listPartitions.size());
            }
            listPart.addObjectListener(this);
        }
    }

    public void addHashPartitionOracle(HashPartitionOracle part) {
        if (part.getSubPartitionOf() == this) {
            part.setParent(this.partitions);
            this.partitions.add(part);
            if (part.getPosition() == 0) {
                part.setPosition(this.partitions.size());
            }
            part.addObjectListener(this);
        }
    }

    @Override
    public void removeObject(StorageObject object) {
        if (object instanceof HashPartitionOracle) {
            this.partitions.remove(object);
            this.adjustSubpartitionPositions(this.partitions);
        } else if (object instanceof LobStorageOracle) {
            this.lobs.remove(object);
        } else if (object instanceof ListStorageTemplatePartitionOracle) {
            this.listPartitions.remove(object);
            this.adjustSubpartitionPositions(this.listPartitions);
        }
        object.removeObjectListener(this);
    }

    protected void adjustSubpartitionPositions(StorageObjectCollection subpartitions) {
        for (int i = 0; i < subpartitions.size(); ++i) {
            ModelObject obj = subpartitions.getElement(i);
            if (obj instanceof PartitionOracle) {
                ((PartitionOracle)obj).setPosition(i + 1);
                continue;
            }
            if (obj instanceof ListStorageTemplatePartitionOracle) {
                ((ListStorageTemplatePartitionOracle)obj).setPosition(i + 1);
                continue;
            }
            if (!(obj instanceof HashPartitionOracle)) continue;
            ((HashPartitionOracle)obj).setPosition(i + 1);
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append("| ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

