/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;

public class MethodProxySet
extends ProxyDesignObjectSet {
    public MethodProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getDesign().getDataTypesDesign().getMethodSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new MethodProxy((Method)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new MethodProxy(design, id, longName, this.getStorageDesign());
    }

    @Override
    public MethodProxy getByName(String name) {
        Iterator it = this.getElements().iterator();
        MethodProxy proxy = null;
        while (it.hasNext()) {
            proxy = (MethodProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }

    public MethodProxy getMethodByNameAndParams(StructuredTypeProxy type, String name, List paramNames, List paramDatatypes) {
        MethodProxy proxy2 = null;
        for (MethodProxy proxy2 : type.getMethods()) {
            if (!name.equalsIgnoreCase(proxy2.getName()) || !this.checkMethodParams(proxy2, paramNames, paramDatatypes)) continue;
            return proxy2;
        }
        return null;
    }

    private boolean checkMethodParams(MethodProxy proxy, List paramNames, List paramDatatypes) {
        if (proxy.getParams().size() != paramNames.size()) {
            return false;
        }
        Iterator itParams = proxy.getParams().iterator();
        int subscript = 0;
        while (itParams.hasNext()) {
            MethodParamProxy methodParam = (MethodParamProxy)itParams.next();
            String paramName = methodParam.getName();
            if (paramName.equalsIgnoreCase((String)paramNames.get(subscript))) {
                String mpDataType;
                String paramType;
                int dotIndex;
                if ((dotIndex = (paramType = (String)paramDatatypes.get(subscript++)).indexOf(".")) >= 0 && dotIndex + 1 < paramType.length()) {
                    paramType = paramType.substring(dotIndex + 1);
                }
                if (paramType.equalsIgnoreCase(mpDataType = methodParam.getMethodParam().getDataType())) continue;
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(paramType);
                String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(this.getSelectedRDBMSType(), usedDatatype);
                if (nameLogDT.equalsIgnoreCase(mpDataType) || paramType.equalsIgnoreCase(methodParam.getMethodParam().getDataType(this.getSelectedRDBMSType().toString())) || paramType.equalsIgnoreCase("STRING") && mpDataType.equalsIgnoreCase("VARCHAR") || mpDataType.equalsIgnoreCase("unknown")) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

