/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;

public class TableViewSet
extends DesignObjectSet
implements SetListener {
    private static final TableView[] PROTO_ARRAY = new TableView[0];

    public TableViewSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
        if (designPart != null) {
            this.setNameSpaceController(((RelationalDesign)designPart).getTablesAndViewsNameController());
        }
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "VIEW";
    }

    public TableView createTableView(String oldID) {
        TableView tableView = new TableView(this.getDesignPart());
        tableView.setObjectID(oldID);
        tableView.setDesign(this.getDesign());
        tableView.setParent(this);
        this.getDesign().addDesignObject(tableView);
        this.add(tableView);
        this.addSetListener(tableView);
        return tableView;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    @Override
    public void removeAll() {
        Object[] elements = this.toArray();
        for (int i = elements.length - 1; i >= 0; --i) {
            DesignObject obj = (DesignObject)elements[i];
            obj.remove();
        }
        super.removeAll();
    }

    @Override
    public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        if (nsc != null) {
            String validName = nsc.getValidName(object, schema, newName);
            if (validName.equals(newName)) {
                nsc.updateNamesMap(schema, oldName, newName, object);
                Object oldLongName = oldName;
                if (schema != null && !"".equals(schema)) {
                    oldLongName = schema + "." + oldName;
                }
                Object newLongName = newName;
                if (schema != null && !"".equals(schema)) {
                    newLongName = schema + "." + newName;
                }
                this.doRenaming((String)oldLongName, (String)newLongName, object);
                return true;
            }
            return false;
        }
        Object obj2 = this.names.get(newName.toUpperCase());
        if (obj2 == null || obj2 == object) {
            this.doRenaming(oldName, newName, object);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        boolean res = false;
        if (nsc != null) {
            res = nsc.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            super.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            return res;
        }
        return super.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
    }
}

