/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import oracle.dbtools.crest.model.design.AbstractApplyNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class ApplyAttributesNamingStandards
extends AbstractApplyNamingStandards<Entity> {
    private boolean applyToPrimaryIdentifier;
    private boolean applyToRelationAttribute;
    private Settings settings;
    private NamingStandardRule nsr;

    public ApplyAttributesNamingStandards(Settings settings, boolean applyToPrimaryIdentifier, boolean applyToRelationAttribute) {
        this.applyToPrimaryIdentifier = applyToRelationAttribute;
        this.applyToRelationAttribute = applyToPrimaryIdentifier;
        this.settings = settings;
    }

    @Override
    public void apply(Entity entity) {
        this.nsr = entity.getDesign().getNamingStandardRule();
        this.applyToPrimaryIdentifier(entity);
        if (!this.settings.isKeepFKNamesSynchronized()) {
            this.applyToRelationAttributes(entity);
        }
    }

    public void applyToPrimaryIdentifier(Entity entity) {
        this.nsr = entity.getDesign().getNamingStandardRule();
        if (this.applyToPrimaryIdentifier && entity.getPK() != null) {
            entity.getPK().setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(entity.getName(), entity.getShortName(), this.nsr));
        }
    }

    public void applyToRelationAttributes(Entity entity) {
        this.nsr = entity.getDesign().getNamingStandardRule();
        if (this.applyToRelationAttribute && !entity.isBST()) {
            for (Relation relation : entity.getRelations()) {
                Entity sourceEntity = relation.getSourceEntity();
                if (sourceEntity == entity) {
                    sourceEntity = relation.getTargetEntity();
                }
                if (sourceEntity.isBST()) continue;
                Attribute[] fkAttributes = relation.getFKAttributes(entity);
                for (int i = 0; i < fkAttributes.length; ++i) {
                    fkAttributes[i].setName(ApplyAttributesNamingStandards.createRelationAttributeName(relation, sourceEntity, fkAttributes[i].getDelegate(), this.nsr));
                }
            }
        }
    }

    public static String createPrimaryIdentifierName(String entityName, String shortName, NamingStandardRule nsr) {
        String rulePrimaryIdentifier = nsr.getUIConstr();
        if (rulePrimaryIdentifier.length() > 0) {
            entityName = entityName.replaceAll("\\$", "\\\\\\$");
            String res = rulePrimaryIdentifier.replaceAll("\\{entity\\}", entityName);
            if (shortName != null && !shortName.isEmpty()) {
                String shn = shortName.replaceAll("\\$", "\\\\\\$");
                res = res.replaceAll("\\{ent short name\\}", shn);
            } else {
                res = res.replaceAll("\\{ent short name\\}", entityName);
            }
            return res;
        }
        return rulePrimaryIdentifier;
    }

    public static String createRelationAttributeName(Relation relation, Entity parentEntity, Attribute referencedAttribute, NamingStandardRule nsr) {
        String ruleRelationAttribute = nsr.getRelationAttribute();
        if (ruleRelationAttribute.length() > 0) {
            String relName = "";
            if (relation != null) {
                relName = relation.getName();
            }
            String entityName = parentEntity.getName().replaceAll("\\$", "\\\\\\$");
            String entityShortName = parentEntity.getShortName().replaceAll("\\$", "\\\\\\$");
            String entityPreferredAbbreviation = parentEntity.getPreferredAbbreviation();
            String attributeName = referencedAttribute.getShortName().replaceAll("\\$", "\\\\\\$");
            String attributePreferredAbbreviation = referencedAttribute.getPreferredAbbreviation();
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{ref entity\\}", entityName);
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{ref entity short name\\}", entityShortName);
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{ref entity pref abbr\\}", entityPreferredAbbreviation != null && entityPreferredAbbreviation.length() > 0 ? entityPreferredAbbreviation : entityName);
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{relationship\\}", relName);
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{ref attribute\\}", attributeName);
            ruleRelationAttribute = ruleRelationAttribute.replaceAll("\\{ref attribute pref abbr\\}", attributePreferredAbbreviation != null && attributePreferredAbbreviation.length() > 0 ? attributePreferredAbbreviation : attributeName);
            ruleRelationAttribute = ApplyAttributesNamingStandards.process_SUBSTR_Clause(ruleRelationAttribute);
        }
        return ruleRelationAttribute;
    }
}

