/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;

public class TablespaceComparatorOracle
extends StoragePropertiesComparator {
    public static final String FILE_TYPE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.FileType");
    public static final String DISK_GROUP = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DiskGroup");
    public static final String MIN_EXTENT_LENGTH = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.MinExtLen");
    public static final String BLOCK_SIZE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.BlockSize");
    public static final String LOGGING = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.Logging");
    public static final String FORCE_LOGGING = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.ForceLogging");
    public static final String STATUS = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.Status");
    public static final String CONTENTS = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.Contents");
    public static final String DEFAULT_COMPRESSION = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DefaultCompression");
    public static final String COMPRESSION_TYPE = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.CompressionType");
    public static final String EXTENT_MANAGEMENT = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.ExtManagement");
    public static final String EM_LOCAL_SUBTYPE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.EMLocalSubType");
    public static final String EM_UNIFORM_SIZE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.EMUniformSize");
    public static final String SEGMENT_MANAGEMENT = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.SegManagement");
    public static final String FLASHBACK_MODE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.FlashbackMode");
    public static final String ENCRYPT = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.Encrypt");
    public static final String ENCRYPTION_ALGORITHM = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.EncryptionAlgorithm");
    public static final String IN_MEMORY = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemory");
    public static final String IN_MEMORY_COMPRESSION = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryCompression");
    public static final String IN_MEMORY_PRIORITY = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryPriority");
    public static final String IN_MEMORY_DISTRIBUTE = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryDistribute");
    public static final String IN_MEMORY_DUPLICATE = TablespaceComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryDuplicate");
    public static final String DS_INITIAL_EXTENT = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DSInitialExtent");
    public static final String DS_NEXT_EXTENT = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DSNextExtent");
    public static final String DS_MIN_EXTENTS = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DSMinExtents");
    public static final String DS_MAX_EXTENTS = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DSMaxExtents");
    public static final String DS_PCT_INCREASE = TablespaceComparatorOracle.getPropertyNameOracle("TableSpacePropertyDialogOracle.DSPCTIncrease");
    private TableSpaceOracle sourceTablespace;
    private TableSpaceOracle targetTablespace;

    public TablespaceComparatorOracle(TableSpaceOracle sourceTablespace, TableSpaceOracle targetTablespace) {
        super(sourceTablespace, targetTablespace);
        this.sourceTablespace = sourceTablespace;
        this.targetTablespace = targetTablespace;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceTablespace != null) {
            storageDesign = this.sourceTablespace.getStorageDesign();
        } else if (this.targetTablespace != null) {
            storageDesign = this.targetTablespace.getStorageDesign();
        }
        boolean oracle9i = storageDesign instanceof StorageDesignOraclev9i;
        this.initNameProperty();
        this.initCommentProperty();
        if (!oracle9i) {
            this.initProperty(FILE_TYPE, "fileType");
            this.initProperty(DISK_GROUP, "diskGroup");
        }
        this.initProperty(MIN_EXTENT_LENGTH, "minExtLen");
        this.initProperty(BLOCK_SIZE, "blockSize");
        this.initProperty(LOGGING, "logging");
        this.initProperty(FORCE_LOGGING, "forceLogging");
        this.initProperty(STATUS, "status");
        this.initProperty(CONTENTS, "contents");
        if (!oracle9i) {
            this.initProperty(DEFAULT_COMPRESSION, "dsCompression");
            if (storageDesign instanceof StorageDesignOraclev11g) {
                this.initProperty(COMPRESSION_TYPE, "compressionType");
            }
        }
        this.initProperty(EXTENT_MANAGEMENT, "extentManagement");
        this.initProperty(EM_LOCAL_SUBTYPE, "emLocalSubtype");
        this.initProperty(EM_UNIFORM_SIZE, "emUniformSize");
        this.initProperty(SEGMENT_MANAGEMENT, "segmentManagement");
        if (!oracle9i) {
            this.initProperty(FLASHBACK_MODE, "flashBack");
        }
        if (storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(ENCRYPT, "encrypt");
            this.initProperty(ENCRYPTION_ALGORITHM, "encryptionAlgorithm");
        }
        if (storageDesign instanceof StorageDesignOraclev12c) {
            this.initProperty(IN_MEMORY, "inMemory");
            this.initProperty(IN_MEMORY_COMPRESSION, "inMemoryCompression");
            this.initProperty(IN_MEMORY_PRIORITY, "inMemoryPriority");
            this.initProperty(IN_MEMORY_DISTRIBUTE, "inMemoryDistribute");
            this.initProperty(IN_MEMORY_DUPLICATE, "inMemoryDuplicate");
        }
        this.initProperty(DS_INITIAL_EXTENT, "dsInitialExtent");
        this.initProperty(DS_NEXT_EXTENT, "dsNextExtent");
        this.initProperty(DS_MIN_EXTENTS, "dsMinExtents");
        this.initProperty(DS_MAX_EXTENTS, "dsMaxExtents");
        this.initProperty(DS_PCT_INCREASE, "dsPctIncrease");
    }
}

