/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class PackageComparatorOracle
extends StoragePropertiesComparator {
    public static final String USER = PackageComparatorOracle.getPropertyNameOracle("DefaultPropertyDialogOracle.User");
    public static final String PACKAGE_DEFINITION = Messages.getString("PackageComparatorOracle.PackageDefinition");
    public static final String PACKAGE_BODY = Messages.getString("PackageComparatorOracle.PackageBody");
    private PackageOracle sourcePackage;
    private PackageOracle targetPackage;

    public PackageComparatorOracle(PackageOracle sourcePackage, PackageOracle targetPackage) {
        super(sourcePackage, targetPackage);
        this.sourcePackage = sourcePackage;
        this.targetPackage = targetPackage;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initNotesProperty();
        this.initProperty(USER, "owner");
        this.initPackageDefinitionProperty();
        this.initPackageBodyProperty();
    }

    private void initPackageDefinitionProperty() {
        PropertyHolder ph = new PropertyHolder(PACKAGE_DEFINITION);
        String leftSource = "";
        String rightSource = "";
        if (this.sourcePackage != null && this.sourcePackage.getSource() != null) {
            leftSource = this.sourcePackage.getSource();
        }
        if (this.targetPackage != null && this.targetPackage.getSource() != null) {
            rightSource = this.targetPackage.getSource();
        }
        ph.setLeftValue(leftSource);
        ph.setRightValue(rightSource);
        if (this.isExcludedFromComparison(PACKAGE_DEFINITION)) {
            ph.setExcluded(true);
        } else if (this.sourcePackage != null && this.targetPackage != null && this.isModified(leftSource, rightSource, false)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private void initPackageBodyProperty() {
        PropertyHolder ph = new PropertyHolder(PACKAGE_BODY);
        String leftBodySource = "";
        String rightBodySource = "";
        if (this.sourcePackage != null && this.sourcePackage.getBodySource() != null) {
            leftBodySource = this.sourcePackage.getBodySource();
        }
        if (this.targetPackage != null && this.targetPackage.getBodySource() != null) {
            rightBodySource = this.targetPackage.getBodySource();
        }
        ph.setLeftValue(leftBodySource);
        ph.setRightValue(rightBodySource);
        if (this.isExcludedFromComparison(PACKAGE_BODY)) {
            ph.setExcluded(true);
        } else if (this.sourcePackage != null && this.targetPackage != null && this.isModified(leftBodySource, rightBodySource, true)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private boolean isModified(String sourceText, String targetText, boolean isBody) {
        String targetMainPart;
        if (sourceText.equals(targetText) || sourceText.endsWith(" WRAPPED") && targetText.endsWith(" WRAPPED")) {
            return false;
        }
        String sourceMainPart = this.getMainPart(sourceText, isBody);
        return !sourceMainPart.equals(targetMainPart = this.getMainPart(targetText, isBody));
    }

    private String getMainPart(String fullText, boolean isBody) {
        String afterCreate = Token.getStringAfter(fullText, "CREATE");
        if (Token.getFirstToken(afterCreate).equalsIgnoreCase("OR")) {
            afterCreate = Token.getStringAfter(fullText, "REPLACE");
        }
        if (afterCreate.length() > 7 && afterCreate.substring(0, 7).equalsIgnoreCase("PACKAGE")) {
            String afterType = Token.getStringAfter(afterCreate, "PACKAGE");
            if (isBody) {
                afterType = afterType.length() > 4 && afterType.substring(0, 4).equalsIgnoreCase("BODY") ? Token.getStringAfter(afterType, "BODY") : "";
            }
            if (!afterType.isEmpty()) {
                return afterType;
            }
        }
        return fullText;
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(PACKAGE_DEFINITION)) {
                String defText = this.sourcePackage != null ? this.sourcePackage.getSource() : null;
                this.targetPackage.setSource(defText);
                continue;
            }
            if (!ph.getName().equals(PACKAGE_BODY)) continue;
            String bodyText = this.sourcePackage != null ? this.sourcePackage.getBodySource() : null;
            this.targetPackage.setBodySource(bodyText);
        }
        return super.getPropsToMerge();
    }
}

