/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class CWDTableComparator
extends PropertiesComparator {
    private final Table sourceTable;
    private final Table targetTable;
    private TableProxy sourceTableProxy;
    private TableProxy targetTableProxy;
    private CompareCWDDesigns selectionObject;

    public CWDTableComparator(Table table, Table entity, TableProxy sourceTableProxy, TableProxy targetTableProxy) {
        super(table, entity);
        this.sourceTable = table;
        this.targetTable = entity;
        this.sourceTableProxy = sourceTableProxy;
        this.targetTableProxy = targetTableProxy;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableToTable();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.sourceTableProxy != null || this.targetTableProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(ABBREVIATION);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getAbbreviation() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getAbbreviation() : "");
        if (this.isExcludedFromComparison(ABBREVIATION)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAbbreviation().equalsIgnoreCase(this.targetTable.getAbbreviation())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TEMP_TABLE_SCOPE);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getScope() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getScope() : "");
        if (this.isExcludedFromComparison(TEMP_TABLE_SCOPE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getScope().equals(this.targetTable.getScope())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TABLE_TYPE);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.sourceTable.getTypeID()) : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.targetTable.getTypeID()) : "");
        if (this.isExcludedFromComparison(TABLE_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getTypeID().equals(this.targetTable.getTypeID())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MIN_VOLUMES);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getMinVolumes() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getMinVolumes() : "");
        if (this.isExcludedFromComparison(MIN_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMinVolumes().equals(this.targetTable.getMinVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(EXPECTED_VOLUMES);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getExpectedVolumes() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getExpectedVolumes() : "");
        if (this.isExcludedFromComparison(EXPECTED_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getExpectedVolumes().equals(this.targetTable.getExpectedVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_VOLUMES);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getMaxVolumes() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getMaxVolumes() : "");
        if (this.isExcludedFromComparison(MAX_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMaxVolumes().equals(this.targetTable.getMaxVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GROWTH_PERCENT);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthPercent() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getGrowthPercent() : "");
        if (this.isExcludedFromComparison(GROWTH_PERCENT)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthPercent().equals(this.targetTable.getGrowthPercent())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GROWTH_TYPE);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthType() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getGrowthType() : "");
        if (this.isExcludedFromComparison(GROWTH_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthType().equals(this.targetTable.getGrowthType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NORMAL_FORM);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getNormalForm() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getNormalForm() : "");
        if (this.isExcludedFromComparison(NORMAL_FORM)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getNormalForm().equals(this.targetTable.getNormalForm())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ADEQUATELY_NORMALIZED);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getAdequatelyNormalized() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getAdequatelyNormalized() : "");
        if (this.isExcludedFromComparison(ADEQUATELY_NORMALIZED)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAdequatelyNormalized().equals(this.targetTable.getAdequatelyNormalized())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS_ORDER);
        ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
        ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
        if (this.isExcludedFromComparison(COLUMNS_ORDER)) {
            ph.setExcluded(true);
        } else {
            if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                ph.setSelected(true);
                ph.setModified(true);
            }
            if (!this.useColumnsOrder) {
                ph.setSelected(false);
            }
        }
        this.propertiesList.add(ph);
    }

    private void copyPropertiesFromTableToTable() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.targetTable.setScope(this.sourceTable.getScope());
                    continue;
                }
                if (ph.getName().equals(TABLE_TYPE)) {
                    this.targetTable.setTypeID(this.sourceTable.getTypeID());
                    continue;
                }
                if (ph.getName().equals(ABBREVIATION)) {
                    this.targetTable.setAbbreviation(this.sourceTable.getAbbreviation());
                    continue;
                }
                if (ph.getName().equals(MIN_VOLUMES)) {
                    this.targetTable.setMinVolumes(this.sourceTable.getMinVolumes());
                    continue;
                }
                if (ph.getName().equals(EXPECTED_VOLUMES)) {
                    this.targetTable.setExpectedVolumes(this.sourceTable.getExpectedVolumes());
                    continue;
                }
                if (ph.getName().equals(MAX_VOLUMES)) {
                    this.targetTable.setMaxVolumes(this.sourceTable.getMaxVolumes());
                    continue;
                }
                if (ph.getName().equals(GROWTH_PERCENT)) {
                    this.targetTable.setGrowthPercent(this.sourceTable.getGrowthPercent());
                    continue;
                }
                if (ph.getName().equals(GROWTH_TYPE)) {
                    this.targetTable.setGrowthType(this.sourceTable.getGrowthType());
                    continue;
                }
                if (ph.getName().equals(NORMAL_FORM)) {
                    this.targetTable.setNormalForm(this.sourceTable.getNormalForm());
                    continue;
                }
                if (ph.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.targetTable.setAdequatelyNormalized(this.sourceTable.getAdequatelyNormalized());
                    continue;
                }
                if (!ph.getName().equals(SCHEMA) || this.sourceTableProxy == null || this.targetTableProxy == null || this.sourceTableProxy.getUserSchema() == null) continue;
                this.targetTableProxy.setUserSchema(this.sourceTableProxy.getUserSchema().getName());
            }
        }
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        return this.sourceTable != null ? MessageFormat.format(Messages.getString("CWDTableComparator.SourceTable"), this.sourceTable.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetTable != null ? MessageFormat.format(Messages.getString("CWDTableComparator.TargetTable"), this.targetTable.getName()) : "";
    }

    private String getElementsToString(Table table) {
        StringBuffer sb = new StringBuffer();
        Iterator<ContainedObject> it = Arrays.asList(table.getElements()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }

    private boolean equalColumnOrder(Table sourseTable, Table targetTable) {
        if (this.sourceTable == null || targetTable == null) {
            return true;
        }
        ContainedObject[] sourseColumns = sourseTable.getElements();
        ContainedObject[] targetColumns = targetTable.getElements();
        for (int i = 0; i < sourseColumns.length; ++i) {
            if (i > targetColumns.length - 1) {
                return true;
            }
            Column sCol = (Column)sourseColumns[i];
            Column tCol = (Column)targetColumns[i];
            if (tCol.getImportedId() != null && sCol.getObjectID().equals(tCol.getImportedId()) || tCol.getName().equals(sCol.getName()) || tCol.getDataType().toString().equals(sCol.getDataType().toString()) && sCol.getContainer().getElementByName(tCol.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private boolean equalColumnsOrderNew(Table sourseTable, Table targetTable) {
        if (this.getLeftSelectionObject() != null) {
            CompareCWDDesigns[] cnodes = this.getColumnNodes(this.getSelectionObject());
            for (int i = 0; i < cnodes.length; ++i) {
                Column rcolumn;
                CompareCWDDesigns colnode = cnodes[i];
                if (colnode.getStatus() == 2 && this.isBeforeUnchangedColumn(i, cnodes)) {
                    return false;
                }
                if (colnode.getStatus() != 0 && colnode.getStatus() != 1 || (rcolumn = (Column)colnode.getCorrespondentNode().getObject()) == null || i == rcolumn.getIndex()) continue;
                return false;
            }
            return true;
        }
        return this.equalColumnOrder(sourseTable, targetTable);
    }

    private CompareCWDDesigns[] getColumnNodes(CompareCWDDesigns tableNode) {
        ArrayList<CompareCWDDesigns> list = new ArrayList<CompareCWDDesigns>();
        CompareCWDDesigns columns = (CompareCWDDesigns)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareCWDDesigns cnode = (CompareCWDDesigns)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            list.add(cnode);
        }
        return list.toArray(new CompareCWDDesigns[0]);
    }

    private boolean isBeforeUnchangedColumn(int index, CompareCWDDesigns[] columns) {
        for (int i = index + 1; i < columns.length; ++i) {
            if (columns[i].getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || (!ph.getName().equals(SCHEMA) || this.settings != null && !this.settings.isIncludeSchemaInDDL()) && !ph.getName().equals(STRUCTURED_TYPE) && !ph.getName().equals(SPATIAL_TABLE) && (!ph.getName().equals(COLUMNS_ORDER) || this.equalColumnsOrderNew(this.sourceTable, this.targetTable))) continue;
                return true;
            }
            return this.hasCreateProperties();
        }
        return false;
    }

    @Override
    protected boolean hasToBeRenameOnly() {
        if (!this.hasToBeRename() && this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(NAME)) continue;
                return ph.isSelected();
            }
        }
        return false;
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTable == null && this.targetTable != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    protected void initSchemaProperty() {
        if (this.sourceTableProxy != null && this.targetTableProxy != null && this.sourceTableProxy.getStorageDesign().isOpen() && this.targetTableProxy.getStorageDesign().isOpen()) {
            PropertyHolder ph = new PropertyHolder(SCHEMA);
            ph.setLeftValue(this.sourceTableProxy != null && this.sourceTableProxy.getUserSchema() != null ? this.sourceTableProxy.getUserSchema().getName() : "");
            ph.setRightValue(this.targetTableProxy != null && this.targetTableProxy.getUserSchema() != null ? this.targetTableProxy.getUserSchema().getName() : "");
            if (this.isExcludedFromComparison(SCHEMA)) {
                ph.setExcluded(true);
            } else if (this.caseSensitive) {
                if (!ph.getLeftValue().equals(ph.getRightValue())) {
                    ph.setModified(true);
                    if (this.useSchema) {
                        ph.setSelected(true);
                    } else {
                        ph.setFiltered(true);
                    }
                }
            } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
            this.propertiesList.add(ph);
        }
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public TableProxy getSourceTableProxy() {
        return this.sourceTableProxy;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableProxy getTargetTableProxy() {
        return this.targetTableProxy;
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                CompareCWDDesigns[] nodes = this.getColumnNodes(this.getSelectionObject());
                ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(nodes) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                } else {
                    ph.setSelected(false);
                    ph.setModified(false);
                }
            } else {
                ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
                ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                ph.setSelected(false);
            }
        }
    }

    private String getElementsToString(CompareCWDDesigns[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }
}

