/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;

public class ValidTimeDimensionComparator
extends PropertiesComparator {
    private ValidTimeDimension sourceTimeDim;
    private ValidTimeDimension targetTimeDim;

    public ValidTimeDimensionComparator(ValidTimeDimension sourceTimeDim, ValidTimeDimension targetTimeDim) {
        super(sourceTimeDim, targetTimeDim);
        this.sourceTimeDim = sourceTimeDim;
        this.targetTimeDim = targetTimeDim;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(START_TIME_COLUMN);
        ph.setLeftValue(this.sourceTimeDim != null && this.sourceTimeDim.getStartTimeColumn() != null ? this.sourceTimeDim.getStartTimeColumn().getName() : "");
        ph.setRightValue(this.targetTimeDim != null && this.targetTimeDim.getStartTimeColumn() != null ? this.targetTimeDim.getStartTimeColumn().getName() : "");
        if (this.isExcludedFromComparison(START_TIME_COLUMN)) {
            ph.setExcluded(true);
        } else if (this.targetTimeDim != null && this.sourceTimeDim != null && !ph.getRightValue().equals(ph.getLeftValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(END_TIME_COLUMN);
        ph.setLeftValue(this.sourceTimeDim != null && this.sourceTimeDim.getEndTimeColumn() != null ? this.sourceTimeDim.getEndTimeColumn().getName() : "");
        ph.setRightValue(this.targetTimeDim != null && this.targetTimeDim.getEndTimeColumn() != null ? this.targetTimeDim.getEndTimeColumn().getName() : "");
        if (this.isExcludedFromComparison(END_TIME_COLUMN)) {
            ph.setExcluded(true);
        } else if (this.targetTimeDim != null && this.sourceTimeDim != null && !ph.getRightValue().equals(ph.getLeftValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        if (this.sourceTimeDim != null && this.targetTimeDim != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(START_TIME_COLUMN)) {
                    Column targetStartColumn = null;
                    Column sourceStartColumn = this.sourceTimeDim.getStartTimeColumn();
                    if (sourceStartColumn != null) {
                        targetStartColumn = (Column)AbstractMerging.objectsMap.get(sourceStartColumn.getObjectID());
                    }
                    this.targetTimeDim.setStartTimeColumn(targetStartColumn);
                }
                if (!ph.getName().equals(END_TIME_COLUMN)) continue;
                Column targetEndColumn = null;
                Column sourceEndColumn = this.sourceTimeDim.getEndTimeColumn();
                if (sourceEndColumn != null) {
                    targetEndColumn = (Column)AbstractMerging.objectsMap.get(sourceEndColumn.getObjectID());
                }
                this.targetTimeDim.setEndTimeColumn(targetEndColumn);
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTimeDim == null && this.targetTimeDim != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

