/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.JobArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerJob
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_JOB";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_JOBS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_JOBS";
    public static final String DBA_ARGS_TABLE = "SYS.DBA_SCHEDULER_JOB_ARGS";
    public static final String ALL_ARGS_TABLE = "SYS.ALL_SCHEDULER_JOB_ARGS";

    public MOHSchedulerJob(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        String args_sql = this.getArgumentsSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        PreparedStatement statement_a = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerJob job = new SchedulerJob();
                for (String prop : job.getPropsList()) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    job.setProperty(prop, value);
                }
                res.add(job);
                job.validate();
                rs.close();
                String pname = job.getProgramName();
                if (job.getNumberOfArguments() <= 0 && pname == null) continue;
                if (statement_a == null) {
                    statement_a = conn.prepareStatement(args_sql);
                }
                this.processArguments(conn, statement_a, job, dbo);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select\nj.OWNER,\nj.JOB_NAME,\nj.JOB_SUBNAME,\nj.JOB_STYLE,\nj.JOB_CREATOR,\nj.CLIENT_ID,\nj.GLOBAL_UID,\nj.PROGRAM_OWNER,\nj.PROGRAM_NAME,\nj.JOB_TYPE,\nj.JOB_ACTION,\nj.NUMBER_OF_ARGUMENTS,\nj.SCHEDULE_OWNER,\nj.SCHEDULE_NAME,\nj.SCHEDULE_TYPE,\nto_char( j.START_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as START_DATE,\nj.REPEAT_INTERVAL,\nj.EVENT_QUEUE_OWNER,\nj.EVENT_QUEUE_NAME,\nj.EVENT_QUEUE_AGENT,\nj.EVENT_CONDITION,\nj.EVENT_RULE,\nj.FILE_WATCHER_OWNER,\nj.FILE_WATCHER_NAME,\nto_char( j.END_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as END_DATE,\nj.JOB_CLASS,\nj.ENABLED,\nj.AUTO_DROP,\nj.RESTART_ON_RECOVERY,\nj.RESTART_ON_FAILURE,\nj.STATE,\nj.JOB_PRIORITY,\nj.RUN_COUNT,\nj.UPTIME_RUN_COUNT,\nj.MAX_RUNS,\nj.FAILURE_COUNT,\nj.UPTIME_FAILURE_COUNT,\nj.MAX_FAILURES,\nj.RETRY_COUNT,\nto_char( j.LAST_START_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as LAST_START_DATE,\nj.LAST_RUN_DURATION,\nto_char( j.NEXT_RUN_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as NEXT_RUN_DATE,\ncase\nwhen j.SCHEDULE_LIMIT is not null then\nreplace(to_char(cast(j.SCHEDULE_LIMIT as interval day(3) to second(0)),'DD\" \" HH24:MI:SS'),'+0','+') \nelse null end as SCHEDULE_LIMIT,\ncase\nwhen j.MAX_RUN_DURATION is not null then\nreplace(to_char(cast(j.MAX_RUN_DURATION as interval day(3) to second(0)),'DD\" \" HH24:MI:SS'),'+0','+') \nelse null end as MAX_RUN_DURATION,\nj.LOGGING_LEVEL,\nj.STORE_OUTPUT,\nj.STOP_ON_WINDOW_CLOSE,\nj.INSTANCE_STICKINESS,\nj.RAISE_EVENTS,\nj.SYSTEM,\nj.JOB_WEIGHT,\nj.NLS_ENV,\nj.SOURCE,\nj.NUMBER_OF_DESTINATIONS,\nj.DESTINATION_OWNER,\nj.DESTINATION,\nj.CREDENTIAL_OWNER,\nj.CREDENTIAL_NAME,\nj.INSTANCE_ID,\nj.DEFERRED_DROP,\nj.ALLOW_RUNS_IN_RESTRICTED_MODE,\nj.COMMENTS,\nj.FLAGS,\nj.RESTARTABLE,\nj.HAS_CONSTRAINTS,\nj.CONNECT_CREDENTIAL_OWNER,\nj.CONNECT_CREDENTIAL_NAME,\nj.FAIL_ON_SCRIPT_ERROR,\ndecode(bitand(j.flags,2147483648),0,'FALSE','TRUE') PARALLEL_INSTANCES \nfrom " + (dba ? DBA_TABLE : ALL_TABLE) + " j\nwhere j.owner = ? and j.JOB_NAME = ?";
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArguments(Connection conn, PreparedStatement statement, SchedulerJob job, DBObject dbo) {
        ResultSet rs = null;
        try {
            statement.setString(1, dbo.getSchema());
            statement.setString(2, dbo.getName());
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    JobArgument arg = new JobArgument();
                    for (String prop : arg.getPropsList()) {
                        String value = null;
                        try {
                            value = rs.getString(prop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("propname - " + prop);
                        }
                        arg.setProperty(prop, value);
                    }
                    job.addArgument(arg);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
        }
    }

    String getArgumentsSQL(boolean dba) {
        String sql = "select\n--p.OWNER,\n--p.JOB_NAME,\np.ARGUMENT_NAME,\np.ARGUMENT_POSITION,\np.ARGUMENT_TYPE,\np.VALUE --,\n--p.ANYDATA_VALUE\n--p.OUT_ARGUMENT\nfrom " + (dba ? DBA_ARGS_TABLE : ALL_ARGS_TABLE) + " p \nwhere p.owner = ? and p.JOB_NAME = ? \norder by p.ARGUMENT_POSITION";
        return sql;
    }
}

