/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHRoleOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ROLE";
    private static final Logger LOGGER = new Logger(MOHRoleOraclev9i.class);
    protected boolean dbaUser;
    PreparedStatement systemPrivilegesStmt = null;

    public MOHRoleOraclev9i(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        PreparedStatement statement = null;
        this.systemPrivilegesStmt = null;
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo;
                block28: {
                    block26: {
                        dbo = (DBObject)selectedObjects.get(i);
                        if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                        if (storageDesign == null) break block26;
                        RoleOraclev9i role = (RoleOraclev9i)storageDesign.getRoleSet().createRole();
                        String name = dbo.getName();
                        role.setName(name);
                        if (storageDesign.isSeededRole(name)) {
                            role.setIsNullInstance(true);
                            role.setStorableNullInstance(true);
                        }
                        if (this.dbaUser) {
                            ResultSet rs;
                            block24: {
                                rs = null;
                                try {
                                    if (statement == null) {
                                        StringBuffer buffer = new StringBuffer();
                                        buffer.append("SELECT").append(' ');
                                        if (!(storageDesign instanceof StorageDesignOraclev12c)) {
                                            buffer.append("PASSWORD_REQUIRED").append(' ').append("AS").append(' ');
                                        }
                                        buffer.append("AUTHENTICATION_TYPE").append(',');
                                        buffer.append("SCHEMA").append(',');
                                        buffer.append("PACKAGE").append(' ');
                                        buffer.append("FROM").append(' ');
                                        buffer.append("dba_roles").append(' ').append("a").append(',');
                                        buffer.append("dba_application_roles").append(' ').append("b").append(' ');
                                        buffer.append("WHERE").append(' ');
                                        buffer.append("a.").append(OBJECT_TYPE).append('=').append('?').append(' ');
                                        buffer.append("AND").append(' ');
                                        buffer.append("a.").append(OBJECT_TYPE).append('=').append("b.").append(OBJECT_TYPE).append(' ').append("(+)");
                                        statement = sqlConnection.prepareStatement(buffer.toString());
                                    }
                                    statement.setString(1, name);
                                    rs = statement.executeQuery();
                                    if (rs == null) break block24;
                                    if (rs.next()) {
                                        String identification = rs.getString("AUTHENTICATION_TYPE");
                                        String role_schema = rs.getString("SCHEMA");
                                        String role_package = rs.getString("PACKAGE");
                                        if ("PASSWORD".equalsIgnoreCase(identification)) {
                                            role.setIdentified("YES");
                                            role.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                                        } else if ("EXTERNAL".equalsIgnoreCase(identification)) {
                                            role.setIdentified("YES");
                                            role.setAuthType(RoleOraclev9i.getAuthTypes()[1]);
                                        } else if ("GLOBAL".equalsIgnoreCase(identification)) {
                                            role.setIdentified("YES");
                                            role.setAuthType(RoleOraclev9i.getAuthTypes()[2]);
                                        } else if ("APPLICATION".equalsIgnoreCase(identification) || "YES".equalsIgnoreCase(identification)) {
                                            role.setIdentified("YES");
                                            if (role_schema != null && !"".equalsIgnoreCase(role_schema) && role_package != null && !"".equalsIgnoreCase(role_package)) {
                                                role.setAuthType("USING PACKAGE");
                                                role.setSchema(role_schema);
                                                role.setPack(role_package);
                                            } else {
                                                role.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                                            }
                                        }
                                    }
                                    rs.close();
                                }
                                catch (SQLException se) {
                                    block25: {
                                        if (se.getMessage().startsWith("ORA-00942")) {
                                            LOGGER.error("MOHRoleOraclev9i.generate(): current connection user has no SELECT privilege on dba_roles dba_application_roles");
                                            break block25;
                                        }
                                        LOGGER.error("MOHRoleOraclev9i.generate():", se);
                                    }
                                    Closeables.close((Object)rs);
                                }
                                catch (Exception e) {
                                    LOGGER.error("MOHRoleOraclev9i.generate():", e);
                                    {
                                        catch (Throwable throwable) {
                                            Closeables.close(rs);
                                            throw throwable;
                                        }
                                    }
                                    Closeables.close((Object)rs);
                                }
                            }
                            Closeables.close((Object)rs);
                        }
                        this.setSystemPrivileges(role, sqlConnection);
                        this.stampModelObject(role, dbo);
                        break block28;
                    }
                    LOGGER.error("Unable to find Storage Design");
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.systemPrivilegesStmt, statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.systemPrivilegesStmt, statement});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setSystemPrivileges(RoleOracle role, Connection sqlConnection) throws SQLException {
        block12: {
            ResultSet rs = null;
            try {
                if (this.systemPrivilegesStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("PRIVILEGE").append(',');
                    buffer.append("ADMIN_OPTION").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? "dba_sys_privs" : "role_sys_privs").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append(this.dbaUser ? "GRANTEE" : OBJECT_TYPE).append('=').append('?');
                    this.systemPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                this.systemPrivilegesStmt.setString(1, role.getName());
                rs = this.systemPrivilegesStmt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        String privilege = rs.getString("PRIVILEGE");
                        String adminOption = rs.getString("ADMIN_OPTION");
                        if ("YES".equalsIgnoreCase(adminOption)) {
                            role.setPrivilegesWithAdminOption(privilege);
                            continue;
                        }
                        role.setPrivileges(privilege);
                    }
                    rs.close();
                }
                Closeables.close((Object)rs);
            }
            catch (SQLException se) {
                block13: {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_sys_privs" : "role_sys_privs"));
                        break block13;
                    }
                    LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges():", se);
                }
                Closeables.close((Object)rs);
            }
            catch (Exception e) {
                LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges():", e);
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closeables.close(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws SQLException {
        ResultSet rs;
        Statement statement;
        ArrayList<DBObject> list;
        block13: {
            list = new ArrayList<DBObject>();
            statement = sqlConnection.createStatement();
            rs = null;
            try {
                String filterCondition;
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                if (this.dbaUser) {
                    filterCondition = this.getFilterConditionOracle(OBJECT_TYPE);
                    buffer.append(OBJECT_TYPE).append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append("dba_roles").append(' ');
                    if (filterCondition != null) {
                        buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                    }
                } else {
                    filterCondition = this.getFilterConditionOracle("GRANTED_ROLE");
                    buffer.append("GRANTED_ROLE").append(' ').append("AS").append(' ').append(OBJECT_TYPE).append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append("user_role_privs").append(' ');
                    if (filterCondition != null) {
                        buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("UNION").append(' ');
                    buffer.append("SELECT").append(' ');
                    buffer.append("GRANTED_ROLE").append(' ').append("AS").append(' ').append(OBJECT_TYPE).append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append("ROLE_ROLE_PRIVS").append(' ');
                    if (filterCondition != null) {
                        buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                    }
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append(OBJECT_TYPE);
                rs = statement.executeQuery(buffer.toString());
                if (rs == null) break block13;
                while (rs.next()) {
                    String roleName = rs.getString(OBJECT_TYPE);
                    DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), roleName, OBJECT_TYPE);
                    list.add(dboUser);
                }
                rs.close();
            }
            catch (SQLException se) {
                block14: {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        LOGGER.error("MOHRoleOraclev9i.extract(): current connection user has no SELECT privilege on dba_roles");
                        break block14;
                    }
                    LOGGER.error("MOHRoleOraclev9i.extract():", se);
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
            catch (Exception e) {
                LOGGER.error("MOHRoleOraclev9i.extract():", e);
                {
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        block19: {
            try {
                StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                if (storageDesign == null) break block19;
                PreparedStatement getRoleRolePrivsStatement = null;
                try {
                    for (DBObject dbObj : this.handledObjects) {
                        if (dbObj == null) continue;
                        RoleSetOracle roleSet = storageDesign.getRoleSet();
                        RoleOraclev9i role = (RoleOraclev9i)roleSet.getByName(dbObj.getName());
                        if (getRoleRolePrivsStatement == null) {
                            try {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("SELECT");
                                buffer.append(' ').append("GRANTED_ROLE");
                                buffer.append(',').append("ADMIN_OPTION");
                                buffer.append(' ').append("FROM").append(' ');
                                buffer.append(this.dbaUser ? "dba_role_privs" : "ROLE_ROLE_PRIVS").append(' ');
                                buffer.append("WHERE").append(' ');
                                buffer.append(this.dbaUser ? "GRANTEE" : OBJECT_TYPE).append('=').append('?');
                                getRoleRolePrivsStatement = sqlConnection.prepareStatement(buffer.toString());
                            }
                            catch (SQLException se) {
                                if (se.getMessage().startsWith("ORA-00942")) {
                                    LOGGER.error("MOHRoleOraclev9i.postGenerateProcessing(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_role_privs" : "ROLE_ROLE_PRIVS"));
                                } else {
                                    LOGGER.error("MOHRoleOraclev9i.postGenerateProcessing():", se);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("MOHRoleOraclev9i.postGenerateProcessing():", e);
                            }
                        }
                        getRoleRolePrivsStatement.setString(1, dbObj.getName());
                        ResultSet rs = getRoleRolePrivsStatement.executeQuery();
                        try {
                            if (rs == null) continue;
                            while (rs.next()) {
                                RoleOraclev9i subRole;
                                String granted_role = rs.getString("GRANTED_ROLE");
                                String adminOption = rs.getString("ADMIN_OPTION");
                                if (granted_role == null || "".equalsIgnoreCase(granted_role) || (subRole = (RoleOraclev9i)roleSet.getByName(granted_role)) == null) continue;
                                if ("YES".equalsIgnoreCase(adminOption)) {
                                    role.setRolesWithAdminOption(subRole.getObjectID());
                                    continue;
                                }
                                role.setRoles(subRole.getObjectID());
                            }
                            rs.close();
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                }
                finally {
                    Closeables.close(getRoleRolePrivsStatement);
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHRoleOraclev9i.postGenerateProcessing():", e);
            }
        }
    }
}

