/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;

public class SSBDropIndex
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && !((Index)object).isFK() && ((Index)object).isDropEnabled() && !((Index)object).shouldBeDroppedIndirectly()) {
            return true;
        }
        return object instanceof IndexProxy && !((IndexProxy)object).getIndex().isFK() && ((IndexProxy)object).isDropEnabled() && !((IndexProxy)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        ModelIDObject mdObject = null;
        if (object == null) {
            return;
        }
        if (object instanceof Index || object instanceof IndexProxy) {
            StorageDesign storageDesign;
            mdObject = (ModelIDObject)object;
            if (mdObject instanceof IndexProxy) {
                storageDesign = ((IndexProxy)mdObject).getStorageDesign();
            } else {
                Design design = mdObject.getDesign();
                RDBMSSite site = mdObject.getSelectedRDBMSSite();
                storageDesign = design.getStorageDesign(site);
            }
            this.appendDrop(buffer);
            SSBDropIndex.appendStringWithSpace(buffer, "INDEX");
            if (mdObject instanceof IndexProxyOracle) {
                SSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(mdObject));
            } else {
                SSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedName(mdObject.getLongName()));
            }
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropIndex.appendNewLine(buffer, prettyPrint, 0);
            SSBDropIndex.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        }
    }
}

