/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.responses;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateProtectedDatabaseResponse
extends BmcResponse {
    private String location;
    private String etag;
    private String opcWorkRequestId;
    private String opcRequestId;
    private ProtectedDatabase protectedDatabase;

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ProtectedDatabase getProtectedDatabase() {
        return this.protectedDatabase;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "location", "etag", "opcWorkRequestId", "opcRequestId", "protectedDatabase"})
    private CreateProtectedDatabaseResponse(int __httpStatusCode__, Map<String, List<String>> headers, String location, String etag, String opcWorkRequestId, String opcRequestId, ProtectedDatabase protectedDatabase) {
        super(__httpStatusCode__, headers);
        this.location = location;
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.protectedDatabase = protectedDatabase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",protectedDatabase=").append(String.valueOf((Object)this.protectedDatabase));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateProtectedDatabaseResponse)) {
            return false;
        }
        CreateProtectedDatabaseResponse other = (CreateProtectedDatabaseResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.protectedDatabase, (Object)other.protectedDatabase);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.protectedDatabase == null ? 43 : this.protectedDatabase.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateProtectedDatabaseResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String location;
        private String etag;
        private String opcWorkRequestId;
        private String opcRequestId;
        private ProtectedDatabase protectedDatabase;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder protectedDatabase(ProtectedDatabase protectedDatabase) {
            this.protectedDatabase = protectedDatabase;
            return this;
        }

        public Builder copy(CreateProtectedDatabaseResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.protectedDatabase(o.getProtectedDatabase());
            return this;
        }

        public CreateProtectedDatabaseResponse build() {
            return new CreateProtectedDatabaseResponse(this.__httpStatusCode__, this.headers, this.location, this.etag, this.opcWorkRequestId, this.opcRequestId, this.protectedDatabase);
        }
    }
}

