/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRecoveryServiceSubnetRequest
extends BmcRequest<Void> {
    private String recoveryServiceSubnetId;
    private String opcRequestId;

    public String getRecoveryServiceSubnetId() {
        return this.recoveryServiceSubnetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().recoveryServiceSubnetId(this.recoveryServiceSubnetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",recoveryServiceSubnetId=").append(String.valueOf(this.recoveryServiceSubnetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRecoveryServiceSubnetRequest)) {
            return false;
        }
        GetRecoveryServiceSubnetRequest other = (GetRecoveryServiceSubnetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.recoveryServiceSubnetId, other.recoveryServiceSubnetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recoveryServiceSubnetId == null ? 43 : this.recoveryServiceSubnetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRecoveryServiceSubnetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String recoveryServiceSubnetId = null;
        private String opcRequestId = null;

        public Builder recoveryServiceSubnetId(String recoveryServiceSubnetId) {
            this.recoveryServiceSubnetId = recoveryServiceSubnetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRecoveryServiceSubnetRequest o) {
            this.recoveryServiceSubnetId(o.getRecoveryServiceSubnetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRecoveryServiceSubnetRequest build() {
            GetRecoveryServiceSubnetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRecoveryServiceSubnetRequest buildWithoutInvocationCallback() {
            GetRecoveryServiceSubnetRequest request = new GetRecoveryServiceSubnetRequest();
            request.recoveryServiceSubnetId = this.recoveryServiceSubnetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

