/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class FetchProtectedDatabaseConfigurationRequest
extends BmcRequest<FetchProtectedDatabaseConfigurationDetails> {
    private String protectedDatabaseId;
    private FetchProtectedDatabaseConfigurationDetails fetchProtectedDatabaseConfigurationDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getProtectedDatabaseId() {
        return this.protectedDatabaseId;
    }

    public FetchProtectedDatabaseConfigurationDetails getFetchProtectedDatabaseConfigurationDetails() {
        return this.fetchProtectedDatabaseConfigurationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public FetchProtectedDatabaseConfigurationDetails getBody$() {
        return this.fetchProtectedDatabaseConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().protectedDatabaseId(this.protectedDatabaseId).fetchProtectedDatabaseConfigurationDetails(this.fetchProtectedDatabaseConfigurationDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",protectedDatabaseId=").append(String.valueOf(this.protectedDatabaseId));
        sb.append(",fetchProtectedDatabaseConfigurationDetails=").append(String.valueOf((Object)this.fetchProtectedDatabaseConfigurationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchProtectedDatabaseConfigurationRequest)) {
            return false;
        }
        FetchProtectedDatabaseConfigurationRequest other = (FetchProtectedDatabaseConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.protectedDatabaseId, other.protectedDatabaseId) && Objects.equals((Object)this.fetchProtectedDatabaseConfigurationDetails, (Object)other.fetchProtectedDatabaseConfigurationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.protectedDatabaseId == null ? 43 : this.protectedDatabaseId.hashCode());
        result = result * 59 + (this.fetchProtectedDatabaseConfigurationDetails == null ? 43 : this.fetchProtectedDatabaseConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<FetchProtectedDatabaseConfigurationRequest, FetchProtectedDatabaseConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String protectedDatabaseId = null;
        private FetchProtectedDatabaseConfigurationDetails fetchProtectedDatabaseConfigurationDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder protectedDatabaseId(String protectedDatabaseId) {
            this.protectedDatabaseId = protectedDatabaseId;
            return this;
        }

        public Builder fetchProtectedDatabaseConfigurationDetails(FetchProtectedDatabaseConfigurationDetails fetchProtectedDatabaseConfigurationDetails) {
            this.fetchProtectedDatabaseConfigurationDetails = fetchProtectedDatabaseConfigurationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FetchProtectedDatabaseConfigurationRequest o) {
            this.protectedDatabaseId(o.getProtectedDatabaseId());
            this.fetchProtectedDatabaseConfigurationDetails(o.getFetchProtectedDatabaseConfigurationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FetchProtectedDatabaseConfigurationRequest build() {
            FetchProtectedDatabaseConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(FetchProtectedDatabaseConfigurationDetails body) {
            this.fetchProtectedDatabaseConfigurationDetails(body);
            return this;
        }

        public FetchProtectedDatabaseConfigurationRequest buildWithoutInvocationCallback() {
            FetchProtectedDatabaseConfigurationRequest request = new FetchProtectedDatabaseConfigurationRequest();
            request.protectedDatabaseId = this.protectedDatabaseId;
            request.fetchProtectedDatabaseConfigurationDetails = this.fetchProtectedDatabaseConfigurationDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

