/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.base.JacksonJsonValue;
import com.github.wnameless.json.base.JsonCore;
import java.io.IOException;
import java.io.Reader;

public class JacksonJsonCore
implements JsonCore<JacksonJsonValue> {
    private ObjectMapper mapper;

    private ObjectMapper getInstance() {
        return this.mapper == null ? LazyHolder.INSTANCE : this.mapper;
    }

    public JacksonJsonCore() {
        this.mapper = null;
    }

    public JacksonJsonCore(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        this.mapper = mapper;
    }

    public JacksonJsonValue parse(String json) {
        try {
            return new JacksonJsonValue(this.getInstance().readTree(json));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JacksonJsonValue parse(Reader jsonReader) throws IOException {
        return new JacksonJsonValue(this.getInstance().readTree(jsonReader));
    }

    private static class LazyHolder {
        public static final ObjectMapper INSTANCE = new ObjectMapper();

        private LazyHolder() {
        }
    }
}

