/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.container;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

class Services {
    private final Map<Class<?>, Object> services;

    private Services(Map<Class<?>, Object> services) {
        this.services = new LinkedHashMap(services);
    }

    static Services of() {
        return Services.of(Map.of());
    }

    static Services of(Map<Class<?>, Object> services) {
        return new Services(services);
    }

    <T> Optional<T> find(Class<T> type) {
        return Optional.ofNullable(type.cast(this.services.get(type)));
    }

    public <T> Services set(Class<T> serviceType, T service) {
        this.services.put(serviceType, service);
        return this;
    }
}

