/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlTool
implements McpTool {
    private final String toolName = "run-sql";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("run-sql", "This tool executes SQL queries in an Oracle database. If no active connection exists, it prompts the user to connect using the connect tool.\n\nYou should:\n\n\tExecute the provided SQL query.\n\n\tReturn the results in CSV format.\n\nArgs:\n\n\tsql: The SQL query to execute.\n\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\n\nReturns:\n\n\tCSV-formatted query results.\n", "  {\n      \"type\" : \"object\",\n      \"id\" : \"urn:jsonschema:Operation\",\n      \"properties\" : {\n        \"sql\" : {\n          \"type\" : \"string\",\n          \"description\": \"The SQL query to execute\"\n        },\n        \"mcp_client\" : {\n          \"type\" : \"string\",\n          \"description\": \"Specify the name and version of the MCP client implementation being used (e.g. Copilot, Claude, Cline...)\",\n          \"default\": \"UNKNOWN-MCP-CLIENT\"\n        },\n        \"model\" : {\n          \"type\" : \"string\",\n          \"description\": \"The name (and version) of the language model being used by the MCP client to process requests (e.g. gpt-4.1, claude-sonnet-4, llama4...\",\n          \"default\": \"UNKNOWN-LLM\"\n        }\n      },\n      \"required\": [\"sql\"]\n   }\n"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents;
            block5: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    String sql = McpUtils.requiredArgument(arguments, "sql");
                    String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                    String mcp_client = McpUtils.optionalArgument(arguments, "mcp_client", McpUtils.MCP_CLIENT_DEFAULT_VALUE);
                    if (ctx.getCurrentConnection() != null) {
                        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ctx).connection(ctx.getCurrentConnection()).build();
                        try {
                            this.createMcpLogTable(ctx.getCurrentConnection());
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        String injectedComment = "/* LLM in use is " + McpUtils.sanitizeSqlComments(model) + " */";
                        sql = McpUtils.injectAfterFirstWord(sql, injectedComment);
                        QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "run-sql", model);
                        QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                        QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "run-sql", SqlRecognizer.reductPwd((String)sql));
                        ctx.putProperty("sql.format", (Object)"CSV");
                        contents.add(new McpSchema.TextContent(sqlcl.run(sql)));
                        break block5;
                    }
                    contents.add(new McpSchema.TextContent("Connection not established"));
                }
                catch (SQLException | ArgumentException e) {
                    return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

