/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.ConnectionUtils;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ListConnectionsTool
implements McpTool {
    private final String toolName = "list-connections";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("list-connections", "List all available oracle named/saved connections in the connections storage\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\n", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"filter\" : {\n      \"type\" : \"string\",\n      \"description\": \"This is the filter that will be used to refine the list of connections\",\n      \"default\": \"\"\n    },\n    \"mcp_client\" : {\n      \"type\" : \"string\",\n      \"description\": \"Specify the name and version of the MCP client implementation being used (e.g. Copilot, Claude, Cline...)\",\n      \"default\": \"UNKNOWN-MCP-CLIENT\"\n    },\n    \"model\" : {\n      \"type\" : \"string\",\n      \"description\": \"The name (and version) of the language model being used by the MCP client to process requests (e.g. gpt-4.1, claude-sonnet-4, llama4...\",\n      \"default\": \"UNKNOWN-LLM\"\n    }\n  }\n}\n"), (exchange, arguments) -> {
            McpSchema.TextContent content;
            try {
                String filter = McpUtils.optionalArgument(arguments, "filter", "");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = McpUtils.optionalArgument(arguments, "mcp_client", McpUtils.MCP_CLIENT_DEFAULT_VALUE);
                List connections = filter.isEmpty() ? ConnectionUtils.listAllConnectionNames().keySet().stream().toList() : this.subList(ConnectionUtils.listAllConnectionNames(), filter).keySet().stream().toList();
                if (ctx.getCurrentConnection() != null) {
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "list-connections", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "list-connections", "Connect to " + ctx.getCurrentConnection().getSchema());
                }
                content = new McpSchema.TextContent(String.join((CharSequence)",", connections));
            }
            catch (SQLException e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + e.getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(Collections.singletonList(content), Boolean.valueOf(false));
        });
    }

    private Map<String, String> subList(Map<String, String> list, String filter) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : list.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(filter.toLowerCase()) && !entry.getValue().equalsIgnoreCase(filter)) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }
}

