/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.search;

import java.text.MessageFormat;
import oracle.dbtools.core.oci.search.ResourceType;

public final class ResourceQuery {
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String TYPE_PROPERTY = "type";
    public static final String ID_PROPERTY = "identifier";
    private final ResourceType resourceType;
    private final String query;

    public static ResourceQueryConstraint unconstrained() {
        return new ResourceQueryConstraint(){

            @Override
            public String constraintText() {
                return "";
            }
        };
    }

    public static ResourceQueryConstraint likeConstraint(String fieldName, String value) {
        return new LikeConstraint(fieldName, value);
    }

    public static ResourceQueryConstraint matchConstraint(String fieldName, String value) {
        return new MatchConstraint(fieldName, value);
    }

    public static ResourceQueryConstraint exactMatchConstraint(String fieldName, String value) {
        return new ExactMatchConstraint(fieldName, value);
    }

    public static ResourceQuery of(ResourceQueryDetails queryDetails, ResourceQueryConstraint queryConstraint) {
        return new ResourceQuery(queryDetails, queryConstraint);
    }

    public static ResourceQuery databaseToolsQuery(ResourceQueryConstraint queryConstraint) {
        return ResourceQuery.of(ResourceQueryDetails.of(ResourceType.DatabaseToolsConnection), queryConstraint);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getQuery() {
        return this.query;
    }

    private ResourceQuery(ResourceQueryDetails queryDetails, ResourceQueryConstraint queryConstraint) {
        this.resourceType = queryDetails.resourceType;
        String constraintText = queryConstraint.constraintText();
        String constraintClause = !constraintText.isEmpty() ? MessageFormat.format("where {0}", constraintText) : "";
        this.query = MessageFormat.format("query {0} resources return allAdditionalFields {1}", this.resourceType.toString(), constraintClause);
    }

    private static final class LikeConstraint
    extends ValueConstraint {
        private LikeConstraint(String fieldName, String value) {
            super(fieldName, value);
        }

        @Override
        protected String getOperation() {
            return "=~";
        }
    }

    private static final class MatchConstraint
    extends ValueConstraint {
        private MatchConstraint(String fieldName, String value) {
            super(fieldName, value);
        }

        @Override
        protected String getOperation() {
            return "=";
        }
    }

    private static final class ExactMatchConstraint
    extends ValueConstraint {
        private ExactMatchConstraint(String fieldName, String value) {
            super(fieldName, value);
        }

        @Override
        protected String getOperation() {
            return "==";
        }
    }

    public static final class ResourceQueryDetails {
        private final ResourceType resourceType;

        private ResourceQueryDetails(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public static ResourceQueryDetails of(ResourceType resourceType) {
            return new ResourceQueryDetails(resourceType);
        }
    }

    public static abstract class ResourceQueryConstraint {
        public ResourceQueryConstraint and(ResourceQueryConstraint constraint) {
            return new AndConstraint(this, constraint);
        }

        public ResourceQueryConstraint or(ResourceQueryConstraint constraint) {
            return new OrConstraint(this, constraint);
        }

        protected ResourceQueryConstraint() {
        }

        public abstract String constraintText();
    }

    public static abstract class CompositeConstraint
    extends ResourceQueryConstraintImpl {
        protected final ResourceQueryConstraint firstConstraint;
        protected final ResourceQueryConstraint secondConstraint;

        public CompositeConstraint(ResourceQueryConstraint first, ResourceQueryConstraint second) {
            this.firstConstraint = first;
            this.secondConstraint = second;
        }

        @Override
        protected String getFirstArgument() {
            return this.firstConstraint.constraintText();
        }

        @Override
        protected String getSecondArgument() {
            return this.secondConstraint.constraintText();
        }
    }

    private static abstract class ValueConstraint
    extends ResourceQueryConstraintImpl {
        private final String fieldName;
        private final String value;

        protected ValueConstraint(String fieldName, String value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        protected String getFirstArgument() {
            return this.fieldName;
        }

        @Override
        protected String getSecondArgument() {
            return "'" + this.value + "'";
        }
    }

    private static final class OrConstraint
    extends CompositeConstraint {
        private OrConstraint(ResourceQueryConstraint first, ResourceQueryConstraint second) {
            super(first, second);
        }

        @Override
        protected String getOperation() {
            return "||";
        }
    }

    private static final class AndConstraint
    extends CompositeConstraint {
        private AndConstraint(ResourceQueryConstraint first, ResourceQueryConstraint second) {
            super(first, second);
        }

        @Override
        protected String getOperation() {
            return "&&";
        }
    }

    private static abstract class ResourceQueryConstraintImpl
    extends ResourceQueryConstraint {
        private ResourceQueryConstraintImpl() {
        }

        @Override
        public String constraintText() {
            return this.getFirstArgument() + " " + this.getOperation() + " " + this.getSecondArgument();
        }

        protected abstract String getFirstArgument();

        protected abstract String getSecondArgument();

        protected abstract String getOperation();
    }
}

