/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import com.oracle.bmc.objectstorage.model.ObjectSummary;
import java.time.Instant;

public class ObjectSummaryResult {
    private final String archivalState;
    private final String etag;
    private final String md5;
    private final String name;
    private final Long objectSize;
    private final int statusCode;
    private final String storageTier;
    private final Instant timeCreated;
    private final Instant timeModified;

    private ObjectSummaryResult(Builder builder) {
        this.archivalState = builder.archivalState;
        this.etag = builder.etag;
        this.md5 = builder.md5;
        this.name = builder.name;
        this.objectSize = builder.objectSize;
        this.statusCode = builder.statusCode;
        this.storageTier = builder.storageTier;
        this.timeCreated = builder.timeCreated;
        this.timeModified = builder.timeModified;
    }

    public String getArchivalState() {
        return this.archivalState;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getObjecttName() {
        return this.name;
    }

    public Long getObjectSize() {
        return this.objectSize;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStorageTier() {
        return this.storageTier;
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public Instant getTimeModified() {
        return this.timeModified;
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(ObjectSummary summary) {
        return new Builder().archivalState(summary.getArchivalState() != null ? summary.getArchivalState().getValue() : null).etag(summary.getEtag()).md5(summary.getMd5()).name(summary.getName()).objectSize(summary.getSize()).storageTier(summary.getStorageTier() != null ? summary.getStorageTier().getValue() : null).timeCreated(summary.getTimeCreated() != null ? summary.getTimeCreated().toInstant() : null).timeModified(summary.getTimeModified() != null ? summary.getTimeModified().toInstant() : null);
    }

    static class Builder {
        private String archivalState;
        private String etag;
        private String md5;
        private String name;
        private Long objectSize;
        private int statusCode;
        private String storageTier;
        private Instant timeCreated;
        private Instant timeModified;

        Builder() {
        }

        public ObjectSummaryResult build() {
            return new ObjectSummaryResult(this);
        }

        public Builder archivalState(String archivalState) {
            this.archivalState = archivalState;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder objectSize(Long size) {
            this.objectSize = size;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        public Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeModified(Instant timeModified) {
            this.timeModified = timeModified;
            return this;
        }
    }
}

