/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import java.util.Set;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;

public class ObjectListOptions {
    private final boolean all;
    private final String bucketName;
    private final String end;
    private final String fields;
    private final Integer limit;
    private final String namespace;
    private final String opcClientRequestId;
    private final String prefix;
    private final String start;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final Set<String> ALLOWABLE_FIELDS = Set.of("archivalstate", "etag", "md5", "name", "size", "storagetier", "timecreated", "timemodified");

    private ObjectListOptions(Builder builder) {
        this.validate(builder);
        this.all = builder.all;
        this.bucketName = builder.bucketName;
        this.end = builder.end;
        this.fields = builder.fields;
        this.limit = builder.limit;
        this.namespace = builder.namespace;
        this.opcClientRequestId = builder.opcClientRequestId;
        this.prefix = builder.prefix;
        this.start = builder.start;
    }

    public boolean allObjects() {
        return this.all;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getEnd() {
        return this.end;
    }

    public String getFields() {
        return this.fields;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStart() {
        return this.start;
    }

    private void validate(Builder builder) {
        String errMsg;
        StringBuilder sb = new StringBuilder();
        if (OCIUtils.isEmpty(builder.namespace)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_NAMESPACE")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.bucketName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_BUCKETNAME")).append(NEW_LINE);
        }
        if (builder.limit != null && builder.limit <= 0) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_LIMIT_PARAM")).append(NEW_LINE);
        }
        if (builder.all && builder.limit != null && builder.limit >= 1) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_ALL_LIMIT_PARAM")).append(NEW_LINE);
        }
        if (!OCIUtils.isEmpty(builder.fields) && (errMsg = this.checkFields(builder.fields)) != null) {
            sb.append(errMsg);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageException(sb.toString());
        }
    }

    private String checkFields(String fields) {
        if (fields != null) {
            String[] strList = fields.split(",");
            StringBuilder sb = new StringBuilder();
            for (String st : strList) {
                String s = st.trim();
                if (OCIUtils.isEmpty(s) || ALLOWABLE_FIELDS.contains(s.toLowerCase())) continue;
                sb.append(Messages.format("OBJECTSTORAGE_ERROR_FIELD", s)).append(NEW_LINE);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    public static Builder builder(String namespace, String bucketName) {
        return new Builder(namespace, bucketName);
    }

    public static final class Builder {
        private boolean all;
        private String end;
        private String fields;
        private Integer limit;
        private String opcClientRequestId;
        private String prefix;
        private String start;
        private final String bucketName;
        private final String namespace;

        private Builder(String namespace, String bucketName) {
            this.namespace = namespace;
            this.bucketName = bucketName;
        }

        public ObjectListOptions build() {
            return new ObjectListOptions(this);
        }

        public Builder all(boolean all) {
            this.all = all;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }
    }
}

