/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectDetails;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageUtils;

public class ObjectGetResult
extends ObjectDetails {
    private final byte[] content;
    private final Path filePath;
    private final Instant lastModified;
    private final String objectName;
    private final int statusCode;
    private final String versionId;
    private static final long MAX_CONTENT_SIZE = 0x800000L;

    private ObjectGetResult(Builder builder) {
        super(builder);
        this.content = builder.content;
        this.filePath = builder.filePath;
        this.lastModified = builder.lastModified;
        this.objectName = builder.objectName;
        this.statusCode = builder.statusCode;
        this.versionId = builder.versionId;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getVersionId() {
        return this.versionId;
    }

    static Builder builder(GetObjectResponse response, String namespace, String bucketName, String objectName, Path filePath, boolean storeInMemory) {
        Builder builder = new Builder(namespace, bucketName, objectName);
        int httpStatusCode = response.get__httpStatusCode__();
        builder.statusCode(httpStatusCode);
        if (httpStatusCode == 200 || httpStatusCode == 206) {
            block31: {
                try (InputStream is = response.getInputStream();){
                    if (is != null) {
                        if (filePath != null) {
                            Files.copy(is, filePath, StandardCopyOption.REPLACE_EXISTING);
                            break block31;
                        }
                        if (!storeInMemory) break block31;
                        if (response.getContentLength() <= 0x800000L) {
                            byte[] content = is.readAllBytes();
                            builder.content(content);
                            break block31;
                        }
                        String errSizeMsg = Messages.format("OBJECTSTORAGE_ERROR_LARGE_FILE", objectName, bucketName, response.getContentLength().toString(), String.valueOf(0x800000L));
                        throw new ObjectStorageException(errSizeMsg);
                    }
                    throw new IOException(Messages.getString("OBJECTSTORAGE_ERROR_GET_CONTENT_NULL"));
                }
                catch (IOException e) {
                    String errMsg = filePath != null ? Messages.format("OBJECTSTORAGE_ERROR_GET_OBJECT", objectName, bucketName, filePath) : Messages.format("OBJECTSTORAGE_ERROR_GET_OBJECT_INMEMORY", objectName, bucketName);
                    ObjectStorageUtils.rethrowException(e.getCause(), e.getLocalizedMessage(), errMsg);
                    return null;
                }
            }
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.cacheControl(response.getCacheControl())).contentDisposition(response.getContentDisposition())).contentEncoding(response.getContentEncoding())).contentLanguage(response.getContentLanguage())).contentMD5(response.getContentMd5())).contentType(response.getContentType())).eTag(response.getETag())).filePath(filePath).opcClientRequestId(response.getOpcClientRequestId())).versionId(response.getVersionId());
            if (response.getOpcContentSha256() != null) {
                builder.checksumAlgorithm(ObjectDetails.ChecksumAlgorithm.SHA256);
                builder.checksumContent(response.getOpcContentSha256());
            } else if (response.getOpcContentSha384() != null) {
                builder.checksumAlgorithm(ObjectDetails.ChecksumAlgorithm.SHA384);
                builder.checksumContent(response.getOpcContentSha384());
            } else if (response.getOpcContentCrc32c() != null) {
                builder.checksumAlgorithm(ObjectDetails.ChecksumAlgorithm.CRC32C);
                builder.checksumContent(response.getOpcContentCrc32c());
            }
            if (response.getLastModified() != null) {
                builder.lastModified(response.getLastModified().toInstant());
            }
            if (response.getStorageTier() != null) {
                ObjectDetails.StorageTier storageTier = ObjectDetails.StorageTier.valueOf(response.getStorageTier().toString());
                builder.storageTier(storageTier);
            }
        } else if (httpStatusCode == 304) {
            ((Builder)builder.eTag(response.getETag())).opcClientRequestId(response.getOpcClientRequestId());
        } else {
            try (InputStream is = response.getInputStream();){
                byte[] content;
                if (is != null && (content = is.readAllBytes()) != null) {
                    OCIUtils.severe("Error Resource: " + content.toString(), new Object[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder;
    }

    static final class Builder
    extends ObjectDetails.Builder<Builder, ObjectGetResult> {
        private byte[] content;
        private Path filePath;
        private Instant lastModified;
        private int statusCode;
        private String versionId;
        private final String objectName;

        private Builder(String namespace, String bucketName, String objectName) {
            super(namespace, bucketName);
            this.objectName = objectName;
        }

        @Override
        public ObjectGetResult build() {
            return new ObjectGetResult(this);
        }

        public Builder content(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder filePath(Path filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }
    }
}

