/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;

public class ObjectGetOptions {
    private final String avoidEtag;
    private final String bucketName;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;
    private final String eTag;
    private final Path filePath;
    private final boolean inMemory;
    private final String namespace;
    private final String objectName;
    private final String opcClientRequestId;
    private static final String NEW_LINE = System.getProperty("line.separator");

    private ObjectGetOptions(Builder builder) {
        this.validate(builder);
        this.avoidEtag = builder.avoidEtag;
        this.bucketName = builder.bucketName;
        this.cacheControl = builder.overrideCacheControl;
        this.contentDisposition = builder.overrideContentDisposition;
        this.contentEncoding = builder.overrideContentEncoding;
        this.contentLanguage = builder.overrideContentLanguage;
        this.contentType = builder.overrideContentType;
        this.eTag = builder.eTag;
        this.filePath = builder.filePath;
        this.inMemory = builder.inMemory;
        this.namespace = builder.namespace;
        this.objectName = builder.objectName;
        this.opcClientRequestId = builder.opcClientRequestId;
    }

    public String getAvoidEtag() {
        return this.avoidEtag;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getETag() {
        return this.eTag;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOverrideCacheControl() {
        return this.cacheControl;
    }

    public String getOverrideContentDisposition() {
        return this.contentDisposition;
    }

    public String getOverrideContentEncoding() {
        return this.contentEncoding;
    }

    public String getOverrideContentLanguage() {
        return this.contentLanguage;
    }

    public String getOverrideContentType() {
        return this.contentType;
    }

    public boolean storeInMemory() {
        return this.inMemory;
    }

    private void validate(Builder builder) {
        String errMsg;
        StringBuilder sb = new StringBuilder();
        if (OCIUtils.isEmpty(builder.namespace)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_NAMESPACE")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.bucketName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_BUCKETNAME")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.objectName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_OBJECTNAME")).append(NEW_LINE);
        }
        if (builder.filePath == null && !builder.inMemory || builder.filePath != null && builder.inMemory) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_FILE_OR_INMEMORY")).append(NEW_LINE);
        } else if (!builder.inMemory && (errMsg = this.checkFile(builder.filePath)) != null) {
            sb.append(errMsg);
        }
        if (!OCIUtils.isEmpty(builder.avoidEtag) && !OCIUtils.isEmpty(builder.eTag)) {
            sb.append(Messages.format("OBJECTSTORAGE_ERROR_ETAG_NO_OVERWRITE_PARAM", builder.eTag)).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageException(sb.toString());
        }
    }

    private String checkFile(Path file) {
        StringBuilder sb = new StringBuilder();
        if (file == null) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_FILE")).append(NEW_LINE);
        } else if (Files.exists(file, new LinkOption[0])) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                sb.append(Messages.format("OBJECTSTORAGE_ERROR_FILE_IS_DIR", file.toString())).append(NEW_LINE);
            } else if (!Files.isWritable(file)) {
                sb.append(Messages.format("OBJECTSTORAGE_ERROR_FILE_NOT_WRITTABLE", file.toString())).append(NEW_LINE);
            } else {
                OCIUtils.warn(Messages.format("OBJECTSTORAGE_WARNING_FILE_EXIST", file.toString()), new Object[0]);
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static Builder builder(String namespace, String bucketName, String objectName, Path filePath) {
        return new Builder(namespace, bucketName, objectName, filePath);
    }

    public static Builder builder(String namespace, String bucketName, String objectName) {
        return new Builder(namespace, bucketName, objectName);
    }

    public static final class Builder {
        private String avoidEtag;
        private String eTag;
        private Path filePath;
        private boolean inMemory;
        private String opcClientRequestId;
        private String overrideCacheControl;
        private String overrideContentDisposition;
        private String overrideContentEncoding;
        private String overrideContentLanguage;
        private String overrideContentType;
        private final String bucketName;
        private final String namespace;
        private final String objectName;

        private Builder(String namespace, String bucketName, String objectName, Path filePath) {
            this.namespace = namespace;
            this.bucketName = bucketName;
            this.objectName = objectName;
            this.filePath = filePath;
        }

        private Builder(String namespace, String bucketName, String objectName) {
            this.namespace = namespace;
            this.bucketName = bucketName;
            this.objectName = objectName;
        }

        public ObjectGetOptions build() {
            return new ObjectGetOptions(this);
        }

        public Builder avoidEtag(String avoidEtag) {
            this.avoidEtag = avoidEtag;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder filePath(Path filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder overrideCacheControl(String overrideCacheControl) {
            this.overrideCacheControl = overrideCacheControl;
            return this;
        }

        public Builder overrideContentDisposition(String overrideContentDisposition) {
            this.overrideContentDisposition = overrideContentDisposition;
            return this;
        }

        public Builder overrideContentEncoding(String overrideContentEncoding) {
            this.overrideContentEncoding = overrideContentEncoding;
            return this;
        }

        public Builder overrideContentLanguage(String overrideContentLanguage) {
            this.overrideContentLanguage = overrideContentLanguage;
            return this;
        }

        public Builder overrideContentType(String overrideContentType) {
            this.overrideContentType = overrideContentType;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder storeInMemory(boolean inMemory) {
            this.inMemory = inMemory;
            return this;
        }
    }
}

