/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.connections;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionException;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.helpers.BaseConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.OracleDataSources;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.DatabaseDetails;
import oracle.dbtools.core.oci.InstancePrincipalProvider;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIClientException;
import oracle.dbtools.core.oci.OCIDBToolsConnection;
import oracle.dbtools.core.oci.OCIDatabaseClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.core.secrets.TextSecret;

public class OCIHelperFactory
implements ConnectionHelperFactory {
    public String getConnectionType() {
        return "OCI_DBTOOLS";
    }

    public ConnectionHelper createConnectionHelper(ConnectionHelperContext ctx) {
        return OCIHelperFactory.createOciConnectionHelper(ctx);
    }

    public static ConnectionHelper createOciConnectionHelper(ConnectionHelperContext ctx) {
        return new OCIConnectionHelper(ctx);
    }

    private static final class OCIConnectionHelper
    extends BaseConnectionHelper {
        private final OCIDatabaseClient client;
        private final OCIDBToolsConnection ocidbToolsConnection;
        private static final Set<String> IGNORE_LIST = new HashSet<String>();

        private OCIConnectionHelper(ConnectionHelperContext ctx) {
            super(ctx);
            ConfigurationProperties props = this.definition.getDbtoolsProperties();
            try {
                AuthenticationProvider authenticationProvider;
                String authenticationType = (String)props.getOrDefault((Object)"ociAuthenticationMethod", (Object)"PROFILE");
                String region = null;
                if ("PROFILE".equals(authenticationType)) {
                    OCIProfiles profiles;
                    OCIProfile profile;
                    String profileName = props.getProperty((CharSequence)"ociProfile");
                    if (profileName == null) {
                        profileName = "DEFAULT";
                    }
                    if ((profile = (profiles = OCIProfiles.builder().build()).getProfile(profileName)) == null) {
                        throw OCIClientException.of(new IllegalStateException(Messages.format("OCI_MISSING_PROFILE", profileName)));
                    }
                    profile = profile.wrap(props);
                    region = props.getProperty((CharSequence)"ociRegion");
                    authenticationProvider = profile;
                } else if ("INSTANCE_PRINCIPAL".equals(authenticationType)) {
                    authenticationProvider = InstancePrincipalProvider.builder().build();
                } else {
                    throw ConnectionException.of((String)Messages.format("OCI_INVALID_AUTHENTICATION_TYPE", authenticationType));
                }
                OCIDatabaseClient.Builder dbClientBuilder = OCIDatabaseClient.builder(authenticationProvider);
                if (region != null) {
                    dbClientBuilder.region(region);
                }
                this.client = dbClientBuilder.build();
                String ocid = this.definition.getDbtoolsProperties().getProperty((CharSequence)"databaseToolsConnectionId");
                this.ocidbToolsConnection = this.client.createDBToolsConnection(ocid);
            }
            catch (IOException | OCIClientException e) {
                throw ConnectionException.of((Throwable)e);
            }
        }

        public Collection<ConnectionHelper.DisplayEntry> getDisplayProperties() {
            ArrayList<ConnectionHelper.DisplayEntry> displayEntries = new ArrayList<ConnectionHelper.DisplayEntry>();
            String connName = this.definition.getConnectionName();
            displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)ConnectionsResources.getString((String)"SHOW_NAME"), (String)connName));
            DatabaseDetails details = this.getConnectionDefinition();
            displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)"OCID", (String)details.getId()));
            displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)"Type", (String)details.getType()));
            displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)"Username", (String)details.getUserName()));
            String connectString = details.getConnectString();
            if (connectString != null) {
                displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)"Connection String", (String)details.getConnectString()));
            } else {
                displayEntries.add(OCIConnectionHelper.createDisplayEntry((String)"URL", (String)details.getURL()));
            }
            return displayEntries;
        }

        public String getConnectionSpec() {
            return this.getConnectionDefinition().getConnectString();
        }

        public String getURL() {
            return this.getConnectionDefinition().getURL();
        }

        public String getUsername() {
            return this.getConnectionDefinition().getUserName();
        }

        public TextSecret getPassword() {
            return this.client.getPassword(this.ocidbToolsConnection);
        }

        public Connection createConnection(ConnectCredentials credentials, Properties productProperties) throws SQLException {
            try {
                OracleDataSources.Builder dsBuilder = OracleDataSources.instance().builder();
                Properties connProperties = new Properties();
                for (String key : productProperties.stringPropertyNames()) {
                    connProperties.setProperty(key, productProperties.getProperty(key));
                }
                if (credentials != null) {
                    String role;
                    TextSecret passwordOverride;
                    String userOverride = credentials.getUsername();
                    if (userOverride != null) {
                        dsBuilder.user(userOverride);
                    }
                    if ((passwordOverride = credentials.getPassword()).isPresent()) {
                        passwordOverride.set(arg_0 -> ((OracleDataSources.Builder)dsBuilder).password(arg_0));
                    }
                    if ((role = credentials.getRole()) != null) {
                        connProperties.setProperty("internal_logon", role);
                    }
                }
                dsBuilder.connectionProperties(connProperties);
                DataSourceBuilder dataSourceBuilder = this.client.createDataSource((DataSourceBuilder)dsBuilder, this.ocidbToolsConnection);
                return dataSourceBuilder.build().getConnection();
            }
            catch (IOException e) {
                throw OCIClientException.of(e);
            }
        }

        private DatabaseDetails getConnectionDefinition() {
            return DatabaseDetails.of(this.ocidbToolsConnection);
        }

        static {
            IGNORE_LIST.add("user");
            IGNORE_LIST.add("password");
            IGNORE_LIST.add("oracle.net.tns_admin");
        }
    }
}

