/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIProfile;

public final class OCIProfiles {
    private final Map<String, OCIProfile> profiles;
    private static final String DEFAULT_CONFIG_LOCATION = "~/.oci/config";
    private static final String CONFIG_ENV_VARIABLE = "OCI_CONFIG_FILE";
    private static final String FALLBACK_CONFIG_LOCATION = "~/.oraclebmc/config";

    public static Builder builder() {
        return new Builder();
    }

    private OCIProfiles(Builder builder) throws IOException {
        String path = builder.configPath;
        Path configFile = null;
        if (path == null) {
            Path defaultLocation = Path.of(OCIProfiles.expandHome(DEFAULT_CONFIG_LOCATION), new String[0]);
            if (Files.isRegularFile(defaultLocation, new LinkOption[0])) {
                configFile = defaultLocation;
            }
            if (configFile == null) {
                Path overideLocation;
                String overide = System.getenv(CONFIG_ENV_VARIABLE);
                if (overide == null || overide.trim().isEmpty()) {
                    overide = FALLBACK_CONFIG_LOCATION;
                }
                if (Files.isRegularFile(overideLocation = Path.of(OCIProfiles.expandHome(overide), new String[0]), new LinkOption[0])) {
                    configFile = overideLocation;
                }
            }
            if (configFile == null) {
                throw new IOException(Messages.getString("PROFILES_ERROR_NO_CONFIG_FILES"));
            }
        } else {
            configFile = Path.of(OCIProfiles.expandHome(path), new String[0]);
            if (!Files.isRegularFile(configFile, new LinkOption[0])) {
                throw new IOException(Messages.format("PROFILES_ERROR_BAD_CONFIG_LOCATION", configFile));
            }
        }
        this.profiles = this.loadProfiles(configFile);
    }

    public Collection<String> listProfiles() {
        return this.profiles.keySet();
    }

    public OCIProfile getProfile(String profileName) {
        return this.profiles.get(profileName);
    }

    private Map<String, OCIProfile> loadProfiles(Path configFile) throws IOException {
        HashSet<String> profiles = new HashSet<String>();
        try (BufferedReader r = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
            String line = null;
            while ((line = r.readLine()) != null) {
                String trimmedLine = line.trim();
                if (!trimmedLine.startsWith("[") || !trimmedLine.endsWith("]")) continue;
                String profile = trimmedLine.substring(1, trimmedLine.length() - 1).trim();
                profiles.add(profile);
            }
        }
        try {
            return profiles.stream().collect(Collectors.toMap(Function.identity(), p -> {
                try {
                    return OCIProfile.builder().configFile(configFile).profileName((String)p).build();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static String expandHome(String path) {
        char sep = File.separatorChar;
        return path.startsWith("~/") || path.startsWith("~\\") ? System.getProperty("user.home") + ('/' != sep ? path.substring(1).replace('/', sep) : path.substring(1)) : path;
    }

    public static final class Builder {
        private String configPath;

        private Builder() {
        }

        public Builder configPath(String path) {
            this.configPath = path;
            return this;
        }

        public OCIProfiles build() throws IOException {
            return new OCIProfiles(this);
        }
    }
}

