/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ucp.common.Counter;

public class CriStats {
    private final BorrowSemaphore borrowSemaphore = new BorrowSemaphore();
    private final Counter totalConnCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);

        public String toString() {
            return "totalCounter=" + this.counter.get();
        }

        @Override
        public int getAndIncrement() {
            int total = this.counter.getAndIncrement();
            CriStats.this.borrowSemaphore.release();
            CriStats.this.signalPoolUpdate();
            return total;
        }

        @Override
        public int decrementAndGet() {
            int total = this.counter.decrementAndGet();
            CriStats.this.borrowSemaphore.reduce(1);
            return total;
        }

        @Override
        public int getAndDecrement() {
            int total = this.counter.getAndDecrement();
            CriStats.this.borrowSemaphore.reduce(1);
            return total;
        }

        @Override
        public int incrementAndGet() {
            int total = this.counter.incrementAndGet();
            CriStats.this.borrowSemaphore.release();
            CriStats.this.signalPoolUpdate();
            return total;
        }

        @Override
        public int get() {
            return this.counter.get();
        }
    };
    private final Counter borrowedConnCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);

        public String toString() {
            return "borrowedCounter=" + this.counter.get();
        }

        @Override
        public int getAndIncrement() {
            int borrowed = this.counter.getAndIncrement();
            CriStats.this.borrowSemaphore.reduce(1);
            return borrowed;
        }

        @Override
        public int decrementAndGet() {
            int borrowed = this.counter.decrementAndGet();
            CriStats.this.borrowSemaphore.release();
            CriStats.this.signalPoolUpdate();
            return borrowed;
        }

        @Override
        public int getAndDecrement() {
            int borrowed = this.counter.getAndDecrement();
            CriStats.this.borrowSemaphore.release();
            CriStats.this.signalPoolUpdate();
            return borrowed;
        }

        @Override
        public int incrementAndGet() {
            int borrowed = this.counter.incrementAndGet();
            CriStats.this.borrowSemaphore.reduce(1);
            return borrowed;
        }

        @Override
        public int get() {
            return this.counter.get();
        }
    };
    private final Executor waitExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final AtomicInteger pendingBorrowWaits = new AtomicInteger(0);
    private final AtomicLong waitingThreadsCounter = new AtomicLong(0L);
    private final Lock waitingLock = new ReentrantLock();
    private final Condition waitingCondition = this.waitingLock.newCondition();

    CriStats() {
    }

    Counter totalConnCount() {
        return this.totalConnCount;
    }

    Counter borrowedConnCount() {
        return this.borrowedConnCount;
    }

    BorrowSemaphore getBorrowSemaphore() {
        return this.borrowSemaphore;
    }

    public Executor getWaitExecutor() {
        return this.waitExecutor;
    }

    public AtomicInteger getPendingBorrowWaits() {
        return this.pendingBorrowWaits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForPoolUpdate(long timeout) {
        this.waitingLock.lock();
        this.waitingThreadsCounter.incrementAndGet();
        try {
            this.waitingCondition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.waitingThreadsCounter.getAndDecrement();
            this.waitingLock.unlock();
        }
    }

    private void signalPoolUpdate() {
        if (this.waitingThreadsCounter.get() > 0L) {
            this.waitingLock.lock();
            try {
                this.waitingCondition.signalAll();
            }
            finally {
                this.waitingLock.unlock();
            }
        }
    }

    public String toString() {
        return "borrowSemaphore=[" + this.borrowSemaphore + "]" + ", " + this.totalConnCount().get() + ", " + this.borrowedConnCount().get();
    }

    class BorrowSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 4343640747504L;
        private AtomicLong acquireAttempts;
        private AtomicLong waitingAcquires;

        private BorrowSemaphore() {
            super(0, true);
            this.acquireAttempts = new AtomicLong(0L);
            this.waitingAcquires = new AtomicLong(0L);
        }

        private void reduce(int permits) {
            super.reducePermits(permits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAcquire(long timeout, TimeUnit units) throws InterruptedException {
            this.acquireAttempts.incrementAndGet();
            this.waitingAcquires.incrementAndGet();
            try {
                boolean bl = super.tryAcquire(timeout, units);
                return bl;
            }
            finally {
                this.waitingAcquires.getAndDecrement();
            }
        }

        public long getWaitingAcquires() {
            long wa = this.waitingAcquires.get();
            assert (wa >= 0L);
            return wa;
        }

        @Override
        public String toString() {
            return "availPermits=" + this.availablePermits() + ", acquireAttempts=" + this.acquireAttempts.get() + ", queueLength=" + this.getQueueLength() + ", waitingAcquires=" + this.getWaitingAcquires();
        }
    }
}

