/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bastion.model.CreateSessionTargetResourceDetails;
import com.oracle.bmc.bastion.model.PublicKeyDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateSessionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="bastionId")
    private final String bastionId;
    @JsonProperty(value="targetResourceDetails")
    private final CreateSessionTargetResourceDetails targetResourceDetails;
    @JsonProperty(value="keyType")
    private final KeyType keyType;
    @JsonProperty(value="keyDetails")
    private final PublicKeyDetails keyDetails;
    @JsonProperty(value="sessionTtlInSeconds")
    private final Integer sessionTtlInSeconds;

    @Deprecated
    @ConstructorProperties(value={"displayName", "bastionId", "targetResourceDetails", "keyType", "keyDetails", "sessionTtlInSeconds"})
    public CreateSessionDetails(String displayName, String bastionId, CreateSessionTargetResourceDetails targetResourceDetails, KeyType keyType, PublicKeyDetails keyDetails, Integer sessionTtlInSeconds) {
        this.displayName = displayName;
        this.bastionId = bastionId;
        this.targetResourceDetails = targetResourceDetails;
        this.keyType = keyType;
        this.keyDetails = keyDetails;
        this.sessionTtlInSeconds = sessionTtlInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBastionId() {
        return this.bastionId;
    }

    public CreateSessionTargetResourceDetails getTargetResourceDetails() {
        return this.targetResourceDetails;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public PublicKeyDetails getKeyDetails() {
        return this.keyDetails;
    }

    public Integer getSessionTtlInSeconds() {
        return this.sessionTtlInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSessionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", bastionId=").append(String.valueOf(this.bastionId));
        sb.append(", targetResourceDetails=").append(String.valueOf((Object)this.targetResourceDetails));
        sb.append(", keyType=").append(String.valueOf((Object)this.keyType));
        sb.append(", keyDetails=").append(String.valueOf((Object)this.keyDetails));
        sb.append(", sessionTtlInSeconds=").append(String.valueOf(this.sessionTtlInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSessionDetails)) {
            return false;
        }
        CreateSessionDetails other = (CreateSessionDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.bastionId, other.bastionId) && Objects.equals((Object)this.targetResourceDetails, (Object)other.targetResourceDetails) && Objects.equals((Object)this.keyType, (Object)other.keyType) && Objects.equals((Object)this.keyDetails, (Object)other.keyDetails) && Objects.equals(this.sessionTtlInSeconds, other.sessionTtlInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.bastionId == null ? 43 : this.bastionId.hashCode());
        result = result * 59 + (this.targetResourceDetails == null ? 43 : this.targetResourceDetails.hashCode());
        result = result * 59 + (this.keyType == null ? 43 : this.keyType.hashCode());
        result = result * 59 + (this.keyDetails == null ? 43 : this.keyDetails.hashCode());
        result = result * 59 + (this.sessionTtlInSeconds == null ? 43 : this.sessionTtlInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum KeyType implements BmcEnum
    {
        Pub("PUB");

        private final String value;
        private static Map<String, KeyType> map;

        private KeyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid KeyType: " + key);
        }

        static {
            map = new HashMap<String, KeyType>();
            for (KeyType v : KeyType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="bastionId")
        private String bastionId;
        @JsonProperty(value="targetResourceDetails")
        private CreateSessionTargetResourceDetails targetResourceDetails;
        @JsonProperty(value="keyType")
        private KeyType keyType;
        @JsonProperty(value="keyDetails")
        private PublicKeyDetails keyDetails;
        @JsonProperty(value="sessionTtlInSeconds")
        private Integer sessionTtlInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder bastionId(String bastionId) {
            this.bastionId = bastionId;
            this.__explicitlySet__.add("bastionId");
            return this;
        }

        public Builder targetResourceDetails(CreateSessionTargetResourceDetails targetResourceDetails) {
            this.targetResourceDetails = targetResourceDetails;
            this.__explicitlySet__.add("targetResourceDetails");
            return this;
        }

        public Builder keyType(KeyType keyType) {
            this.keyType = keyType;
            this.__explicitlySet__.add("keyType");
            return this;
        }

        public Builder keyDetails(PublicKeyDetails keyDetails) {
            this.keyDetails = keyDetails;
            this.__explicitlySet__.add("keyDetails");
            return this;
        }

        public Builder sessionTtlInSeconds(Integer sessionTtlInSeconds) {
            this.sessionTtlInSeconds = sessionTtlInSeconds;
            this.__explicitlySet__.add("sessionTtlInSeconds");
            return this;
        }

        public CreateSessionDetails build() {
            CreateSessionDetails model = new CreateSessionDetails(this.displayName, this.bastionId, this.targetResourceDetails, this.keyType, this.keyDetails, this.sessionTtlInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSessionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("bastionId")) {
                this.bastionId(model.getBastionId());
            }
            if (model.wasPropertyExplicitlySet("targetResourceDetails")) {
                this.targetResourceDetails(model.getTargetResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("keyType")) {
                this.keyType(model.getKeyType());
            }
            if (model.wasPropertyExplicitlySet("keyDetails")) {
                this.keyDetails(model.getKeyDetails());
            }
            if (model.wasPropertyExplicitlySet("sessionTtlInSeconds")) {
                this.sessionTtlInSeconds(model.getSessionTtlInSeconds());
            }
            return this;
        }
    }
}

