/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.json.common.DocumentCodecFactory;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.rdbms.JsonpGeneratorWrapper;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.HashFuncs;
import oracle.soda.OracleCollection;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleDatabaseAdmin;
import oracle.soda.OracleDocument;
import oracle.soda.OracleDropResult;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;
import oracle.soda.rdbms.impl.cache.DescriptorCache;
import oracle.sql.json.OracleJsonGenerator;

public class OracleDatabaseImpl
implements OracleDatabase {
    private static final boolean useLastAccess;
    private static final byte[] MAGIC_BYTES;
    static ArrayList<String> EMPTY_LIST;
    static final int MAX_STRING_BIND_LENGTH = 4000;
    private static final short DBCS_AL32UTF8 = 873;
    private static final short DBCS_UTF8 = 871;
    private static final String SELECT_GUID = "select SYS_GUID() from SYS.DUAL";
    private static final String SELECT_GUID_BATCH = "declare\n  N number;\n  X varchar2(255);\n  K XDB.DBMS_SODA_ADMIN.VCNTAB;\nbegin\n  N := ?;\n  K := XDB.DBMS_SODA_ADMIN.VCNTAB();\n  K.extend(N);\n  for I in 1..N loop\n    select rawtohex(SYS_GUID()) into X from SYS.DUAL;\n    K(I) := X;\n  end loop;\n  ? := K;\nend;";
    private static final String SELECT_SCN = "begin\n  DBMS_SODA_ADMIN.GET_SCN(?);\nend;";
    private static final String DEFAULT_COLLECTION_CREATION_MODE = "DDL";
    private static final Logger log;
    private static ThreadLocal<HashFuncs> HASHER;
    final HashFuncs hasher = HASHER.get();
    private final OracleConnection conn;
    private final DescriptorCache sharedDescriptorCache;
    private final HashMap<String, CollectionDescriptor> localDescriptorCache;
    private final HashMap<String, OracleCollectionImpl> localCollectionCache;
    private MetricsCollector metrics;
    private int rawMaxLength = -1;
    private int nvarcharMaxLength = -1;
    private int varcharMaxLength = -1;
    private boolean dbIsUnicode = false;
    private long maxCacheTimeout = -1L;
    private boolean metadataTableExists = true;
    private OracleDatabaseAdmin admin;
    static final boolean JDBC_WORKAROUND = false;
    private static final int DESC_LENGTH = 4000;
    private static final int CREATION_TIMESTAMP_LENGTH = 255;
    private static final int DDL_SQL_LENGTH = 32500;
    private boolean avoidTxnManagement;
    private boolean useDocumentKey = false;
    private SODAUtils.SQLSyntaxLevel sqlSyntaxLevel = SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN;
    private JsonFactoryProvider jProvider;
    private boolean omitIdProcessing = false;
    private static final Class<?> JSON_FACT_CLASS;
    private static final Method JSON_FACT_CREATE_BINARY_VALUE;
    private static final Method JSON_FACT_CREATE_TEXT_VALUE;
    private static final Method JSON_FACT_CREATE_JSON_TEXT_GENERATOR;
    private static final Method JSON_FACT_CREATE_BINARY_PARSER;
    private static final Method JSON_FACT_CREATE_BINARY_GENERATOR;
    private static final Method JSON_FACT_CREATE_TEXT_PARSER;
    protected static final Class<?> JSON_VALUE_CLASS;
    private static final Class<?> JSON_GEN_CLASS;
    protected static final Class<?> JSON_PARSE_CLASS;
    private static final Class<?> JSON_DATUM_CLASS;
    private static final Method JSON_SHARE_BYTES;
    private static final Class<? extends DocumentCodecFactory> CODEC_CLASS;
    protected static final Class<?> JAVAX_JSON_VALUE_CLASS;
    protected static final Class<?> JAVAX_JSON_PARSE_CLASS;
    private static final long TIME_REFRESH_INTERVAL = 100000000L;
    private static String SELECT_DB_TIMESTAMP;
    private Instant currentTimestamp = Instant.ofEpochMilli(0L);
    private long updateNanos = 0L;
    private static final int GUID_BATCH_SIZE = 100;
    private final String[] guidCache = new String[100];
    private int guidCachePos = 100;
    private static final int OBJECTID_BATCH_SIZE = 100;
    private final String[] objectIdCache = new String[100];
    private int objectIdCachePos = 100;
    private static final String SELECT_OBJECTID_BATCH = "declare\n  N number;\n  X varchar2(255);\n  T TIMESTAMP WITH TIME ZONE;\n  K XDB.DBMS_SODA_ADMIN.VCNTAB;\nbegin\n  N := ?;\n  K := XDB.DBMS_SODA_ADMIN.VCNTAB();\n  K.extend(N);\n  for I in 1..N loop\n    select SYSTIMESTAMP TSTAMP, RawToHex(SYS_GUID()) MACID\n      into T, X from SYS.DUAL;\n    K(I) := X;\n  end loop;\n  ? := T;\n  ? := K;\nend;";
    private DocumentCodecFactory codecFactory = null;
    private Object jsonFactory = null;
    private static final Method CANCEL_METHOD;
    private static final Method PREFETCH_METHOD;
    private static final Integer LOB_PREFETCH_SIZE;
    private static final Method SET_BLOB_BYTES;
    private static final Method SET_CLOB_STRING;
    private static final Method REGISTER_RETURN_PARAMETER;
    private static final Method GET_RETURN_RESULT_SET;
    private static final Integer RETURN_VARCHAR;
    private static final Integer RETURN_TIMESTAMP;
    private static final Integer RETURN_BINARY;
    public static final Class<? extends Connection> ORACLE_CONNECTION;

    public OracleDatabaseImpl(OracleConnection oracleConnection, DescriptorCache descriptorCache, MetricsCollector metricsCollector, boolean bl, boolean bl2, JsonFactoryProvider jsonFactoryProvider) {
        this.conn = oracleConnection;
        this.sharedDescriptorCache = descriptorCache;
        this.metrics = metricsCollector;
        this.avoidTxnManagement = bl2;
        this.jProvider = jsonFactoryProvider;
        if (bl) {
            this.localDescriptorCache = new HashMap();
            this.localCollectionCache = new HashMap();
        } else {
            this.localDescriptorCache = null;
            this.localCollectionCache = null;
        }
    }

    public OracleDatabaseImpl(OracleConnection oracleConnection, DescriptorCache descriptorCache, MetricsCollector metricsCollector, JsonFactoryProvider jsonFactoryProvider) {
        this(oracleConnection, descriptorCache, metricsCollector, true, false, jsonFactoryProvider);
    }

    public OracleDatabaseImpl(OracleConnection oracleConnection, DescriptorCache descriptorCache, MetricsCollector metricsCollector, JsonFactoryProvider jsonFactoryProvider, boolean bl, boolean bl2) {
        this(oracleConnection, descriptorCache, metricsCollector, jsonFactoryProvider);
        this.useDocumentKey = bl;
        this.omitIdProcessing = bl2;
    }

    public OracleDatabaseImpl(OracleConnection oracleConnection, DescriptorCache descriptorCache, MetricsCollector metricsCollector, JsonFactoryProvider jsonFactoryProvider, boolean bl) {
        this(oracleConnection, descriptorCache, metricsCollector, jsonFactoryProvider);
        this.useDocumentKey = bl;
    }

    protected boolean allowDocumentKey() {
        return this.useDocumentKey;
    }

    public boolean omitIdProcessing() {
        return this.omitIdProcessing;
    }

    protected static Object createBinaryParser(byte[] byArray, Object object) throws OracleException {
        try {
            return JSON_FACT_CREATE_BINARY_PARSER.invoke(object, ByteBuffer.wrap(byArray));
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    protected static Object createTextParser(byte[] byArray, Object object) throws OracleException {
        if (JSON_FACT_CREATE_TEXT_PARSER == null) {
            throw SODAUtils.makeException(SODAMessage.EX_JDBC_211_REQUIRED, new Object[0]);
        }
        try {
            return JSON_FACT_CREATE_TEXT_PARSER.invoke(object, new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    protected static Object binaryToJavaxJsonValue(byte[] byArray, Object object) throws OracleException {
        JsonParser jsonParser = (JsonParser)OracleDatabaseImpl.binaryToJavaxJsonParser(byArray, object);
        jsonParser.next();
        JsonValue jsonValue = jsonParser.getValue();
        jsonParser.close();
        return jsonValue;
    }

    protected static jakarta.json.JsonValue binaryToJsonValue(byte[] byArray, Object object) throws OracleException {
        jakarta.json.stream.JsonParser jsonParser = OracleDatabaseImpl.binaryToJsonParser(byArray, object);
        jsonParser.next();
        jakarta.json.JsonValue jsonValue = jsonParser.getValue();
        jsonParser.close();
        return jsonValue;
    }

    protected static Object binaryToOracleJsonValue(byte[] byArray, Object object) throws OracleException {
        try {
            return JSON_FACT_CREATE_BINARY_VALUE.invoke(object, ByteBuffer.wrap(byArray));
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    protected static Object textToOracleJsonValue(byte[] byArray, Object object) throws OracleException {
        try {
            return JSON_FACT_CREATE_TEXT_VALUE.invoke(object, new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    protected static Object binaryToJavaxJsonParser(byte[] byArray, Object object) throws OracleException {
        if (!OracleDatabaseImpl.isOracleJsonAvailable()) {
            throw SODAUtils.makeException(SODAMessage.EX_JDBC_196_REQUIRED, new Object[0]);
        }
        Object object2 = OracleDatabaseImpl.createBinaryParser(byArray, object);
        try {
            Method method = JSON_PARSE_CLASS.getMethod("wrap", Class.class);
            return (JsonParser)method.invoke(object2, JsonParser.class);
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    protected static jakarta.json.stream.JsonParser binaryToJsonParser(byte[] byArray, Object object) throws OracleException {
        if (!OracleDatabaseImpl.isOracleJsonAvailable()) {
            throw SODAUtils.makeException(SODAMessage.EX_JDBC_196_REQUIRED, new Object[0]);
        }
        Object object2 = OracleDatabaseImpl.createBinaryParser(byArray, object);
        try {
            Method method = JSON_PARSE_CLASS.getMethod("wrap", Class.class);
            return (jakarta.json.stream.JsonParser)method.invoke(object2, jakarta.json.stream.JsonParser.class);
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    public byte[] textToBinary(byte[] byArray) throws OracleException {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        JsonParserFactory jsonParserFactory = this.jProvider.getParserFactory();
        jakarta.json.stream.JsonParser jsonParser = jsonParserFactory.createParser((InputStream)new ByteArrayInputStream(byArray));
        OracleDatabaseImpl.writeParserToGenerator(jsonParser, oracleJsonGenerator);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] textToBinary(Reader reader) throws OracleException {
        if (reader == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        JsonParserFactory jsonParserFactory = this.jProvider.getParserFactory();
        jakarta.json.stream.JsonParser jsonParser = jsonParserFactory.createParser(reader);
        OracleDatabaseImpl.writeParserToGenerator(jsonParser, oracleJsonGenerator);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] oracleJsonParserToBinary(Object object) throws OracleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        try {
            oracleJsonGenerator.writeParser(object);
            oracleJsonGenerator.close();
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] javaxJsonParserToBinary(Object object) throws OracleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        try {
            oracleJsonGenerator.writeParser(object);
            oracleJsonGenerator.close();
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] javaxJsonValueToBinary(Object object) throws OracleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        OracleDatabaseImpl.writeValueToGenerator(object, oracleJsonGenerator);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] oracleJsonValueToBinary(Object object) throws OracleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OracleJsonGenerator oracleJsonGenerator = (OracleJsonGenerator)this.createBinaryGenerator(byteArrayOutputStream);
        OracleDatabaseImpl.writeOracleValueToGenerator(object, (Closeable)oracleJsonGenerator);
        return byteArrayOutputStream.toByteArray();
    }

    private Closeable createBinaryGenerator(ByteArrayOutputStream byteArrayOutputStream) throws OracleException {
        try {
            return (Closeable)JSON_FACT_CREATE_BINARY_GENERATOR.invoke(this.getJsonFactory(), byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, new Object[0]);
        }
    }

    private static void writeParserToGenerator(jakarta.json.stream.JsonParser jsonParser, Object object) throws OracleException {
        try {
            JsonpGeneratorWrapper jsonpGeneratorWrapper = new JsonpGeneratorWrapper(object);
            jsonpGeneratorWrapper.writeJsonParser(jsonParser);
            jsonpGeneratorWrapper.close();
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    private static void writeValueToGenerator(Object object, Object object2) throws OracleException {
        try {
            Method method = JSON_GEN_CLASS.getMethod("wrap", Class.class);
            JsonGenerator jsonGenerator = (JsonGenerator)method.invoke(object2, JsonGenerator.class);
            jsonGenerator.write((JsonValue)object);
            jsonGenerator.close();
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    private static void writeOracleValueToGenerator(Object object, Closeable closeable) throws OracleException {
        try {
            Method method = JSON_GEN_CLASS.getMethod("write", JSON_VALUE_CLASS);
            method.invoke((Object)closeable, object);
            closeable.close();
        }
        catch (Exception exception) {
            throw SODAUtils.makeException(SODAMessage.EX_FROM_BINARY_CONVERSION_ERROR, exception, new Object[0]);
        }
    }

    private void putDescriptorIntoCaches(CollectionDescriptor collectionDescriptor) {
        CollectionDescriptor collectionDescriptor2;
        String string = collectionDescriptor.getName();
        if (this.localDescriptorCache != null) {
            collectionDescriptor2 = this.localDescriptorCache.put(string, collectionDescriptor);
            if (OracleLog.isLoggingEnabled()) {
                if (collectionDescriptor2 != null) {
                    log.fine(string + " descriptor was already present in local cache, replaced it with a new descriptor");
                } else {
                    log.fine("Put " + string + " descriptor into local cache");
                }
            }
        }
        if (this.sharedDescriptorCache != null) {
            collectionDescriptor2 = this.sharedDescriptorCache.put(collectionDescriptor);
            if (OracleLog.isLoggingEnabled()) {
                if (collectionDescriptor2 != null) {
                    log.fine(string + " descriptor was already present in shared cache, replaced it with a new descriptor");
                } else {
                    log.fine("Put " + string + " descriptor into local cache");
                }
            }
        }
    }

    private CollectionDescriptor getDescriptorFromCaches(String string) {
        CollectionDescriptor collectionDescriptor = null;
        if (this.localDescriptorCache != null && (collectionDescriptor = this.localDescriptorCache.get(string)) != null) {
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Got " + string + " descriptor from local cache");
            }
            if (this.sharedDescriptorCache != null) {
                this.sharedDescriptorCache.putIfAbsent(collectionDescriptor);
            }
        }
        if (collectionDescriptor == null && this.sharedDescriptorCache != null && (collectionDescriptor = this.sharedDescriptorCache.get(string)) != null) {
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Got " + string + " descriptor from shared cache");
            }
            if (this.localDescriptorCache != null) {
                this.localDescriptorCache.put(string, collectionDescriptor);
            }
        }
        if (collectionDescriptor == null && (this.localCollectionCache != null || this.sharedDescriptorCache != null) && OracleLog.isLoggingEnabled()) {
            log.fine("Descriptor not found in caches");
        }
        return collectionDescriptor;
    }

    private void removeCollectionFromCaches(String string) {
        if (this.sharedDescriptorCache != null) {
            this.sharedDescriptorCache.remove(string);
        }
        if (this.localDescriptorCache != null) {
            this.localDescriptorCache.remove(string);
        }
        if (this.localCollectionCache != null) {
            this.localCollectionCache.remove(string);
        }
    }

    void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metrics = metricsCollector;
    }

    private ArrayList<CollectionDescriptor> loadCollections(Integer n, int n2) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(null, n, n2);
    }

    private ArrayList<CollectionDescriptor> loadCollections(Integer n, String string) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(string, n, 0);
    }

    private OracleCollection createCollection(String string, String string2) throws OracleException {
        try {
            if (this.sqlSyntaxLevel == SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                this.sqlSyntaxLevel = SODAUtils.getDatabaseVersion((Connection)this.conn);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.getMessage());
            }
            throw new OracleException(sQLException);
        }
        if (SODAUtils.sqlSyntaxBelow_19(this.sqlSyntaxLevel)) {
            return this.createCollection(string, (CollectionDescriptor)null, string2);
        }
        return this.createCollection(string, (String)null, string2);
    }

    public OracleCollection createCollection(String string, CollectionDescriptor collectionDescriptor, String string2) throws OracleException {
        OracleCollection oracleCollection = this.openCollection(string, collectionDescriptor, this.maxCacheTimeout);
        if (oracleCollection != null) {
            return oracleCollection;
        }
        if (collectionDescriptor == null) {
            collectionDescriptor = CollectionDescriptor.createStandardBuilder().buildDescriptor(string);
        }
        collectionDescriptor = this.callCreatePLSQL(string, collectionDescriptor.getDescription(), string2);
        return this.openCollection(string, collectionDescriptor, this.maxCacheTimeout);
    }

    public OracleCollection createCollection(String string, String string2, String string3) throws OracleException {
        Object object;
        TableCollectionImpl tableCollectionImpl = null;
        if (string2 == null && (object = this.openCollectionFromCaches(string, null)) != null) {
            return object;
        }
        object = this.callCreatePLSQL(string, string2, string3);
        if (object != null) {
            this.putDescriptorIntoCaches((CollectionDescriptor)object);
            tableCollectionImpl = new TableCollectionImpl(this, string, (CollectionDescriptor)object);
            if (this.localCollectionCache != null) {
                this.localCollectionCache.put(string, tableCollectionImpl);
            }
            if (tableCollectionImpl != null) {
                tableCollectionImpl.setAvoidTxnManagement(this.avoidTxnManagement);
            }
        }
        return tableCollectionImpl;
    }

    @Override
    public OracleCollection openCollection(String string) throws OracleException {
        return this.openCollection(string, this.maxCacheTimeout);
    }

    public OracleCollection openCollection(String string, long l) throws OracleException {
        return this.openCollection(string, null, l);
    }

    private OracleCollection openCollection(String string, CollectionDescriptor collectionDescriptor, long l) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        OracleCollectionImpl oracleCollectionImpl = null;
        if (this.localCollectionCache != null) {
            oracleCollectionImpl = this.localCollectionCache.get(string);
        }
        if (oracleCollectionImpl != null) {
            if (collectionDescriptor != null && !oracleCollectionImpl.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            oracleCollectionImpl.setAvoidTxnManagement(this.avoidTxnManagement);
            return oracleCollectionImpl;
        }
        CollectionDescriptor collectionDescriptor2 = this.getDescriptorFromCaches(string);
        if (collectionDescriptor2 != null) {
            long l2 = collectionDescriptor2.getAccessTime(useLastAccess);
            if (l >= 0L && l2 > l) {
                this.removeCollectionFromCaches(string);
                collectionDescriptor2 = null;
            }
        }
        if (collectionDescriptor2 == null) {
            collectionDescriptor2 = this.loadCollection(string);
        }
        boolean bl = false;
        if (collectionDescriptor2 != null) {
            if (collectionDescriptor != null && !collectionDescriptor2.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            bl = true;
        }
        if (bl) {
            if (collectionDescriptor2.dbObjectType == 2) {
                throw new IllegalStateException();
            }
            oracleCollectionImpl = new TableCollectionImpl(this, string, collectionDescriptor2);
            if (this.localCollectionCache != null) {
                this.localCollectionCache.put(string, oracleCollectionImpl);
            }
        }
        if (oracleCollectionImpl != null) {
            oracleCollectionImpl.setAvoidTxnManagement(this.avoidTxnManagement);
        }
        return oracleCollectionImpl;
    }

    private OracleCollection openCollectionFromCaches(String string, CollectionDescriptor collectionDescriptor) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        OracleCollectionImpl oracleCollectionImpl = null;
        if (this.localCollectionCache != null) {
            oracleCollectionImpl = this.localCollectionCache.get(string);
        }
        if (oracleCollectionImpl != null) {
            if (collectionDescriptor != null && !oracleCollectionImpl.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            oracleCollectionImpl.setAvoidTxnManagement(this.avoidTxnManagement);
            return oracleCollectionImpl;
        }
        CollectionDescriptor collectionDescriptor2 = this.getDescriptorFromCaches(string);
        boolean bl = false;
        if (collectionDescriptor2 != null) {
            long l = collectionDescriptor2.getAccessTime(useLastAccess);
            if (this.maxCacheTimeout >= 0L && l > this.maxCacheTimeout) {
                this.removeCollectionFromCaches(string);
                collectionDescriptor2 = null;
            }
        }
        if (collectionDescriptor2 != null) {
            if (collectionDescriptor != null && !collectionDescriptor2.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            bl = true;
        }
        if (bl) {
            if (collectionDescriptor2.dbObjectType == 2) {
                throw new IllegalStateException();
            }
            oracleCollectionImpl = new TableCollectionImpl(this, string, collectionDescriptor2);
            if (this.localCollectionCache != null) {
                this.localCollectionCache.put(string, oracleCollectionImpl);
            }
        }
        if (oracleCollectionImpl != null) {
            oracleCollectionImpl.setAvoidTxnManagement(this.avoidTxnManagement);
        }
        return oracleCollectionImpl;
    }

    private OracleCollection createCollection(String string, OracleDocument oracleDocument, OracleDatabaseAdmin.CollectionCreateMode collectionCreateMode) throws OracleException {
        String string2 = null;
        string2 = collectionCreateMode == OracleDatabaseAdmin.CollectionCreateMode.MAP ? "MAP" : DEFAULT_COLLECTION_CREATION_MODE;
        if (oracleDocument == null) {
            return this.createCollection(string, string2);
        }
        try {
            if (this.sqlSyntaxLevel == SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                this.sqlSyntaxLevel = SODAUtils.getDatabaseVersion((Connection)this.conn);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.getMessage());
            }
            throw new OracleException(sQLException);
        }
        if (SODAUtils.sqlSyntaxBelow_19(this.sqlSyntaxLevel)) {
            CollectionDescriptor collectionDescriptor = this.createCollectionDescriptor(string, oracleDocument);
            return this.createCollection(string, collectionDescriptor, string2);
        }
        String string3 = oracleDocument.getContentAsString();
        if (string3 == null || string3.isEmpty()) {
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_HAS_NO_CONTENT, new Object[0]);
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        return this.createCollection(string, string3, string2);
    }

    private CollectionDescriptor createCollectionDescriptor(String string, OracleDocument oracleDocument) throws OracleException {
        String string2;
        CollectionDescriptor.Builder builder;
        block3: {
            String string3 = oracleDocument.getContentAsString();
            if (string3 == null || string3.isEmpty()) {
                throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_HAS_NO_CONTENT, new Object[0]);
            }
            builder = CollectionDescriptor.jsonToBuilder(this.jProvider, string3);
            string2 = null;
            try {
                string2 = this.conn.getCurrentSchema();
            }
            catch (SQLException sQLException) {
                if (!OracleLog.isLoggingEnabled()) break block3;
                log.severe(sQLException.getMessage());
            }
        }
        return builder.buildDescriptor(string, string2);
    }

    void dropCollection(String string) throws OracleException {
        this.dropCollection(string, false, false);
    }

    void dropCollection(String string, boolean bl, boolean bl2) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        this.callDropPLSQL(string, bl, bl2);
        this.removeCollectionFromCaches(string);
    }

    public void removeCollectionFromCaches(OracleCollectionImpl oracleCollectionImpl) {
        this.removeCollectionFromCaches(oracleCollectionImpl.admin().getName());
    }

    public void setMaxCacheTimeout(long l) {
        this.maxCacheTimeout = l;
    }

    private List<String> getCollectionNames() throws OracleException {
        return this.getCollectionNames(null, 0);
    }

    private List<String> getCollectionNames(int n) throws OracleException {
        return this.getCollectionNames(n, 0);
    }

    private List<String> getCollectionNames(int n, int n2) throws OracleException {
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        if (n2 < 0) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_NON_NEGATIVE, "skip");
        }
        return this.getCollectionNames((Integer)n, n2);
    }

    private List<String> getCollectionNames(Integer n, int n2) throws OracleException {
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections(n, n2);
        int n3 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n3 > 0) {
            arrayList2 = new ArrayList(n3);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    private List<String> getCollectionNames(int n, String string) throws OracleException {
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "startName");
        }
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections((Integer)n, string);
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n2 > 0) {
            arrayList2 = new ArrayList(n2);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    public OracleDocument createDocumentFromStream(InputStream inputStream) {
        return new OracleDocumentImpl(null, null, null, inputStream, null);
    }

    public OracleDocument createDocumentFromStream(String string, InputStream inputStream) {
        return new OracleDocumentImpl(string, null, null, inputStream, null);
    }

    public OracleDocument createDocumentFromStream(String string, InputStream inputStream, String string2) {
        return new OracleDocumentImpl(string, null, null, inputStream, string2);
    }

    @Override
    public OracleDocument createDocumentFromString(String string) {
        return new OracleDocumentImpl(null, string);
    }

    @Override
    public OracleDocument createDocumentFromString(String string, String string2) {
        return new OracleDocumentImpl(string, string2);
    }

    @Override
    public OracleDocument createDocumentFromString(String string, String string2, String string3) {
        return new OracleDocumentImpl(string, null, null, string2, string3);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(byte[] byArray) {
        return new OracleDocumentImpl(null, byArray);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(String string, byte[] byArray) {
        return new OracleDocumentImpl(string, byArray);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(String string, byte[] byArray, String string2) {
        return new OracleDocumentImpl(string, null, null, byArray, string2);
    }

    MetricsCollector getMetrics() {
        return this.metrics;
    }

    public OracleConnection getConnection() {
        return this.conn;
    }

    long getDatabaseTimeVersion(Instant instant) throws SQLException {
        return ComponentTime.instantToStamp(instant);
    }

    Instant getDatabaseTime() throws SQLException {
        return this.getDatabaseTime(false);
    }

    Instant getDatabaseTime(boolean bl) throws SQLException {
        long l = System.nanoTime();
        long l2 = this.updateNanos == 0L ? -1L : l - this.updateNanos;
        if (bl || l2 > 100000000L || l2 < 0L) {
            this.refreshDatabaseTime(l);
        } else {
            if (l2 <= 0L) {
                l2 = 1L;
            }
            this.currentTimestamp = this.currentTimestamp.plusNanos(l2);
            long l3 = 1000L;
            long l4 = (long)this.currentTimestamp.getNano() % l3;
            if (l4 > 0L) {
                this.currentTimestamp = this.currentTimestamp.plusNanos(l3 - l4);
            }
        }
        return this.currentTimestamp;
    }

    private void setDatabaseTime(long l, Instant instant) {
        if (instant.compareTo(this.currentTimestamp) <= 0) {
            instant = this.currentTimestamp.plusNanos(1L);
        }
        this.updateNanos = l;
        this.currentTimestamp = instant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDatabaseTime(long l) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_DB_TIMESTAMP;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setFetchSize(1);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                OffsetDateTime offsetDateTime = resultSet.getObject(1, OffsetDateTime.class);
                Instant object = offsetDateTime.toInstant();
                this.setDatabaseTime(l, object);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordTimestampRead();
        }
        catch (Throwable throwable) {
            for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string2);
            }
            throw throwable;
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    long getDatabaseScn() throws OracleException {
        CallableStatement callableStatement = null;
        String string = SELECT_SCN;
        long l = -1L;
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.execute();
            l = callableStatement.getLong(1);
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return l;
    }

    public String getAsOfTimestamp() throws OracleException {
        try {
            return ComponentTime.instantToString(this.getDatabaseTime(true));
        }
        catch (SQLException sQLException) {
            throw SODAUtils.makeExceptionWithSQLText(sQLException, SELECT_DB_TIMESTAMP);
        }
    }

    public long getAsOfScn() throws OracleException {
        return this.getDatabaseScn();
    }

    String nextGuid() throws OracleException {
        if (this.guidCachePos >= this.guidCache.length) {
            this.fetchGuids();
        }
        return this.guidCache[this.guidCachePos++];
    }

    private void fetchGuids() throws OracleException {
        CallableStatement callableStatement = null;
        String string = SELECT_GUID_BATCH;
        int n = 100;
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.setInt(1, n);
            callableStatement.registerOutParameter(2, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            callableStatement.execute();
            Array array = callableStatement.getArray(2);
            String[] object = (String[])array.getArray();
            n = object.length;
            if (n > 0) {
                this.guidCachePos -= n;
                for (int i = 0; i < n; ++i) {
                    this.guidCache[this.guidCachePos + i] = object[i];
                }
            }
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordGUIDS();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.getMessage());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetchGuid() {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_GUID;
        byte[] byArray = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                byArray = resultSet.getBytes(1);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordGUIDS();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.getMessage());
                }
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
            for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string3);
            }
        }
        for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return byArray;
    }

    String generateKey() throws OracleException {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.hasher.getRandom();
            }
            catch (Exception exception) {
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.warning(exception.toString());
            }
        }
        if (byArray == null) {
            byArray = this.fetchGuid();
        }
        if (byArray == null) {
            throw SODAUtils.makeException(SODAMessage.EX_UNABLE_TO_CREATE_UUID, new Object[0]);
        }
        return ByteArray.rawToHex(byArray);
    }

    @Override
    public OracleDatabaseAdmin admin() {
        if (this.admin == null) {
            this.admin = new OracleDatabaseAdministrationImpl();
        }
        return this.admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callDropPLSQL(String string, boolean bl, boolean bl2) throws OracleException {
        try {
            if (this.sqlSyntaxLevel == SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                this.sqlSyntaxLevel = SODAUtils.getDatabaseVersion((Connection)this.conn);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.getMessage());
            }
            throw new OracleException(sQLException);
        }
        String string2 = null;
        if (SODAUtils.sqlSyntaxBelow_21(this.sqlSyntaxLevel)) {
            if (bl || bl2) {
                throw SODAUtils.makeException(SODAMessage.EX_PURGE_AND_DROP_MAPPED_NOT_SUPPORTED, new Object[0]);
            }
            string2 = "begin\n DBMS_SODA_ADMIN.DROP_COLLECTION(P_URI_NAME => ?);\nend;";
        } else {
            string2 = "begin\n DBMS_SODA_ADMIN.DROP_COLLECTION(P_URI_NAME => ?,  P_PURGE => ?,  P_DROP_MAPPED_TABLE => ?);\nend;";
        }
        OracleCallableStatement oracleCallableStatement = null;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            if (!SODAUtils.sqlSyntaxBelow_21(this.sqlSyntaxLevel)) {
                if (bl) {
                    oracleCallableStatement.setString(2, "TRUE");
                } else {
                    oracleCallableStatement.setString(2, "FALSE");
                }
                if (bl2) {
                    oracleCallableStatement.setString(3, "TRUE");
                } else {
                    oracleCallableStatement.setString(3, "FALSE");
                }
            }
            oracleCallableStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Dropped collection " + string);
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                boolean bl3 = false;
                try {
                    if (this.sqlSyntaxLevel == SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                        this.sqlSyntaxLevel = SODAUtils.getDatabaseVersion((Connection)this.conn);
                    }
                }
                catch (SQLException sQLException2) {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException2.getMessage());
                    }
                    throw new OracleException(sQLException2);
                }
                if (!SODAUtils.sqlSyntaxBelow_12_2(this.sqlSyntaxLevel)) {
                    if (sQLException.getErrorCode() == 40626) {
                        bl3 = true;
                    }
                } else if (sQLException.getErrorCode() == 54) {
                    bl3 = true;
                }
                if (bl3) {
                    throw SODAUtils.makeExceptionWithSQLText(SODAMessage.EX_COMMIT_MIGHT_BE_NEEDED, sQLException, string2, new Object[0]);
                }
                if (sQLException.getErrorCode() != 40671) {
                    throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
                }
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
            for (String string4 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string5 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
    }

    public boolean set23CDriverParameter() throws OracleException {
        try {
            if (this.sqlSyntaxLevel == SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN) {
                this.sqlSyntaxLevel = SODAUtils.getDatabaseVersion((Connection)this.conn);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.getMessage());
            }
            throw new OracleException(sQLException);
        }
        return !SODAUtils.sqlSyntaxBelow_23(this.sqlSyntaxLevel) && !SODAUtils.sqlSyntax_23_2(this.sqlSyntaxLevel);
    }

    private CollectionDescriptor callCreatePLSQL(String string, String string2, String string3) throws OracleException {
        CallableStatement callableStatement = null;
        String string4 = "begin\n  DBMS_SODA_ADMIN.CREATE_COLLECTION(\n                   P_URI_NAME    => ?,\n                   P_CREATE_MODE => ?,\n                   P_DESCRIPTOR  => ?,\n                   P_CREATE_TIME => ?);\nend;";
        String string5 = "begin\n  DBMS_SODA_ADMIN.CREATE_COLLECTION(\n                   P_URI_NAME    => ?,\n                   P_CREATE_MODE => ?,\n                   P_DESCRIPTOR  => ?,\n                   P_CREATE_TIME => ?,\n                   P_23C_DRIVER => true);\nend;";
        String string6 = string2;
        if (OracleLog.isLoggingEnabled()) {
            log.info("Create collection:\n" + string6);
        }
        CollectionDescriptor collectionDescriptor = null;
        String string7 = null;
        try {
            this.metrics.startTiming();
            callableStatement = this.set23CDriverParameter() ? this.conn.prepareCall(string5) : this.conn.prepareCall(string4);
            callableStatement.setNString(1, string);
            if (string3 == null) {
                string3 = DEFAULT_COLLECTION_CREATION_MODE;
            }
            callableStatement.setString(2, string3);
            callableStatement.setString(3, string6);
            callableStatement.registerOutParameter(3, 12, 4000);
            callableStatement.registerOutParameter(4, 12, 255);
            try {
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                if (this.set23CDriverParameter() && sQLException.getErrorCode() == 6550) {
                    callableStatement.close();
                    callableStatement = this.conn.prepareCall(string4);
                    callableStatement.setNString(1, string);
                    callableStatement.setString(2, string3);
                    callableStatement.setString(3, string6);
                    callableStatement.registerOutParameter(3, 12, 4000);
                    callableStatement.registerOutParameter(4, 12, 255);
                    callableStatement.execute();
                }
                throw sQLException;
            }
            if (OracleLog.isLoggingEnabled()) {
                log.info("Created collection " + string);
            }
            String string8 = callableStatement.getString(4);
            string6 = callableStatement.getString(3);
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordDDL();
            if (string8 != null) {
                CollectionDescriptor.Builder object = CollectionDescriptor.jsonToBuilder(this.jProvider, string6);
                collectionDescriptor = object.buildDescriptor(string);
            }
            if ((string7 = this.callGetDDL()) != null && OracleLog.isLoggingEnabled()) {
                log.info(string7);
            }
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                if ((string7 = this.callGetDDL()) != null) {
                    string4 = string7;
                }
                if (sQLException.getErrorCode() == 40669) {
                    throw SODAUtils.makeExceptionWithSQLText(SODAMessage.EX_MISMATCHED_DESCRIPTORS, sQLException, string4, new Object[0]);
                }
                if (sQLException.getErrorCode() == 40675) {
                    throw SODAUtils.makeExceptionWithSQLText(SODAMessage.EX_METADATA_DOC_INVALID_JSON, sQLException, string4, new Object[0]);
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string4);
            }
            catch (Throwable throwable) {
                for (String string8 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string8);
                }
                throw throwable;
            }
        }
        for (String string9 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string9);
        }
        return collectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callGetDDL() {
        String string = null;
        CallableStatement callableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.GET_SQL_TEXT(?);\nend;";
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string2);
            callableStatement.registerOutParameter(1, 12, 32500);
            callableStatement.execute();
            string = callableStatement.getString(1);
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
            for (String string4 : SODAUtils.closeCursor(callableStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string5 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
        return string;
    }

    private CollectionDescriptor loadCollection(String string) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        CallableStatement callableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.DESCRIBE_COLLECTION(\n                   P_URI_NAME   => ?,\n                   P_DESCRIPTOR => ?);\nend;";
        String string3 = "begin\n  DBMS_SODA_ADMIN.DESCRIBE_COLLECTION(\n                   P_URI_NAME   => ?,\n                   P_DESCRIPTOR => ?,\n                   P_23C_DRIVER => true);\nend;";
        CollectionDescriptor collectionDescriptor = null;
        try {
            this.metrics.startTiming();
            callableStatement = this.set23CDriverParameter() ? this.conn.prepareCall(string3) : this.conn.prepareCall(string2);
            callableStatement.setNString(1, string);
            callableStatement.registerOutParameter(2, 12, 4000);
            try {
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                if (this.set23CDriverParameter() && sQLException.getErrorCode() == 6550) {
                    callableStatement.close();
                    callableStatement = this.conn.prepareCall(string2);
                    callableStatement.setNString(1, string);
                    callableStatement.registerOutParameter(2, 12, 4000);
                    callableStatement.execute();
                }
                throw sQLException;
            }
            String string4 = callableStatement.getString(2);
            if (string4 != null) {
                CollectionDescriptor.Builder object = CollectionDescriptor.jsonToBuilder(this.jProvider, string4);
                collectionDescriptor = object.buildDescriptor(string);
                this.putDescriptorIntoCaches(collectionDescriptor);
            } else {
                this.removeCollectionFromCaches(string);
            }
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string4 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string4);
                }
                throw throwable;
            }
        }
        for (String string5 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
        return collectionDescriptor;
    }

    private ArrayList<CollectionDescriptor> callListCollections(String string, Integer n, int n2) throws OracleException {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.LIST_COLLECTIONS(\n                   P_START_NAME => ?,\n                   P_RESULTS    => ?);\nend;";
        String string3 = "begin\n  DBMS_SODA_ADMIN.LIST_COLLECTIONS(\n                   P_START_NAME => ?,\n                   P_RESULTS    => ?,\n                   P_23C_DRIVER => true);\nend;";
        boolean bl = false;
        ArrayList<CollectionDescriptor> arrayList = new ArrayList<CollectionDescriptor>();
        try {
            int n3 = 0;
            this.metrics.startTiming();
            callableStatement = this.set23CDriverParameter() ? this.conn.prepareCall(string3) : this.conn.prepareCall(string2);
            if (string == null) {
                callableStatement.setNull(1, 12);
            } else {
                callableStatement.setNString(1, string);
            }
            callableStatement.registerOutParameter(2, -10);
            try {
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                if (this.set23CDriverParameter() && sQLException.getErrorCode() == 6550) {
                    callableStatement.close();
                    callableStatement = this.conn.prepareCall(string2);
                    if (string == null) {
                        callableStatement.setNull(1, 12);
                    } else {
                        callableStatement.setNString(1, string);
                    }
                    callableStatement.registerOutParameter(2, -10);
                    callableStatement.execute();
                }
                throw sQLException;
            }
            resultSet = ((OracleCallableStatement)callableStatement).getCursor(2);
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Loaded collections");
            }
            while (resultSet.next()) {
                String string4 = resultSet.getNString(1);
                String string5 = resultSet.getString(2);
                CollectionDescriptor.Builder builder = CollectionDescriptor.jsonToBuilder(this.jProvider, string5);
                CollectionDescriptor collectionDescriptor = builder.buildDescriptor(string4);
                this.putDescriptorIntoCaches(collectionDescriptor);
                if (n3 >= n2 && !bl) {
                    arrayList.add(collectionDescriptor);
                }
                if (n == null || n <= 0 || ++n3 < n2 + n) continue;
                if (n3 > 1000) break;
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string6 : SODAUtils.closeCursor(callableStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string6);
                }
                throw throwable;
            }
        }
        for (String string4 : SODAUtils.closeCursor(callableStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return arrayList;
    }

    static void addToTimestamp(String string, StringBuilder stringBuilder) {
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("to_timestamp(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
    }

    boolean isUnicode() throws OracleException {
        try {
            short s;
            if (!(this.dbIsUnicode || (s = this.conn.getStructAttrCsId()) != 873 && s != 871)) {
                this.dbIsUnicode = true;
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
            }
            throw new OracleException(sQLException);
        }
        return this.dbIsUnicode;
    }

    int getMaxRawLength() {
        return this.rawMaxLength;
    }

    int getMaxVarcharLength() {
        return this.varcharMaxLength;
    }

    int getMaxNvarcharLength() {
        return this.nvarcharMaxLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMaxLengths() {
        if (!this.metadataTableExists) {
            return;
        }
        CallableStatement callableStatement = null;
        String string = "declare\n  KARR XDB.DBMS_SODA_ADMIN.VCNTAB;\n  VARR XDB.DBMS_SODA_ADMIN.VCNTAB;\n  KEYS XDB.DBMS_SODA_ADMIN.VCTAB;\n  VALS XDB.DBMS_SODA_ADMIN.VCTAB;\nbegin\n  DBMS_SODA_ADMIN.GET_PARAMETERS(\n                  P_KEY   => KEYS,\n                  P_VALUE => VALS);\n  KARR := XDB.DBMS_SODA_ADMIN.VCNTAB();\n  VARR := XDB.DBMS_SODA_ADMIN.VCNTAB();\n  KARR.extend(KEYS.count);\n  VARR.extend(VALS.count);\n  for I in 1..KEYS.count loop\n    KARR(I) := KEYS(I);\n  end loop;\n  for I in 1..VALS.count loop\n    VARR(I) := VALS(I);\n  end loop;\n  ? := KARR;\n  ? := VARR;\nend;";
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.registerOutParameter(1, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            callableStatement.registerOutParameter(2, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            callableStatement.execute();
            String[] stringArray = (String[])callableStatement.getArray(1).getArray();
            String[] object = (String[])callableStatement.getArray(2).getArray();
            int n = stringArray.length;
            if (n > object.length) {
                n = object.length;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                String string3 = object[i];
                try {
                    if (string2.equalsIgnoreCase("VARCHAR2_MAX")) {
                        this.varcharMaxLength = Integer.parseInt(string3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("NVARCHAR2_MAX")) {
                        this.nvarcharMaxLength = Integer.parseInt(string3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("RAW_MAX")) {
                        this.rawMaxLength = Integer.parseInt(string3);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("DB_IS_UNICODE") || this.dbIsUnicode) continue;
                    this.dbIsUnicode = string3.equalsIgnoreCase("true");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.warning(numberFormatException.toString());
                }
            }
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
            }
            catch (Throwable throwable) {
                for (String string4 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string4);
                }
                throw throwable;
            }
            for (String string5 : SODAUtils.closeCursor(callableStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string5);
            }
        }
        for (String string6 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
    }

    public List<OracleDropResult> dropCollections(boolean bl) throws OracleException {
        ArrayList<OracleDropResult> arrayList;
        if (!this.metadataTableExists) {
            return new ArrayList<OracleDropResult>();
        }
        ArrayList<OracleDropResult> arrayList2 = new ArrayList<OracleDropResult>();
        CallableStatement callableStatement = null;
        String string = "begin\n  DBMS_SODA_ADMIN.DROP_COLLECTIONS(\n                  P_COLLECTIONS => ?,\n                  P_ERRORS => ?,\n                  P_FORCE => ?);\nend;";
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.registerOutParameter(1, 2003, "XDB.DBMS_SODA_ADMIN.NVCNTAB");
            callableStatement.registerOutParameter(2, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            if (bl) {
                callableStatement.setString(3, "true");
            } else {
                callableStatement.setString(3, "false");
            }
            callableStatement.execute();
            Array array = callableStatement.getArray(1);
            Array array2 = callableStatement.getArray(2);
            final String[] stringArray = (String[])array.getArray();
            final String[] stringArray2 = (String[])array2.getArray();
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordDDL();
            int n = 0;
            while (n < stringArray.length) {
                final int n2 = n++;
                arrayList2.add(new OracleDropResult(){
                    String collName;
                    String error;
                    {
                        this.collName = stringArray[n2];
                        this.error = stringArray2[n2];
                    }

                    @Override
                    public String getName() {
                        return this.collName;
                    }

                    @Override
                    public String getError() {
                        return this.error;
                    }
                });
            }
            if (this.sharedDescriptorCache != null) {
                this.sharedDescriptorCache.clear();
            }
            if (this.localDescriptorCache != null) {
                this.localDescriptorCache.clear();
            }
            if (this.localCollectionCache != null) {
                this.localCollectionCache.clear();
            }
            arrayList = arrayList2;
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDateTimeNumFormats() {
        PreparedStatement preparedStatement = null;
        try {
            String string = "alter session set NLS_DATE_FORMAT='YYYY-MM-DD\"T\"HH24:MI:SS'";
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            preparedStatement.close();
            string = "alter session set NLS_TIMESTAMP_FORMAT='YYYY-MM-DD\"T\"HH24:MI:SS.FF'";
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            preparedStatement.close();
            string = "alter session set NLS_NUMERIC_CHARACTERS='.,'";
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.info(sQLException.toString());
                }
            }
            catch (Throwable throwable) {
                for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string);
                }
                throw throwable;
            }
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string);
        }
    }

    public void setJsonFactoryProvider(JsonFactoryProvider jsonFactoryProvider) {
        this.jProvider = jsonFactoryProvider;
    }

    public JsonFactoryProvider getJsonFactoryProvider() {
        return this.jProvider;
    }

    String nextObjectId() throws OracleException {
        if (this.objectIdCachePos >= this.objectIdCache.length) {
            this.fetchObjectIds();
        }
        return this.objectIdCache[this.objectIdCachePos++];
    }

    public void fetchObjectIds() throws OracleException {
        CallableStatement callableStatement = null;
        String string = SELECT_OBJECTID_BATCH;
        int n = 100;
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.setInt(1, n);
            callableStatement.registerOutParameter(2, 2014);
            callableStatement.registerOutParameter(3, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            callableStatement.execute();
            Array array = callableStatement.getArray(3);
            String[] object = (String[])array.getArray();
            n = object.length;
            if (n > 0) {
                OffsetDateTime offsetDateTime = callableStatement.getObject(2, OffsetDateTime.class);
                Instant instant = offsetDateTime.toInstant();
                long l = instant.toEpochMilli() / 1000L;
                String string2 = Long.toHexString(l &= 0xFFFFFFFFL);
                int n2 = string2.length();
                if (n2 < 8) {
                    string2 = "00000000".substring(n2) + string2;
                }
                this.objectIdCachePos -= n;
                for (int i = 0; i < n; ++i) {
                    String string3 = string2;
                    String string4 = object[i].toLowerCase();
                    string3 = string3 + string4.substring(26);
                    string3 = string3 + string4.substring(12, 16);
                    this.objectIdCache[this.objectIdCachePos + i] = string3 = string3 + string4.substring(6, 12);
                }
            }
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordGUIDS();
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string5 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string5);
                }
                throw throwable;
            }
        }
        for (String string6 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
    }

    public Object getJsonFactory() throws OracleException {
        if (JSON_FACT_CLASS == null) {
            throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, new Object[0]);
        }
        Object object = this.jsonFactory;
        if (object == null) {
            try {
                this.jsonFactory = object = JSON_FACT_CLASS.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return object;
    }

    public void setJsonFactory(Object object) {
        this.jsonFactory = object;
    }

    public static boolean isOracleJsonAvailable() {
        return JSON_FACT_CLASS != null;
    }

    public static boolean isJavaxJsonAvailable() {
        return JAVAX_JSON_VALUE_CLASS != null;
    }

    public DocumentCodecFactory getCodecFactory() {
        if (this.codecFactory == null) {
            block5: {
                try {
                    if (CODEC_CLASS != null) {
                        this.codecFactory = CODEC_CLASS.newInstance();
                    }
                }
                catch (Exception exception) {
                    if (!OracleLog.isLoggingEnabled()) break block5;
                    log.fine(exception.getMessage());
                }
            }
            if (this.codecFactory == null) {
                this.codecFactory = new DocumentCodecFactory();
            }
        }
        this.codecFactory.setFactoryProvider(this.jProvider);
        return this.codecFactory;
    }

    public void cancelOperation() {
        OracleDatabaseImpl.cancelOperation((Connection)this.conn);
    }

    public static void cancelOperation(Connection connection) {
        block3: {
            try {
                if (CANCEL_METHOD != null) {
                    CANCEL_METHOD.invoke((Object)connection, new Object[0]);
                }
            }
            catch (Exception exception) {
                if (!OracleLog.isLoggingEnabled()) break block3;
                log.warning(exception.getMessage());
            }
        }
    }

    void setLobPrefetchSize(Statement statement) {
        block3: {
            try {
                if (PREFETCH_METHOD != null) {
                    PREFETCH_METHOD.invoke((Object)statement, LOB_PREFETCH_SIZE);
                }
            }
            catch (Exception exception) {
                if (!OracleLog.isLoggingEnabled()) break block3;
                log.fine(exception.getMessage());
            }
        }
    }

    boolean setBytesForBlob(Statement statement, int n, byte[] byArray) throws SQLException {
        block4: {
            try {
                if (SET_BLOB_BYTES != null) {
                    SET_BLOB_BYTES.invoke((Object)statement, new Integer(n), byArray);
                    return true;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return false;
    }

    boolean setStringForClob(Statement statement, int n, String string) throws SQLException {
        block4: {
            try {
                if (SET_CLOB_STRING != null) {
                    SET_CLOB_STRING.invoke((Object)statement, new Integer(n), string);
                    return true;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return false;
    }

    boolean registerReturnString(Statement statement, int n) throws SQLException {
        block4: {
            try {
                if (REGISTER_RETURN_PARAMETER != null) {
                    REGISTER_RETURN_PARAMETER.invoke((Object)statement, new Integer(n), RETURN_VARCHAR);
                    return true;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return false;
    }

    boolean registerReturnBinary(Statement statement, int n) throws SQLException {
        block4: {
            try {
                if (REGISTER_RETURN_PARAMETER != null) {
                    REGISTER_RETURN_PARAMETER.invoke((Object)statement, new Integer(n), RETURN_BINARY);
                    return true;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return false;
    }

    boolean registerReturnTimestamp(Statement statement, int n) throws SQLException {
        block4: {
            try {
                if (REGISTER_RETURN_PARAMETER != null) {
                    REGISTER_RETURN_PARAMETER.invoke((Object)statement, new Integer(n), RETURN_TIMESTAMP);
                    return true;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return false;
    }

    ResultSet getReturnResultSet(Statement statement) throws SQLException {
        block4: {
            try {
                if (GET_RETURN_RESULT_SET != null) {
                    return (ResultSet)GET_RETURN_RESULT_SET.invoke((Object)statement, new Object[0]);
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.fine(exception.getMessage());
            }
        }
        return null;
    }

    public boolean hasOracleConnection() {
        return OracleDatabaseImpl.isOracleConnection((Connection)this.conn);
    }

    public static boolean isOracleConnection(Connection connection) {
        if (ORACLE_CONNECTION == null) {
            return false;
        }
        return ORACLE_CONNECTION.isInstance(connection);
    }

    void setBytesForJson(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        if (byArray2 == null) {
            byArray2 = byArray;
        }
        preparedStatement.setObject(n, (Object)byArray2, 2016);
    }

    static byte[] getBytesForJson(ResultSet resultSet, int n) throws OracleException {
        try {
            Object obj;
            if (JSON_SHARE_BYTES != null && (obj = resultSet.getObject(n, JSON_DATUM_CLASS)) != null) {
                return (byte[])JSON_SHARE_BYTES.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw new OracleException((SQLException)exception);
            }
            if (OracleLog.isLoggingEnabled()) {
                log.fine(exception.getMessage());
            }
            throw new OracleException(exception);
        }
        return null;
    }

    @Override
    public OracleDocument createDocumentFrom(Object object) throws OracleException {
        return this.createDocumentFrom(null, object);
    }

    @Override
    public OracleDocument createDocumentFrom(String string, Object object) throws OracleException {
        if (!OracleDatabaseImpl.isOracleJsonAvailable()) {
            throw SODAUtils.makeException(SODAMessage.EX_JSON_FACTORY_MISSING_IN_JDBC, new Object[0]);
        }
        byte[] byArray = this.convertToOson(object);
        OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl(string, null, null, byArray);
        oracleDocumentImpl.setBinary();
        oracleDocumentImpl.setJsonFactory(this.getJsonFactory());
        oracleDocumentImpl.setCodec(this.getCodecFactory().getCodec());
        return oracleDocumentImpl;
    }

    private byte[] convertToOson(Object object) throws OracleException {
        if (object instanceof InputStream) {
            return this.convertByteArrayToOson(this.readStream((InputStream)object));
        }
        if (object instanceof byte[]) {
            return this.convertByteArrayToOson((byte[])object);
        }
        if (object instanceof CharSequence) {
            return this.textToBinary(new StringReader(((CharSequence)object).toString()));
        }
        if (object instanceof Reader) {
            return this.textToBinary((Reader)object);
        }
        if (JSON_VALUE_CLASS != null && JSON_VALUE_CLASS.isInstance(object)) {
            return this.oracleJsonValueToBinary(object);
        }
        if (JSON_PARSE_CLASS != null && JSON_PARSE_CLASS.isInstance(object)) {
            return this.oracleJsonParserToBinary(object);
        }
        if (JAVAX_JSON_VALUE_CLASS != null && JAVAX_JSON_VALUE_CLASS.isInstance(object)) {
            return this.javaxJsonValueToBinary(object);
        }
        if (JAVAX_JSON_PARSE_CLASS != null && JAVAX_JSON_PARSE_CLASS.isInstance(object)) {
            return this.javaxJsonParserToBinary(object);
        }
        throw SODAUtils.makeException(SODAMessage.EX_INVALID_TYPE_MAPPING, object == null ? null : object.getClass());
    }

    private byte[] convertByteArrayToOson(byte[] byArray) throws OracleException {
        return OracleDatabaseImpl.isOsonArray(byArray) ? byArray : this.textToBinary(byArray);
    }

    private static boolean isOsonArray(byte[] byArray) {
        return byArray.length > MAGIC_BYTES.length && byArray[0] == MAGIC_BYTES[0] && byArray[1] == MAGIC_BYTES[1] && byArray[2] == MAGIC_BYTES[2];
    }

    private byte[] readStream(InputStream inputStream) throws OracleException {
        try {
            int n;
            byte[] byArray = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new OracleException(iOException);
        }
    }

    public static String localDateTimeToString(LocalDateTime localDateTime) {
        StringBuilder stringBuilder = new StringBuilder(27);
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getYear(), 4);
        stringBuilder.append("-");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getMonthValue(), 2);
        stringBuilder.append("-");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getDayOfMonth(), 2);
        stringBuilder.append("T");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getHour(), 2);
        stringBuilder.append(":");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getMinute(), 2);
        stringBuilder.append(":");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getSecond(), 2);
        stringBuilder.append(".");
        OracleDatabaseImpl.appendInt(stringBuilder, localDateTime.getNano(), 9);
        stringBuilder.append("Z");
        return stringBuilder.toString();
    }

    private static void appendInt(StringBuilder stringBuilder, int n, int n2) {
        int n3 = n;
        while (n3 > 0) {
            n3 /= 10;
            --n2;
        }
        while (n2 > 0) {
            stringBuilder.append('0');
            --n2;
        }
        if (n != 0) {
            stringBuilder.append(n);
        }
    }

    public static String getTimestamp(ResultSet resultSet, int n) throws SQLException {
        LocalDateTime localDateTime = resultSet.getObject(n, LocalDateTime.class);
        return OracleDatabaseImpl.localDateTimeToString(localDateTime);
    }

    public static String getTimestamp(CallableStatement callableStatement, int n) throws SQLException {
        LocalDateTime localDateTime = callableStatement.getObject(n, LocalDateTime.class);
        return OracleDatabaseImpl.localDateTimeToString(localDateTime);
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Method method4;
        Method method5;
        Method method6;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Method method7;
        useLastAccess = Boolean.getBoolean("oracle.soda.rdbms.impl.OracleDatabaseImpl.lastAccess");
        MAGIC_BYTES = new byte[]{-1, 74, 90};
        EMPTY_LIST = new ArrayList();
        log = Logger.getLogger(OracleDatabaseImpl.class.getName());
        HASHER = new ThreadLocal<HashFuncs>(){

            @Override
            public HashFuncs initialValue() {
                return new HashFuncs();
            }
        };
        SELECT_DB_TIMESTAMP = "select SYSTIMESTAMP from SYS.DUAL";
        LOB_PREFETCH_SIZE = new Integer(65000);
        RETURN_VARCHAR = new Integer(12);
        RETURN_TIMESTAMP = new Integer(93);
        RETURN_BINARY = new Integer(-2);
        Class<Connection> clazz8 = null;
        try {
            clazz8 = Class.forName("oracle.jdbc.OracleConnection").asSubclass(Connection.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz8 = null;
        }
        ORACLE_CONNECTION = clazz8;
        try {
            method7 = clazz8 == null ? null : clazz8.getMethod("cancel", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        CANCEL_METHOD = method7;
        Class<PreparedStatement> clazz9 = null;
        try {
            clazz9 = Class.forName("oracle.jdbc.OraclePreparedStatement").asSubclass(PreparedStatement.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz9 = null;
        }
        try {
            method7 = clazz9 == null ? null : clazz9.getMethod("setLobPrefetchSize", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        PREFETCH_METHOD = method7;
        try {
            method7 = clazz9 == null ? null : clazz9.getMethod("setBytesForBlob", Integer.TYPE, byte[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        SET_BLOB_BYTES = method7;
        try {
            method7 = clazz9 == null ? null : clazz9.getMethod("setStringForClob", Integer.TYPE, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        SET_CLOB_STRING = method7;
        try {
            method7 = clazz9 == null ? null : clazz9.getMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        REGISTER_RETURN_PARAMETER = method7;
        try {
            method7 = clazz9 == null ? null : clazz9.getMethod("getReturnResultSet", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method7 = null;
        }
        GET_RETURN_RESULT_SET = method7;
        try {
            clazz7 = Class.forName("javax.json.JsonValue");
            clazz6 = Class.forName("javax.json.stream.JsonParser");
        }
        catch (Exception exception) {
            clazz7 = null;
            clazz6 = null;
        }
        JAVAX_JSON_VALUE_CLASS = clazz7;
        JAVAX_JSON_PARSE_CLASS = clazz6;
        try {
            clazz5 = Class.forName("oracle.sql.json.OracleJsonValue");
            clazz4 = Class.forName("oracle.sql.json.OracleJsonFactory");
            clazz3 = Class.forName("oracle.sql.json.OracleJsonParser");
            clazz2 = Class.forName("oracle.sql.json.OracleJsonGenerator");
            clazz = Class.forName("oracle.sql.json.OracleJsonDatum");
            method7 = clazz.getMethod("shareBytes", new Class[0]);
            method6 = clazz4.getMethod("createJsonBinaryValue", ByteBuffer.class);
            method5 = clazz4.getMethod("createJsonBinaryParser", ByteBuffer.class);
            method4 = clazz4.getMethod("createJsonTextGenerator", OutputStream.class);
            method3 = clazz4.getMethod("createJsonBinaryGenerator", OutputStream.class);
        }
        catch (Exception exception) {
            clazz4 = null;
            clazz2 = null;
            clazz3 = null;
            clazz = null;
            clazz5 = null;
            method6 = null;
            method5 = null;
            method3 = null;
            method4 = null;
            method7 = null;
        }
        JSON_FACT_CLASS = clazz4;
        JSON_VALUE_CLASS = clazz5;
        JSON_PARSE_CLASS = clazz3;
        JSON_GEN_CLASS = clazz2;
        JSON_DATUM_CLASS = clazz;
        JSON_SHARE_BYTES = method7;
        JSON_FACT_CREATE_BINARY_VALUE = method6;
        JSON_FACT_CREATE_BINARY_PARSER = method5;
        JSON_FACT_CREATE_JSON_TEXT_GENERATOR = method4;
        JSON_FACT_CREATE_BINARY_GENERATOR = method3;
        try {
            method2 = clazz4.getMethod("createJsonTextParser", InputStream.class);
            method = clazz4.getMethod("createJsonTextValue", InputStream.class);
        }
        catch (Exception exception) {
            method2 = null;
            method = null;
        }
        JSON_FACT_CREATE_TEXT_PARSER = method2;
        JSON_FACT_CREATE_TEXT_VALUE = method;
        Class<DocumentCodecFactory> clazz10 = null;
        if (OracleDatabaseImpl.isOracleJsonAvailable()) {
            try {
                clazz10 = Class.forName("oracle.json.rdbms.OsonCodecFactory").asSubclass(DocumentCodecFactory.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz10 = null;
            }
        }
        CODEC_CLASS = clazz10;
    }

    private class OracleDatabaseAdministrationImpl
    implements OracleDatabaseAdmin {
        private OracleDatabaseAdministrationImpl() {
        }

        @Override
        public OracleCollection createCollection(String string) throws OracleException {
            return OracleDatabaseImpl.this.createCollection(string, null);
        }

        @Override
        public OracleCollection createCollection(String string, OracleDocument oracleDocument) throws OracleException {
            return OracleDatabaseImpl.this.createCollection(string, oracleDocument, null);
        }

        @Override
        public OracleCollection createCollection(String string, OracleDocument oracleDocument, OracleDatabaseAdmin.CollectionCreateMode collectionCreateMode) throws OracleException {
            return OracleDatabaseImpl.this.createCollection(string, oracleDocument, collectionCreateMode);
        }

        @Override
        public List<String> getCollectionNames() throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames();
        }

        @Override
        public List<String> getCollectionNames(int n) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n);
        }

        @Override
        public List<String> getCollectionNames(int n, int n2) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n, n2);
        }

        @Override
        public List<String> getCollectionNames(int n, String string) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n, string);
        }

        public OracleConnection getConnection() {
            return OracleDatabaseImpl.this.getConnection();
        }

        @Override
        public List<OracleDropResult> dropCollections(boolean bl) throws OracleException {
            return OracleDatabaseImpl.this.dropCollections(bl);
        }
    }
}

