/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;

public final class HashFuncs {
    public static final Charset DEFAULT_CHARSET = ByteArray.DEFAULT_CHARSET;
    public static final String SHA256_ALGORITHM = "SHA-256";
    public static final String SHA1_ALGORITHM = "SHA-1";
    public static final String MD5_ALGORITHM = "MD5";
    private static final Logger log = Logger.getLogger("global");
    private MessageDigest sha256_md;
    private MessageDigest sha1_md;
    private MessageDigest md5_md;
    private Mac hmac256;
    private Mac hmac1;
    private SecretKeyFactory sha256_factory;
    private SecretKeyFactory sha1_factory;
    private final SecureRandom rand = new SecureRandom();
    public int num_iters = 0;
    public byte[] salt;
    public byte[] salted_hash;
    public byte[] client_key;
    public byte[] server_key;
    public byte[] stored_key;
    public static final byte[] CLIENT_KEY = "Client Key".getBytes(ByteArray.DEFAULT_CHARSET);
    public static final byte[] SERVER_KEY = "Server Key".getBytes(ByteArray.DEFAULT_CHARSET);

    private byte[] computeDigest(MessageDigest messageDigest, byte[] byArray) {
        messageDigest.reset();
        return messageDigest.digest(byArray);
    }

    public byte[] SHA256(String string) throws NoSuchAlgorithmException {
        byte[] byArray = string.getBytes(DEFAULT_CHARSET);
        return this.SHA256(byArray);
    }

    public byte[] MD5(String string) throws NoSuchAlgorithmException {
        byte[] byArray = string.getBytes(DEFAULT_CHARSET);
        return this.MD5(byArray);
    }

    public byte[] SHA1(String string) throws NoSuchAlgorithmException {
        byte[] byArray = string.getBytes(DEFAULT_CHARSET);
        return this.SHA1(byArray);
    }

    public byte[] SHA256(byte[] byArray) throws NoSuchAlgorithmException {
        if (this.sha256_md == null) {
            this.sha256_md = MessageDigest.getInstance(SHA256_ALGORITHM);
        }
        return this.computeDigest(this.sha256_md, byArray);
    }

    public byte[] MD5(byte[] byArray) throws NoSuchAlgorithmException {
        if (this.md5_md == null) {
            this.md5_md = MessageDigest.getInstance(MD5_ALGORITHM);
        }
        return this.computeDigest(this.md5_md, byArray);
    }

    public byte[] SHA1(byte[] byArray) throws NoSuchAlgorithmException {
        if (this.sha1_md == null) {
            this.sha1_md = MessageDigest.getInstance(SHA1_ALGORITHM);
        }
        return this.computeDigest(this.sha1_md, byArray);
    }

    private MessageDigest getDigester(String string) throws NoSuchAlgorithmException {
        if (string.equals(MD5_ALGORITHM)) {
            if (this.md5_md == null) {
                this.md5_md = MessageDigest.getInstance(MD5_ALGORITHM);
            }
            return this.md5_md;
        }
        if (string.equals(SHA1_ALGORITHM)) {
            if (this.sha1_md == null) {
                this.sha1_md = MessageDigest.getInstance(SHA1_ALGORITHM);
            }
            return this.sha1_md;
        }
        if (string.equals(SHA256_ALGORITHM)) {
            if (this.sha256_md == null) {
                this.sha256_md = MessageDigest.getInstance(SHA256_ALGORITHM);
            }
            return this.sha256_md;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public byte[] computeDigest(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.getDigester(string);
        return this.computeDigest(messageDigest, byArray);
    }

    private static long mix64(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        return l ^ l >>> 33;
    }

    public static byte[] getRandomUUID() {
        byte[] byArray = new byte[16];
        UUID uUID = UUID.randomUUID();
        long l = uUID.getLeastSignificantBits();
        long l2 = uUID.getMostSignificantBits();
        byArray[7] = (byte)(l2 & 0xFFL);
        byArray[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[0] = (byte)(l2 >> 56 & 0xFFL);
        byArray[15] = (byte)(l & 0xFFL);
        byArray[14] = (byte)(l >> 8 & 0xFFL);
        byArray[13] = (byte)(l >> 16 & 0xFFL);
        byArray[12] = (byte)(l >> 24 & 0xFFL);
        byArray[11] = (byte)(l >> 32 & 0xFFL);
        byArray[10] = (byte)(l >> 40 & 0xFFL);
        byArray[9] = (byte)(l >> 48 & 0xFFL);
        byArray[8] = (byte)(l >> 56 & 0xFFL);
        return byArray;
    }

    private void initRandom(byte[] byArray) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        this.rand.setSeed(threadLocalRandom.nextLong());
        this.rand.setSeed(threadLocalRandom.nextLong());
        this.rand.setSeed(threadLocalRandom.nextLong());
        this.rand.setSeed(threadLocalRandom.nextLong());
        this.rand.setSeed(HashFuncs.mix64(System.currentTimeMillis()));
        this.rand.setSeed(HashFuncs.mix64(System.nanoTime()));
        if (byArray != null) {
            this.rand.setSeed(byArray);
        }
        long l = Thread.currentThread().getId();
        this.rand.setSeed(HashFuncs.mix64(l));
    }

    public HashFuncs(byte[] byArray) {
        try {
            this.initRandom(byArray);
        }
        catch (RuntimeException runtimeException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(runtimeException.toString());
            }
            throw runtimeException;
        }
    }

    public HashFuncs() {
        this(null);
    }

    public long getRandomLong() {
        return this.rand.nextLong();
    }

    public void fillRandomBytes(byte[] byArray) {
        this.rand.nextBytes(byArray);
    }

    public byte[] getRandom() {
        byte[] byArray = new byte[16];
        this.fillRandomBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return byArray;
    }

    public byte[] computeScramCredential(String string, String string2, int n, int n2, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        this.salt = new byte[n2];
        this.fillRandomBytes(this.salt);
        return this.computeScramCredential(string, string2, n, this.salt, byArray, byArray2);
    }

    public byte[] computeScramCredential(String string, String string2, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        MessageDigest messageDigest = this.getDigester(string2);
        this.num_iters = n;
        this.salted_hash = this.hi(string2, string, byArray, this.num_iters);
        this.client_key = this.hmac(string2, this.salted_hash, byArray2);
        this.server_key = this.hmac(string2, this.salted_hash, byArray3);
        this.stored_key = this.computeDigest(messageDigest, this.client_key);
        int n2 = 4 + byArray.length + this.stored_key.length + this.server_key.length;
        byte[] byArray4 = new byte[n2];
        n2 = 0;
        byArray4[n2++] = (byte)byArray.length;
        byArray4[n2++] = (byte)(this.num_iters >> 16 & 0xFF);
        byArray4[n2++] = (byte)(this.num_iters >> 8 & 0xFF);
        byArray4[n2++] = (byte)(this.num_iters & 0xFF);
        System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
        System.arraycopy(this.stored_key, 0, byArray4, n2 += byArray.length, this.stored_key.length);
        System.arraycopy(this.server_key, 0, byArray4, n2 += this.stored_key.length, this.server_key.length);
        return byArray4;
    }

    public void parseScramCredential(String string) {
        int n;
        byte[] byArray = ByteArray.decode64(string);
        int n2 = 0;
        if ((n = byArray[n2++] & 0xFF) == 0) {
            n = 16;
        }
        this.num_iters = 0;
        this.num_iters |= (byArray[n2++] & 0xFF) << 16;
        this.num_iters |= (byArray[n2++] & 0xFF) << 8;
        this.num_iters |= byArray[n2++] & 0xFF;
        n2 = (byArray.length - 4 - n) / 2;
        this.stored_key = new byte[n2];
        this.server_key = new byte[n2];
        n2 = 4;
        this.salt = new byte[n];
        System.arraycopy(byArray, n2, this.salt, 0, this.salt.length);
        System.arraycopy(byArray, n2 += this.salt.length, this.stored_key, 0, this.stored_key.length);
        System.arraycopy(byArray, n2 += this.stored_key.length, this.server_key, 0, this.server_key.length);
    }

    private byte[] hi(String string, String string2, byte[] byArray, int n) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory;
        PBEKeySpec pBEKeySpec;
        if (string.equals(SHA256_ALGORITHM)) {
            pBEKeySpec = new PBEKeySpec(string2.toCharArray(), byArray, n, 256);
            if (this.sha256_factory == null) {
                this.sha256_factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            }
            secretKeyFactory = this.sha256_factory;
        } else if (string.equals(SHA1_ALGORITHM)) {
            pBEKeySpec = new PBEKeySpec(string2.toCharArray(), byArray, n, 160);
            if (this.sha1_factory == null) {
                this.sha1_factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            secretKeyFactory = this.sha1_factory;
        } else {
            throw new NoSuchAlgorithmException(string);
        }
        return secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
    }

    public byte[] hmac(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac;
        SecretKeySpec secretKeySpec;
        if (string.equals(SHA256_ALGORITHM)) {
            secretKeySpec = new SecretKeySpec(byArray, "HmacSHA256");
            if (this.hmac256 == null) {
                this.hmac256 = Mac.getInstance("HmacSHA256");
            }
            mac = this.hmac256;
        } else if (string.equals(SHA1_ALGORITHM)) {
            secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
            if (this.hmac1 == null) {
                this.hmac1 = Mac.getInstance("HmacSHA1");
            }
            mac = this.hmac1;
        } else {
            throw new NoSuchAlgorithmException(string);
        }
        mac.init(secretKeySpec);
        return mac.doFinal(byArray2);
    }

    public byte[] computeScramCredential(String string, String string2, int n, int n2) throws GeneralSecurityException {
        return this.computeScramCredential(string, string2, n, n2, CLIENT_KEY, SERVER_KEY);
    }
}

