/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;

public class JsonpGeneratorWrapper
implements JsonGenerator {
    OracleJsonGenerator wrapped;

    public JsonpGeneratorWrapper(Object object) {
        this.wrapped = (OracleJsonGenerator)object;
    }

    public OracleJsonGenerator getWrapped() {
        return this.wrapped;
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }

    public void flush() {
        try {
            this.wrapped.flush();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }

    public JsonGenerator writeKey(String string) {
        try {
            this.wrapped.writeKey(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    private JsonException translate(OracleJsonException oracleJsonException) {
        if (oracleJsonException instanceof OracleJsonGenerationException) {
            return new JsonGenerationException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
        return new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
    }

    public JsonGenerator write(String string, JsonValue jsonValue) {
        try {
            this.wrapped.writeKey(string);
            this.write(jsonValue);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(JsonValue jsonValue) {
        if (jsonValue instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)jsonValue;
            try {
                if (wrapper.isWrapperFor(OracleJsonValue.class)) {
                    this.wrapped.write(wrapper.unwrap(OracleJsonValue.class));
                    return this;
                }
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException(sQLException);
            }
        }
        this.writeJsonValue(jsonValue);
        return this;
    }

    private void writeJsonValue(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                this.writeStartObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeJsonValue((JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                this.writeStartArray();
                for (JsonValue jsonValue2 : jsonArray) {
                    this.writeJsonValue(jsonValue2);
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                this.write(jsonString.getString());
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                this.writeOraNum(jsonNumber.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    public void writeJsonParser(Object object) {
        JsonParser jsonParser = (JsonParser)object;
        int n = 0;
        while (jsonParser.hasNext()) {
            switch (jsonParser.next()) {
                case END_ARRAY: {
                    this.writeEnd();
                    --n;
                    break;
                }
                case END_OBJECT: {
                    this.writeEnd();
                    --n;
                    break;
                }
                case KEY_NAME: {
                    this.writeKey(jsonParser.getString());
                    break;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    ++n;
                    break;
                }
                case START_OBJECT: {
                    this.writeStartObject();
                    ++n;
                    break;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    break;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    break;
                }
                case VALUE_NUMBER: {
                    this.writeOraNum(jsonParser.getBigDecimal());
                    break;
                }
                case VALUE_STRING: {
                    this.write(jsonParser.getString());
                    break;
                }
                case VALUE_TRUE: {
                    this.write(true);
                }
            }
            if (n > 0) continue;
            break;
        }
    }

    public JsonGenerator write(String string) {
        try {
            this.wrapped.write(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal bigDecimal) {
        try {
            this.wrapped.write(bigDecimal);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(BigInteger bigInteger) {
        this.wrapped.write(bigInteger);
        return this;
    }

    public JsonGenerator write(int n) {
        try {
            this.wrapped.write(n);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(long l) {
        try {
            this.wrapped.write(l);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(double d) {
        try {
            this.wrapped.write(d);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(boolean bl) {
        try {
            this.wrapped.write(bl);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, String string2) {
        try {
            this.wrapped.write(string, string2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, BigInteger bigInteger) {
        try {
            this.wrapped.write(string, bigInteger);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, BigDecimal bigDecimal) {
        try {
            this.wrapped.write(string, bigDecimal);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, int n) {
        try {
            this.wrapped.write(string, n);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, long l) {
        try {
            this.wrapped.write(string, l);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, double d) {
        try {
            this.wrapped.write(string, d);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, boolean bl) {
        try {
            this.wrapped.write(string, bl);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeEnd() {
        try {
            this.wrapped.writeEnd();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        try {
            this.wrapped.writeNull();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeNull(String string) {
        try {
            this.wrapped.writeNull(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        try {
            this.wrapped.writeStartArray();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartArray(String string) {
        try {
            this.wrapped.writeStartArray(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        try {
            this.wrapped.writeStartObject();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartObject(String string) {
        try {
            this.wrapped.writeStartObject(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    private void writeOraNum(BigDecimal bigDecimal) {
        try {
            this.wrapped.write((OracleJsonValue)new OracleJsonDecimalImpl(bigDecimal));
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }
}

