/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import oracle.json.util.ComponentTime;

public class ValueTypePair {
    private static JsonBuilderFactory FACTORY = Json.createBuilderFactory(null);
    JsonValue value;
    private boolean dateFlag = false;
    private boolean timestampFlag = false;

    ValueTypePair(JsonValue jsonValue) {
        this.value = jsonValue;
    }

    ValueTypePair(String string) {
        this((JsonValue)FACTORY.createArrayBuilder().add(string).build().get(0));
    }

    public ValueTypePair(BigDecimal bigDecimal) {
        this((JsonValue)FACTORY.createArrayBuilder().add(bigDecimal).build().get(0));
    }

    public JsonValue getValue() {
        return this.value;
    }

    void setValue(JsonValue jsonValue) {
        this.value = jsonValue;
    }

    public boolean isTimestamp() {
        return this.timestampFlag;
    }

    public boolean isDate() {
        return this.dateFlag;
    }

    public boolean isNumber() {
        return this.value.getValueType() == JsonValue.ValueType.NUMBER;
    }

    public boolean isBoolean() {
        return this.value.getValueType() == JsonValue.ValueType.TRUE || this.value.getValueType() == JsonValue.ValueType.FALSE;
    }

    public boolean isString() {
        return this.value.getValueType() == JsonValue.ValueType.STRING;
    }

    public boolean isObject() {
        return this.value.getValueType() == JsonValue.ValueType.OBJECT;
    }

    public boolean isArray() {
        return this.value.getValueType() == JsonValue.ValueType.ARRAY;
    }

    public BigDecimal getNumberValue() {
        return this.isNumber() ? ((JsonNumber)this.value).bigDecimalValue() : null;
    }

    public String getStringValue() {
        return this.isString() ? ((JsonString)this.value).getString() : null;
    }

    public boolean getBooleanValue() {
        return JsonValue.TRUE == this.value;
    }

    static ValueTypePair makeTemporal(ValueTypePair valueTypePair, boolean bl) {
        if (valueTypePair.isNumber()) {
            int n;
            BigDecimal bigDecimal = valueTypePair.getNumberValue();
            String string = ComponentTime.millisToString(bigDecimal.longValue());
            if (!bl && (n = string.indexOf(90)) > 0) {
                string = string.substring(0, n);
            }
            valueTypePair = new ValueTypePair(string);
        }
        if (bl) {
            valueTypePair.timestampFlag = true;
        } else {
            valueTypePair.dateFlag = true;
        }
        return valueTypePair;
    }
}

