/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.json.parser.AndORNode;
import oracle.json.parser.AndORTree;
import oracle.json.parser.Evaluator;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.ValueTypePair;

public class SqlJsonClause {
    private static final String INSTR_WRAPPER = "instr";
    private static final String REGEX_WRAPPER = "regexp_like";
    private final JsonQueryPath qPath;
    private final String comparator;
    private String compFunc = null;
    private String convFunc = null;
    private boolean isNumber = false;
    private boolean isString = false;
    private boolean isDate = false;
    private boolean isTimestamp = false;
    private boolean bindString = false;
    private boolean bindNumber = false;
    private boolean existsFlag = false;
    private boolean notFlag = false;
    private final ArrayList<ValueTypePair> binds = new ArrayList();

    SqlJsonClause(Evaluator.EvaluatorCode evaluatorCode, JsonQueryPath jsonQueryPath) {
        this(evaluatorCode, jsonQueryPath, false);
    }

    SqlJsonClause(Evaluator.EvaluatorCode evaluatorCode, JsonQueryPath jsonQueryPath, boolean bl) {
        this.qPath = jsonQueryPath;
        String string = null;
        this.isNumber = bl;
        this.bindNumber = bl;
        switch (evaluatorCode) {
            case $eq: {
                string = "=";
                break;
            }
            default: {
                this.isNumber = bl;
                this.bindNumber = bl;
                string = Evaluator.Operator.get((Object)evaluatorCode);
            }
        }
        this.comparator = string;
    }

    void setNot(boolean bl) throws QueryException {
        this.notFlag = bl;
    }

    void addModifier(Evaluator.EvaluatorCode evaluatorCode, String string) throws QueryException {
        if (evaluatorCode == null) {
            return;
        }
        switch (evaluatorCode) {
            case $double: 
            case $number: 
            case $ceiling: 
            case $floor: 
            case $abs: {
                this.isNumber = true;
                break;
            }
            case $date: {
                this.isDate = true;
                break;
            }
            case $timestamp: {
                this.isTimestamp = true;
                break;
            }
            case $length: {
                this.bindNumber = !this.bindString;
            }
            case $upper: 
            case $lower: 
            case $string: {
                this.isString = true;
                break;
            }
            default: {
                QueryException.throwSyntaxException(QueryMessage.EX_OPERATOR_NOT_ALLOWED, string);
            }
        }
        switch (evaluatorCode) {
            case $ceiling: {
                this.convFunc = "ceil";
                break;
            }
            case $floor: {
                this.convFunc = "floor";
                break;
            }
            case $abs: {
                this.convFunc = "abs";
                break;
            }
            case $length: {
                this.convFunc = "length";
                break;
            }
            case $upper: {
                this.convFunc = "upper";
                break;
            }
            case $lower: {
                this.convFunc = "lower";
                break;
            }
        }
    }

    void addBind(JsonValue jsonValue, String string) throws QueryException {
        ValueTypePair valueTypePair = AndORTree.createBindValue(jsonValue, string, this.compFunc == null);
        if (this.existsFlag) {
            if (AndORNode.isReversedExists(valueTypePair)) {
                this.notFlag = !this.notFlag;
            }
            return;
        }
        if (this.compFunc == REGEX_WRAPPER) {
            String string2 = null;
            String string3 = null;
            if (valueTypePair.isString()) {
                string3 = string2 = valueTypePair.getStringValue();
            } else if (valueTypePair.isNumber()) {
                string3 = valueTypePair.getNumberValue().toString();
            }
            if (string3 != null) {
                int n = string3.length();
                if (n > 0) {
                    if (string3.charAt(n - 1) != '$') {
                        string3 = string3 + '$';
                    }
                    if (string3.charAt(0) != '^') {
                        string3 = '^' + string3;
                    }
                }
                if (string3 != string2) {
                    valueTypePair = new ValueTypePair(string3);
                }
            }
        } else if (this.isNumber || this.bindNumber) {
            if (valueTypePair.isString()) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(valueTypePair.getStringValue());
                    valueTypePair = new ValueTypePair(bigDecimal);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new QueryException(numberFormatException);
                }
            }
        } else if (this.isDate) {
            valueTypePair = ValueTypePair.makeTemporal(valueTypePair, false);
        } else if (this.isTimestamp) {
            valueTypePair = ValueTypePair.makeTemporal(valueTypePair, true);
        } else if ((this.bindString || this.isString) && valueTypePair.isNumber()) {
            String string4 = valueTypePair.getNumberValue().toString();
            valueTypePair = new ValueTypePair(string4);
        }
        this.binds.add(valueTypePair);
    }

    void addBindArray(JsonArray jsonArray, String string) throws QueryException {
        for (JsonValue jsonValue : jsonArray) {
            this.addBind(jsonValue, string);
        }
    }

    public JsonQueryPath getPath() {
        return this.qPath;
    }

    public int getArgCount() {
        return this.compFunc == null ? 0 : 1;
    }

    public int getBindCount() {
        if (this.compFunc != null) {
            return 0;
        }
        return this.binds.size();
    }

    public ValueTypePair getValue(int n) {
        return this.binds.get(n);
    }

    public String getComparator() {
        if (this.comparator != null && this.comparator.equals("in") && this.binds.size() <= 1) {
            return "=";
        }
        return this.comparator;
    }

    public boolean isNot() {
        return this.notFlag;
    }

    public String getReturningType() {
        if (this.isNumber) {
            return "number";
        }
        if (this.isDate) {
            return "date";
        }
        if (this.isTimestamp) {
            return "timestamp";
        }
        return null;
    }

    public boolean isExists() {
        return this.existsFlag;
    }

    public String getConversionFunction() {
        return this.convFunc;
    }

    public String getCompareFunction() {
        return this.compFunc;
    }

    boolean useNumberBinding() {
        return this.bindNumber || this.isNumber;
    }

    boolean useStringBinding() {
        return this.bindString;
    }

    boolean useDateWrapper() {
        return !this.bindString && this.isDate;
    }

    boolean useTimestampWrapper() {
        return !this.bindString && this.isTimestamp;
    }
}

