/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class SpatialClause {
    static final String GEOMETRY_FIELD_NAME = "$geometry";
    static final String DISTANCE_FIELD_NAME = "$distance";
    static final String EXCLUDE_FIELD_NAME = "$excludeDistance";
    static final String UNIT_FIELD_NAME = "$unit";
    static final String SCALAR_REQ = "$scalarRequired";
    static final String LAX = "$lax";
    static final String NEAR = "$near";
    static final String SPATIAL_DEFAULT_UNIT = "mile";
    static final String SPATIAL_DEFAULT_TOLERANCE = "0.05";
    private final JsonQueryPath spatialPath;
    private final String spatialOperator;
    private final String spatialReference;
    private final String spatialDistance;
    private final boolean notFlag;
    private final String errorClause;

    SpatialClause(String string, boolean bl, JsonQueryPath jsonQueryPath, String string2, String string3, String string4) {
        this.spatialOperator = string;
        this.spatialPath = jsonQueryPath;
        this.spatialReference = string2;
        this.spatialDistance = string3;
        this.notFlag = bl;
        this.errorClause = string4;
    }

    public JsonQueryPath getPath() {
        return this.spatialPath;
    }

    public String getOperator() {
        return this.spatialOperator;
    }

    public String getReference() {
        return this.spatialReference;
    }

    public String getDistance() {
        return this.spatialDistance;
    }

    public String getErrorClause() {
        return this.errorClause;
    }

    public boolean isNot() {
        return this.notFlag;
    }

    static String buildDistance(String string, String string2, String string3) throws QueryException {
        if (string == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
        if (string3 == null) {
            string3 = SPATIAL_DEFAULT_UNIT;
        }
        if (string2 != null) {
            return "distance=" + string + " unit=" + string3 + " exclude_distance=" + string2;
        }
        return "distance=" + string + " unit=" + string3;
    }

    static String buildDistance(String string, String string2) throws QueryException {
        return SpatialClause.buildDistance(string, null, string2);
    }

    static String sdoOperatorFor(String string) throws QueryException {
        if (string.equals(NEAR)) {
            return "SDO_WITHIN_DISTANCE";
        }
        if (string.equals("$within")) {
            return "SDO_INSIDE";
        }
        if (string.equals("$intersects")) {
            return "SDO_ANYINTERACT";
        }
        QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        return null;
    }
}

