/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteVcnRequest
extends BmcRequest<Void> {
    private String vcnId;
    private String ifMatch;

    public String getVcnId() {
        return this.vcnId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().vcnId(this.vcnId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vcnId=").append(String.valueOf(this.vcnId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteVcnRequest)) {
            return false;
        }
        DeleteVcnRequest other = (DeleteVcnRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteVcnRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vcnId = null;
        private String ifMatch = null;

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteVcnRequest o) {
            this.vcnId(o.getVcnId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteVcnRequest build() {
            DeleteVcnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteVcnRequest buildWithoutInvocationCallback() {
            DeleteVcnRequest request = new DeleteVcnRequest();
            request.vcnId = this.vcnId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

