/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.CopyVolumeBackupDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CopyVolumeBackupRequest
extends BmcRequest<CopyVolumeBackupDetails> {
    private String volumeBackupId;
    private CopyVolumeBackupDetails copyVolumeBackupDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getVolumeBackupId() {
        return this.volumeBackupId;
    }

    public CopyVolumeBackupDetails getCopyVolumeBackupDetails() {
        return this.copyVolumeBackupDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CopyVolumeBackupDetails getBody$() {
        return this.copyVolumeBackupDetails;
    }

    public Builder toBuilder() {
        return new Builder().volumeBackupId(this.volumeBackupId).copyVolumeBackupDetails(this.copyVolumeBackupDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeBackupId=").append(String.valueOf(this.volumeBackupId));
        sb.append(",copyVolumeBackupDetails=").append(String.valueOf((Object)this.copyVolumeBackupDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyVolumeBackupRequest)) {
            return false;
        }
        CopyVolumeBackupRequest other = (CopyVolumeBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeBackupId, other.volumeBackupId) && Objects.equals((Object)this.copyVolumeBackupDetails, (Object)other.copyVolumeBackupDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeBackupId == null ? 43 : this.volumeBackupId.hashCode());
        result = result * 59 + (this.copyVolumeBackupDetails == null ? 43 : this.copyVolumeBackupDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CopyVolumeBackupRequest, CopyVolumeBackupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeBackupId = null;
        private CopyVolumeBackupDetails copyVolumeBackupDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder volumeBackupId(String volumeBackupId) {
            this.volumeBackupId = volumeBackupId;
            return this;
        }

        public Builder copyVolumeBackupDetails(CopyVolumeBackupDetails copyVolumeBackupDetails) {
            this.copyVolumeBackupDetails = copyVolumeBackupDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CopyVolumeBackupRequest o) {
            this.volumeBackupId(o.getVolumeBackupId());
            this.copyVolumeBackupDetails(o.getCopyVolumeBackupDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CopyVolumeBackupRequest build() {
            CopyVolumeBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CopyVolumeBackupDetails body) {
            this.copyVolumeBackupDetails(body);
            return this;
        }

        public CopyVolumeBackupRequest buildWithoutInvocationCallback() {
            CopyVolumeBackupRequest request = new CopyVolumeBackupRequest();
            request.volumeBackupId = this.volumeBackupId;
            request.copyVolumeBackupDetails = this.copyVolumeBackupDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

