/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceMaintenanceAlternativeResolutionActions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceMaintenanceEvent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="maintenanceCategory")
    private final MaintenanceCategory maintenanceCategory;
    @JsonProperty(value="maintenanceReason")
    private final MaintenanceReason maintenanceReason;
    @JsonProperty(value="instanceAction")
    private final InstanceAction instanceAction;
    @JsonProperty(value="alternativeResolutionActions")
    private final List<InstanceMaintenanceAlternativeResolutionActions> alternativeResolutionActions;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="timeWindowStart")
    private final Date timeWindowStart;
    @JsonProperty(value="startWindowDuration")
    private final String startWindowDuration;
    @JsonProperty(value="estimatedDuration")
    private final String estimatedDuration;
    @JsonProperty(value="timeHardDueDate")
    private final Date timeHardDueDate;
    @JsonProperty(value="canReschedule")
    private final Boolean canReschedule;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="createdBy")
    private final CreatedBy createdBy;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="correlationToken")
    private final String correlationToken;
    @JsonProperty(value="canDeleteLocalStorage")
    private final Boolean canDeleteLocalStorage;
    @JsonProperty(value="additionalDetails")
    private final Map<String, String> additionalDetails;

    @Deprecated
    @ConstructorProperties(value={"displayName", "definedTags", "freeformTags", "id", "instanceId", "compartmentId", "maintenanceCategory", "maintenanceReason", "instanceAction", "alternativeResolutionActions", "timeStarted", "timeFinished", "timeWindowStart", "startWindowDuration", "estimatedDuration", "timeHardDueDate", "canReschedule", "timeCreated", "lifecycleState", "lifecycleDetails", "createdBy", "description", "correlationToken", "canDeleteLocalStorage", "additionalDetails"})
    public InstanceMaintenanceEvent(String displayName, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, String id, String instanceId, String compartmentId, MaintenanceCategory maintenanceCategory, MaintenanceReason maintenanceReason, InstanceAction instanceAction, List<InstanceMaintenanceAlternativeResolutionActions> alternativeResolutionActions, Date timeStarted, Date timeFinished, Date timeWindowStart, String startWindowDuration, String estimatedDuration, Date timeHardDueDate, Boolean canReschedule, Date timeCreated, LifecycleState lifecycleState, String lifecycleDetails, CreatedBy createdBy, String description, String correlationToken, Boolean canDeleteLocalStorage, Map<String, String> additionalDetails) {
        this.displayName = displayName;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.id = id;
        this.instanceId = instanceId;
        this.compartmentId = compartmentId;
        this.maintenanceCategory = maintenanceCategory;
        this.maintenanceReason = maintenanceReason;
        this.instanceAction = instanceAction;
        this.alternativeResolutionActions = alternativeResolutionActions;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.timeWindowStart = timeWindowStart;
        this.startWindowDuration = startWindowDuration;
        this.estimatedDuration = estimatedDuration;
        this.timeHardDueDate = timeHardDueDate;
        this.canReschedule = canReschedule;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.createdBy = createdBy;
        this.description = description;
        this.correlationToken = correlationToken;
        this.canDeleteLocalStorage = canDeleteLocalStorage;
        this.additionalDetails = additionalDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public MaintenanceCategory getMaintenanceCategory() {
        return this.maintenanceCategory;
    }

    public MaintenanceReason getMaintenanceReason() {
        return this.maintenanceReason;
    }

    public InstanceAction getInstanceAction() {
        return this.instanceAction;
    }

    public List<InstanceMaintenanceAlternativeResolutionActions> getAlternativeResolutionActions() {
        return this.alternativeResolutionActions;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Date getTimeWindowStart() {
        return this.timeWindowStart;
    }

    public String getStartWindowDuration() {
        return this.startWindowDuration;
    }

    public String getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public Date getTimeHardDueDate() {
        return this.timeHardDueDate;
    }

    public Boolean getCanReschedule() {
        return this.canReschedule;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCorrelationToken() {
        return this.correlationToken;
    }

    public Boolean getCanDeleteLocalStorage() {
        return this.canDeleteLocalStorage;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceMaintenanceEvent(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", maintenanceCategory=").append(String.valueOf((Object)this.maintenanceCategory));
        sb.append(", maintenanceReason=").append(String.valueOf((Object)this.maintenanceReason));
        sb.append(", instanceAction=").append(String.valueOf((Object)this.instanceAction));
        sb.append(", alternativeResolutionActions=").append(String.valueOf(this.alternativeResolutionActions));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", timeWindowStart=").append(String.valueOf(this.timeWindowStart));
        sb.append(", startWindowDuration=").append(String.valueOf(this.startWindowDuration));
        sb.append(", estimatedDuration=").append(String.valueOf(this.estimatedDuration));
        sb.append(", timeHardDueDate=").append(String.valueOf(this.timeHardDueDate));
        sb.append(", canReschedule=").append(String.valueOf(this.canReschedule));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", createdBy=").append(String.valueOf((Object)this.createdBy));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", correlationToken=").append(String.valueOf(this.correlationToken));
        sb.append(", canDeleteLocalStorage=").append(String.valueOf(this.canDeleteLocalStorage));
        sb.append(", additionalDetails=").append(String.valueOf(this.additionalDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceMaintenanceEvent)) {
            return false;
        }
        InstanceMaintenanceEvent other = (InstanceMaintenanceEvent)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.maintenanceCategory, (Object)other.maintenanceCategory) && Objects.equals((Object)this.maintenanceReason, (Object)other.maintenanceReason) && Objects.equals((Object)this.instanceAction, (Object)other.instanceAction) && Objects.equals(this.alternativeResolutionActions, other.alternativeResolutionActions) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.timeWindowStart, other.timeWindowStart) && Objects.equals(this.startWindowDuration, other.startWindowDuration) && Objects.equals(this.estimatedDuration, other.estimatedDuration) && Objects.equals(this.timeHardDueDate, other.timeHardDueDate) && Objects.equals(this.canReschedule, other.canReschedule) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.createdBy, (Object)other.createdBy) && Objects.equals(this.description, other.description) && Objects.equals(this.correlationToken, other.correlationToken) && Objects.equals(this.canDeleteLocalStorage, other.canDeleteLocalStorage) && Objects.equals(this.additionalDetails, other.additionalDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.maintenanceCategory == null ? 43 : this.maintenanceCategory.hashCode());
        result = result * 59 + (this.maintenanceReason == null ? 43 : this.maintenanceReason.hashCode());
        result = result * 59 + (this.instanceAction == null ? 43 : this.instanceAction.hashCode());
        result = result * 59 + (this.alternativeResolutionActions == null ? 43 : this.alternativeResolutionActions.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.timeWindowStart == null ? 43 : this.timeWindowStart.hashCode());
        result = result * 59 + (this.startWindowDuration == null ? 43 : this.startWindowDuration.hashCode());
        result = result * 59 + (this.estimatedDuration == null ? 43 : this.estimatedDuration.hashCode());
        result = result * 59 + (this.timeHardDueDate == null ? 43 : this.timeHardDueDate.hashCode());
        result = result * 59 + (this.canReschedule == null ? 43 : this.canReschedule.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.correlationToken == null ? 43 : this.correlationToken.hashCode());
        result = result * 59 + (this.canDeleteLocalStorage == null ? 43 : this.canDeleteLocalStorage.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MaintenanceCategory implements BmcEnum
    {
        Emergency("EMERGENCY"),
        Mandatory("MANDATORY"),
        Flexible("FLEXIBLE"),
        Optional("OPTIONAL"),
        Notification("NOTIFICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceCategory> map;

        private MaintenanceCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceCategory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceCategory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceCategory.class);
            map = new HashMap<String, MaintenanceCategory>();
            for (MaintenanceCategory v : MaintenanceCategory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MaintenanceReason implements BmcEnum
    {
        Evacuation("EVACUATION"),
        EnvironmentalFactors("ENVIRONMENTAL_FACTORS"),
        Decommission("DECOMMISSION"),
        HardwareReplacement("HARDWARE_REPLACEMENT"),
        FirmwareUpdate("FIRMWARE_UPDATE"),
        SecurityUpdate("SECURITY_UPDATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceReason> map;

        private MaintenanceReason(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceReason create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceReason', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceReason.class);
            map = new HashMap<String, MaintenanceReason>();
            for (MaintenanceReason v : MaintenanceReason.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InstanceAction implements BmcEnum
    {
        RebootMigration("REBOOT_MIGRATION"),
        Terminate("TERMINATE"),
        Stop("STOP"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InstanceAction> map;

        private InstanceAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InstanceAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InstanceAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InstanceAction.class);
            map = new HashMap<String, InstanceAction>();
            for (InstanceAction v : InstanceAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Scheduled("SCHEDULED"),
        Started("STARTED"),
        Processing("PROCESSING"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum CreatedBy implements BmcEnum
    {
        Customer("CUSTOMER"),
        System("SYSTEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CreatedBy> map;

        private CreatedBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CreatedBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CreatedBy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CreatedBy.class);
            map = new HashMap<String, CreatedBy>();
            for (CreatedBy v : CreatedBy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="maintenanceCategory")
        private MaintenanceCategory maintenanceCategory;
        @JsonProperty(value="maintenanceReason")
        private MaintenanceReason maintenanceReason;
        @JsonProperty(value="instanceAction")
        private InstanceAction instanceAction;
        @JsonProperty(value="alternativeResolutionActions")
        private List<InstanceMaintenanceAlternativeResolutionActions> alternativeResolutionActions;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="timeWindowStart")
        private Date timeWindowStart;
        @JsonProperty(value="startWindowDuration")
        private String startWindowDuration;
        @JsonProperty(value="estimatedDuration")
        private String estimatedDuration;
        @JsonProperty(value="timeHardDueDate")
        private Date timeHardDueDate;
        @JsonProperty(value="canReschedule")
        private Boolean canReschedule;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="createdBy")
        private CreatedBy createdBy;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="correlationToken")
        private String correlationToken;
        @JsonProperty(value="canDeleteLocalStorage")
        private Boolean canDeleteLocalStorage;
        @JsonProperty(value="additionalDetails")
        private Map<String, String> additionalDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder maintenanceCategory(MaintenanceCategory maintenanceCategory) {
            this.maintenanceCategory = maintenanceCategory;
            this.__explicitlySet__.add("maintenanceCategory");
            return this;
        }

        public Builder maintenanceReason(MaintenanceReason maintenanceReason) {
            this.maintenanceReason = maintenanceReason;
            this.__explicitlySet__.add("maintenanceReason");
            return this;
        }

        public Builder instanceAction(InstanceAction instanceAction) {
            this.instanceAction = instanceAction;
            this.__explicitlySet__.add("instanceAction");
            return this;
        }

        public Builder alternativeResolutionActions(List<InstanceMaintenanceAlternativeResolutionActions> alternativeResolutionActions) {
            this.alternativeResolutionActions = alternativeResolutionActions;
            this.__explicitlySet__.add("alternativeResolutionActions");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder timeWindowStart(Date timeWindowStart) {
            this.timeWindowStart = timeWindowStart;
            this.__explicitlySet__.add("timeWindowStart");
            return this;
        }

        public Builder startWindowDuration(String startWindowDuration) {
            this.startWindowDuration = startWindowDuration;
            this.__explicitlySet__.add("startWindowDuration");
            return this;
        }

        public Builder estimatedDuration(String estimatedDuration) {
            this.estimatedDuration = estimatedDuration;
            this.__explicitlySet__.add("estimatedDuration");
            return this;
        }

        public Builder timeHardDueDate(Date timeHardDueDate) {
            this.timeHardDueDate = timeHardDueDate;
            this.__explicitlySet__.add("timeHardDueDate");
            return this;
        }

        public Builder canReschedule(Boolean canReschedule) {
            this.canReschedule = canReschedule;
            this.__explicitlySet__.add("canReschedule");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder createdBy(CreatedBy createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder correlationToken(String correlationToken) {
            this.correlationToken = correlationToken;
            this.__explicitlySet__.add("correlationToken");
            return this;
        }

        public Builder canDeleteLocalStorage(Boolean canDeleteLocalStorage) {
            this.canDeleteLocalStorage = canDeleteLocalStorage;
            this.__explicitlySet__.add("canDeleteLocalStorage");
            return this;
        }

        public Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public InstanceMaintenanceEvent build() {
            InstanceMaintenanceEvent model = new InstanceMaintenanceEvent(this.displayName, this.definedTags, this.freeformTags, this.id, this.instanceId, this.compartmentId, this.maintenanceCategory, this.maintenanceReason, this.instanceAction, this.alternativeResolutionActions, this.timeStarted, this.timeFinished, this.timeWindowStart, this.startWindowDuration, this.estimatedDuration, this.timeHardDueDate, this.canReschedule, this.timeCreated, this.lifecycleState, this.lifecycleDetails, this.createdBy, this.description, this.correlationToken, this.canDeleteLocalStorage, this.additionalDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceMaintenanceEvent model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("maintenanceCategory")) {
                this.maintenanceCategory(model.getMaintenanceCategory());
            }
            if (model.wasPropertyExplicitlySet("maintenanceReason")) {
                this.maintenanceReason(model.getMaintenanceReason());
            }
            if (model.wasPropertyExplicitlySet("instanceAction")) {
                this.instanceAction(model.getInstanceAction());
            }
            if (model.wasPropertyExplicitlySet("alternativeResolutionActions")) {
                this.alternativeResolutionActions(model.getAlternativeResolutionActions());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("timeWindowStart")) {
                this.timeWindowStart(model.getTimeWindowStart());
            }
            if (model.wasPropertyExplicitlySet("startWindowDuration")) {
                this.startWindowDuration(model.getStartWindowDuration());
            }
            if (model.wasPropertyExplicitlySet("estimatedDuration")) {
                this.estimatedDuration(model.getEstimatedDuration());
            }
            if (model.wasPropertyExplicitlySet("timeHardDueDate")) {
                this.timeHardDueDate(model.getTimeHardDueDate());
            }
            if (model.wasPropertyExplicitlySet("canReschedule")) {
                this.canReschedule(model.getCanReschedule());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("correlationToken")) {
                this.correlationToken(model.getCorrelationToken());
            }
            if (model.wasPropertyExplicitlySet("canDeleteLocalStorage")) {
                this.canDeleteLocalStorage(model.getCanDeleteLocalStorage());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            return this;
        }
    }
}

