/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.BgpSessionInfo;
import com.oracle.bmc.core.model.EncryptionDomainConfig;
import com.oracle.bmc.core.model.TunnelPhaseOneDetails;
import com.oracle.bmc.core.model.TunnelPhaseTwoDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IPSecConnectionTunnel
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="vpnIp")
    private final String vpnIp;
    @JsonProperty(value="cpeIp")
    private final String cpeIp;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="ikeVersion")
    private final IkeVersion ikeVersion;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="bgpSessionInfo")
    private final BgpSessionInfo bgpSessionInfo;
    @JsonProperty(value="encryptionDomainConfig")
    private final EncryptionDomainConfig encryptionDomainConfig;
    @JsonProperty(value="routing")
    private final Routing routing;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeStatusUpdated")
    private final Date timeStatusUpdated;
    @JsonProperty(value="oracleCanInitiate")
    private final OracleCanInitiate oracleCanInitiate;
    @JsonProperty(value="natTranslationEnabled")
    private final NatTranslationEnabled natTranslationEnabled;
    @JsonProperty(value="dpdMode")
    private final DpdMode dpdMode;
    @JsonProperty(value="dpdTimeoutInSec")
    private final Integer dpdTimeoutInSec;
    @JsonProperty(value="phaseOneDetails")
    private final TunnelPhaseOneDetails phaseOneDetails;
    @JsonProperty(value="phaseTwoDetails")
    private final TunnelPhaseTwoDetails phaseTwoDetails;
    @JsonProperty(value="associatedVirtualCircuits")
    private final List<String> associatedVirtualCircuits;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "id", "vpnIp", "cpeIp", "status", "ikeVersion", "lifecycleState", "displayName", "bgpSessionInfo", "encryptionDomainConfig", "routing", "timeCreated", "timeStatusUpdated", "oracleCanInitiate", "natTranslationEnabled", "dpdMode", "dpdTimeoutInSec", "phaseOneDetails", "phaseTwoDetails", "associatedVirtualCircuits"})
    public IPSecConnectionTunnel(String compartmentId, String id, String vpnIp, String cpeIp, Status status, IkeVersion ikeVersion, LifecycleState lifecycleState, String displayName, BgpSessionInfo bgpSessionInfo, EncryptionDomainConfig encryptionDomainConfig, Routing routing, Date timeCreated, Date timeStatusUpdated, OracleCanInitiate oracleCanInitiate, NatTranslationEnabled natTranslationEnabled, DpdMode dpdMode, Integer dpdTimeoutInSec, TunnelPhaseOneDetails phaseOneDetails, TunnelPhaseTwoDetails phaseTwoDetails, List<String> associatedVirtualCircuits) {
        this.compartmentId = compartmentId;
        this.id = id;
        this.vpnIp = vpnIp;
        this.cpeIp = cpeIp;
        this.status = status;
        this.ikeVersion = ikeVersion;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.bgpSessionInfo = bgpSessionInfo;
        this.encryptionDomainConfig = encryptionDomainConfig;
        this.routing = routing;
        this.timeCreated = timeCreated;
        this.timeStatusUpdated = timeStatusUpdated;
        this.oracleCanInitiate = oracleCanInitiate;
        this.natTranslationEnabled = natTranslationEnabled;
        this.dpdMode = dpdMode;
        this.dpdTimeoutInSec = dpdTimeoutInSec;
        this.phaseOneDetails = phaseOneDetails;
        this.phaseTwoDetails = phaseTwoDetails;
        this.associatedVirtualCircuits = associatedVirtualCircuits;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getVpnIp() {
        return this.vpnIp;
    }

    public String getCpeIp() {
        return this.cpeIp;
    }

    public Status getStatus() {
        return this.status;
    }

    public IkeVersion getIkeVersion() {
        return this.ikeVersion;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BgpSessionInfo getBgpSessionInfo() {
        return this.bgpSessionInfo;
    }

    public EncryptionDomainConfig getEncryptionDomainConfig() {
        return this.encryptionDomainConfig;
    }

    public Routing getRouting() {
        return this.routing;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeStatusUpdated() {
        return this.timeStatusUpdated;
    }

    public OracleCanInitiate getOracleCanInitiate() {
        return this.oracleCanInitiate;
    }

    public NatTranslationEnabled getNatTranslationEnabled() {
        return this.natTranslationEnabled;
    }

    public DpdMode getDpdMode() {
        return this.dpdMode;
    }

    public Integer getDpdTimeoutInSec() {
        return this.dpdTimeoutInSec;
    }

    public TunnelPhaseOneDetails getPhaseOneDetails() {
        return this.phaseOneDetails;
    }

    public TunnelPhaseTwoDetails getPhaseTwoDetails() {
        return this.phaseTwoDetails;
    }

    public List<String> getAssociatedVirtualCircuits() {
        return this.associatedVirtualCircuits;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IPSecConnectionTunnel(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", vpnIp=").append(String.valueOf(this.vpnIp));
        sb.append(", cpeIp=").append(String.valueOf(this.cpeIp));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", ikeVersion=").append(String.valueOf((Object)this.ikeVersion));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", bgpSessionInfo=").append(String.valueOf((Object)this.bgpSessionInfo));
        sb.append(", encryptionDomainConfig=").append(String.valueOf((Object)this.encryptionDomainConfig));
        sb.append(", routing=").append(String.valueOf((Object)this.routing));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeStatusUpdated=").append(String.valueOf(this.timeStatusUpdated));
        sb.append(", oracleCanInitiate=").append(String.valueOf((Object)this.oracleCanInitiate));
        sb.append(", natTranslationEnabled=").append(String.valueOf((Object)this.natTranslationEnabled));
        sb.append(", dpdMode=").append(String.valueOf((Object)this.dpdMode));
        sb.append(", dpdTimeoutInSec=").append(String.valueOf(this.dpdTimeoutInSec));
        sb.append(", phaseOneDetails=").append(String.valueOf((Object)this.phaseOneDetails));
        sb.append(", phaseTwoDetails=").append(String.valueOf((Object)this.phaseTwoDetails));
        sb.append(", associatedVirtualCircuits=").append(String.valueOf(this.associatedVirtualCircuits));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPSecConnectionTunnel)) {
            return false;
        }
        IPSecConnectionTunnel other = (IPSecConnectionTunnel)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.vpnIp, other.vpnIp) && Objects.equals(this.cpeIp, other.cpeIp) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.ikeVersion, (Object)other.ikeVersion) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.bgpSessionInfo, (Object)other.bgpSessionInfo) && Objects.equals((Object)this.encryptionDomainConfig, (Object)other.encryptionDomainConfig) && Objects.equals((Object)this.routing, (Object)other.routing) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeStatusUpdated, other.timeStatusUpdated) && Objects.equals((Object)this.oracleCanInitiate, (Object)other.oracleCanInitiate) && Objects.equals((Object)this.natTranslationEnabled, (Object)other.natTranslationEnabled) && Objects.equals((Object)this.dpdMode, (Object)other.dpdMode) && Objects.equals(this.dpdTimeoutInSec, other.dpdTimeoutInSec) && Objects.equals((Object)this.phaseOneDetails, (Object)other.phaseOneDetails) && Objects.equals((Object)this.phaseTwoDetails, (Object)other.phaseTwoDetails) && Objects.equals(this.associatedVirtualCircuits, other.associatedVirtualCircuits) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.vpnIp == null ? 43 : this.vpnIp.hashCode());
        result = result * 59 + (this.cpeIp == null ? 43 : this.cpeIp.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.ikeVersion == null ? 43 : this.ikeVersion.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.bgpSessionInfo == null ? 43 : this.bgpSessionInfo.hashCode());
        result = result * 59 + (this.encryptionDomainConfig == null ? 43 : this.encryptionDomainConfig.hashCode());
        result = result * 59 + (this.routing == null ? 43 : this.routing.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeStatusUpdated == null ? 43 : this.timeStatusUpdated.hashCode());
        result = result * 59 + (this.oracleCanInitiate == null ? 43 : this.oracleCanInitiate.hashCode());
        result = result * 59 + (this.natTranslationEnabled == null ? 43 : this.natTranslationEnabled.hashCode());
        result = result * 59 + (this.dpdMode == null ? 43 : this.dpdMode.hashCode());
        result = result * 59 + (this.dpdTimeoutInSec == null ? 43 : this.dpdTimeoutInSec.hashCode());
        result = result * 59 + (this.phaseOneDetails == null ? 43 : this.phaseOneDetails.hashCode());
        result = result * 59 + (this.phaseTwoDetails == null ? 43 : this.phaseTwoDetails.hashCode());
        result = result * 59 + (this.associatedVirtualCircuits == null ? 43 : this.associatedVirtualCircuits.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        DownForMaintenance("DOWN_FOR_MAINTENANCE"),
        PartialUp("PARTIAL_UP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IkeVersion implements BmcEnum
    {
        V1("V1"),
        V2("V2"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IkeVersion> map;

        private IkeVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IkeVersion create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IkeVersion', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IkeVersion.class);
            map = new HashMap<String, IkeVersion>();
            for (IkeVersion v : IkeVersion.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Routing implements BmcEnum
    {
        Bgp("BGP"),
        Static("STATIC"),
        Policy("POLICY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Routing> map;

        private Routing(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Routing create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Routing', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Routing.class);
            map = new HashMap<String, Routing>();
            for (Routing v : Routing.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OracleCanInitiate implements BmcEnum
    {
        InitiatorOrResponder("INITIATOR_OR_RESPONDER"),
        ResponderOnly("RESPONDER_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OracleCanInitiate> map;

        private OracleCanInitiate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OracleCanInitiate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OracleCanInitiate', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OracleCanInitiate.class);
            map = new HashMap<String, OracleCanInitiate>();
            for (OracleCanInitiate v : OracleCanInitiate.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum NatTranslationEnabled implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        Auto("AUTO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NatTranslationEnabled> map;

        private NatTranslationEnabled(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NatTranslationEnabled create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NatTranslationEnabled', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NatTranslationEnabled.class);
            map = new HashMap<String, NatTranslationEnabled>();
            for (NatTranslationEnabled v : NatTranslationEnabled.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DpdMode implements BmcEnum
    {
        InitiateAndRespond("INITIATE_AND_RESPOND"),
        RespondOnly("RESPOND_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DpdMode> map;

        private DpdMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DpdMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DpdMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DpdMode.class);
            map = new HashMap<String, DpdMode>();
            for (DpdMode v : DpdMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="vpnIp")
        private String vpnIp;
        @JsonProperty(value="cpeIp")
        private String cpeIp;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="ikeVersion")
        private IkeVersion ikeVersion;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="bgpSessionInfo")
        private BgpSessionInfo bgpSessionInfo;
        @JsonProperty(value="encryptionDomainConfig")
        private EncryptionDomainConfig encryptionDomainConfig;
        @JsonProperty(value="routing")
        private Routing routing;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeStatusUpdated")
        private Date timeStatusUpdated;
        @JsonProperty(value="oracleCanInitiate")
        private OracleCanInitiate oracleCanInitiate;
        @JsonProperty(value="natTranslationEnabled")
        private NatTranslationEnabled natTranslationEnabled;
        @JsonProperty(value="dpdMode")
        private DpdMode dpdMode;
        @JsonProperty(value="dpdTimeoutInSec")
        private Integer dpdTimeoutInSec;
        @JsonProperty(value="phaseOneDetails")
        private TunnelPhaseOneDetails phaseOneDetails;
        @JsonProperty(value="phaseTwoDetails")
        private TunnelPhaseTwoDetails phaseTwoDetails;
        @JsonProperty(value="associatedVirtualCircuits")
        private List<String> associatedVirtualCircuits;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder vpnIp(String vpnIp) {
            this.vpnIp = vpnIp;
            this.__explicitlySet__.add("vpnIp");
            return this;
        }

        public Builder cpeIp(String cpeIp) {
            this.cpeIp = cpeIp;
            this.__explicitlySet__.add("cpeIp");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder ikeVersion(IkeVersion ikeVersion) {
            this.ikeVersion = ikeVersion;
            this.__explicitlySet__.add("ikeVersion");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder bgpSessionInfo(BgpSessionInfo bgpSessionInfo) {
            this.bgpSessionInfo = bgpSessionInfo;
            this.__explicitlySet__.add("bgpSessionInfo");
            return this;
        }

        public Builder encryptionDomainConfig(EncryptionDomainConfig encryptionDomainConfig) {
            this.encryptionDomainConfig = encryptionDomainConfig;
            this.__explicitlySet__.add("encryptionDomainConfig");
            return this;
        }

        public Builder routing(Routing routing) {
            this.routing = routing;
            this.__explicitlySet__.add("routing");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeStatusUpdated(Date timeStatusUpdated) {
            this.timeStatusUpdated = timeStatusUpdated;
            this.__explicitlySet__.add("timeStatusUpdated");
            return this;
        }

        public Builder oracleCanInitiate(OracleCanInitiate oracleCanInitiate) {
            this.oracleCanInitiate = oracleCanInitiate;
            this.__explicitlySet__.add("oracleCanInitiate");
            return this;
        }

        public Builder natTranslationEnabled(NatTranslationEnabled natTranslationEnabled) {
            this.natTranslationEnabled = natTranslationEnabled;
            this.__explicitlySet__.add("natTranslationEnabled");
            return this;
        }

        public Builder dpdMode(DpdMode dpdMode) {
            this.dpdMode = dpdMode;
            this.__explicitlySet__.add("dpdMode");
            return this;
        }

        public Builder dpdTimeoutInSec(Integer dpdTimeoutInSec) {
            this.dpdTimeoutInSec = dpdTimeoutInSec;
            this.__explicitlySet__.add("dpdTimeoutInSec");
            return this;
        }

        public Builder phaseOneDetails(TunnelPhaseOneDetails phaseOneDetails) {
            this.phaseOneDetails = phaseOneDetails;
            this.__explicitlySet__.add("phaseOneDetails");
            return this;
        }

        public Builder phaseTwoDetails(TunnelPhaseTwoDetails phaseTwoDetails) {
            this.phaseTwoDetails = phaseTwoDetails;
            this.__explicitlySet__.add("phaseTwoDetails");
            return this;
        }

        public Builder associatedVirtualCircuits(List<String> associatedVirtualCircuits) {
            this.associatedVirtualCircuits = associatedVirtualCircuits;
            this.__explicitlySet__.add("associatedVirtualCircuits");
            return this;
        }

        public IPSecConnectionTunnel build() {
            IPSecConnectionTunnel model = new IPSecConnectionTunnel(this.compartmentId, this.id, this.vpnIp, this.cpeIp, this.status, this.ikeVersion, this.lifecycleState, this.displayName, this.bgpSessionInfo, this.encryptionDomainConfig, this.routing, this.timeCreated, this.timeStatusUpdated, this.oracleCanInitiate, this.natTranslationEnabled, this.dpdMode, this.dpdTimeoutInSec, this.phaseOneDetails, this.phaseTwoDetails, this.associatedVirtualCircuits);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IPSecConnectionTunnel model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("vpnIp")) {
                this.vpnIp(model.getVpnIp());
            }
            if (model.wasPropertyExplicitlySet("cpeIp")) {
                this.cpeIp(model.getCpeIp());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("ikeVersion")) {
                this.ikeVersion(model.getIkeVersion());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("bgpSessionInfo")) {
                this.bgpSessionInfo(model.getBgpSessionInfo());
            }
            if (model.wasPropertyExplicitlySet("encryptionDomainConfig")) {
                this.encryptionDomainConfig(model.getEncryptionDomainConfig());
            }
            if (model.wasPropertyExplicitlySet("routing")) {
                this.routing(model.getRouting());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeStatusUpdated")) {
                this.timeStatusUpdated(model.getTimeStatusUpdated());
            }
            if (model.wasPropertyExplicitlySet("oracleCanInitiate")) {
                this.oracleCanInitiate(model.getOracleCanInitiate());
            }
            if (model.wasPropertyExplicitlySet("natTranslationEnabled")) {
                this.natTranslationEnabled(model.getNatTranslationEnabled());
            }
            if (model.wasPropertyExplicitlySet("dpdMode")) {
                this.dpdMode(model.getDpdMode());
            }
            if (model.wasPropertyExplicitlySet("dpdTimeoutInSec")) {
                this.dpdTimeoutInSec(model.getDpdTimeoutInSec());
            }
            if (model.wasPropertyExplicitlySet("phaseOneDetails")) {
                this.phaseOneDetails(model.getPhaseOneDetails());
            }
            if (model.wasPropertyExplicitlySet("phaseTwoDetails")) {
                this.phaseTwoDetails(model.getPhaseTwoDetails());
            }
            if (model.wasPropertyExplicitlySet("associatedVirtualCircuits")) {
                this.associatedVirtualCircuits(model.getAssociatedVirtualCircuits());
            }
            return this;
        }
    }
}

