/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IcmpOptions;
import com.oracle.bmc.core.model.TcpOptions;
import com.oracle.bmc.core.model.UdpOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FlowLogCaptureFilterRuleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="priority")
    private final Integer priority;
    @JsonProperty(value="samplingRate")
    private final Integer samplingRate;
    @JsonProperty(value="sourceCidr")
    private final String sourceCidr;
    @JsonProperty(value="destinationCidr")
    private final String destinationCidr;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;
    @JsonProperty(value="flowLogType")
    private final FlowLogType flowLogType;
    @JsonProperty(value="ruleAction")
    private final RuleAction ruleAction;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "priority", "samplingRate", "sourceCidr", "destinationCidr", "protocol", "icmpOptions", "tcpOptions", "udpOptions", "flowLogType", "ruleAction"})
    public FlowLogCaptureFilterRuleDetails(Boolean isEnabled, Integer priority, Integer samplingRate, String sourceCidr, String destinationCidr, String protocol, IcmpOptions icmpOptions, TcpOptions tcpOptions, UdpOptions udpOptions, FlowLogType flowLogType, RuleAction ruleAction) {
        this.isEnabled = isEnabled;
        this.priority = priority;
        this.samplingRate = samplingRate;
        this.sourceCidr = sourceCidr;
        this.destinationCidr = destinationCidr;
        this.protocol = protocol;
        this.icmpOptions = icmpOptions;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
        this.flowLogType = flowLogType;
        this.ruleAction = ruleAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getSamplingRate() {
        return this.samplingRate;
    }

    public String getSourceCidr() {
        return this.sourceCidr;
    }

    public String getDestinationCidr() {
        return this.destinationCidr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public FlowLogType getFlowLogType() {
        return this.flowLogType;
    }

    public RuleAction getRuleAction() {
        return this.ruleAction;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FlowLogCaptureFilterRuleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", priority=").append(String.valueOf(this.priority));
        sb.append(", samplingRate=").append(String.valueOf(this.samplingRate));
        sb.append(", sourceCidr=").append(String.valueOf(this.sourceCidr));
        sb.append(", destinationCidr=").append(String.valueOf(this.destinationCidr));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", icmpOptions=").append(String.valueOf((Object)this.icmpOptions));
        sb.append(", tcpOptions=").append(String.valueOf((Object)this.tcpOptions));
        sb.append(", udpOptions=").append(String.valueOf((Object)this.udpOptions));
        sb.append(", flowLogType=").append(String.valueOf((Object)this.flowLogType));
        sb.append(", ruleAction=").append(String.valueOf((Object)this.ruleAction));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlowLogCaptureFilterRuleDetails)) {
            return false;
        }
        FlowLogCaptureFilterRuleDetails other = (FlowLogCaptureFilterRuleDetails)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.priority, other.priority) && Objects.equals(this.samplingRate, other.samplingRate) && Objects.equals(this.sourceCidr, other.sourceCidr) && Objects.equals(this.destinationCidr, other.destinationCidr) && Objects.equals(this.protocol, other.protocol) && Objects.equals((Object)this.icmpOptions, (Object)other.icmpOptions) && Objects.equals((Object)this.tcpOptions, (Object)other.tcpOptions) && Objects.equals((Object)this.udpOptions, (Object)other.udpOptions) && Objects.equals((Object)this.flowLogType, (Object)other.flowLogType) && Objects.equals((Object)this.ruleAction, (Object)other.ruleAction) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.priority == null ? 43 : this.priority.hashCode());
        result = result * 59 + (this.samplingRate == null ? 43 : this.samplingRate.hashCode());
        result = result * 59 + (this.sourceCidr == null ? 43 : this.sourceCidr.hashCode());
        result = result * 59 + (this.destinationCidr == null ? 43 : this.destinationCidr.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.icmpOptions == null ? 43 : this.icmpOptions.hashCode());
        result = result * 59 + (this.tcpOptions == null ? 43 : this.tcpOptions.hashCode());
        result = result * 59 + (this.udpOptions == null ? 43 : this.udpOptions.hashCode());
        result = result * 59 + (this.flowLogType == null ? 43 : this.flowLogType.hashCode());
        result = result * 59 + (this.ruleAction == null ? 43 : this.ruleAction.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FlowLogType implements BmcEnum
    {
        All("ALL"),
        Reject("REJECT"),
        Accept("ACCEPT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FlowLogType> map;

        private FlowLogType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FlowLogType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FlowLogType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FlowLogType.class);
            map = new HashMap<String, FlowLogType>();
            for (FlowLogType v : FlowLogType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RuleAction implements BmcEnum
    {
        Include("INCLUDE"),
        Exclude("EXCLUDE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleAction> map;

        private RuleAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleAction.class);
            map = new HashMap<String, RuleAction>();
            for (RuleAction v : RuleAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="priority")
        private Integer priority;
        @JsonProperty(value="samplingRate")
        private Integer samplingRate;
        @JsonProperty(value="sourceCidr")
        private String sourceCidr;
        @JsonProperty(value="destinationCidr")
        private String destinationCidr;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonProperty(value="flowLogType")
        private FlowLogType flowLogType;
        @JsonProperty(value="ruleAction")
        private RuleAction ruleAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.__explicitlySet__.add("priority");
            return this;
        }

        public Builder samplingRate(Integer samplingRate) {
            this.samplingRate = samplingRate;
            this.__explicitlySet__.add("samplingRate");
            return this;
        }

        public Builder sourceCidr(String sourceCidr) {
            this.sourceCidr = sourceCidr;
            this.__explicitlySet__.add("sourceCidr");
            return this;
        }

        public Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            this.__explicitlySet__.add("destinationCidr");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public Builder flowLogType(FlowLogType flowLogType) {
            this.flowLogType = flowLogType;
            this.__explicitlySet__.add("flowLogType");
            return this;
        }

        public Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction = ruleAction;
            this.__explicitlySet__.add("ruleAction");
            return this;
        }

        public FlowLogCaptureFilterRuleDetails build() {
            FlowLogCaptureFilterRuleDetails model = new FlowLogCaptureFilterRuleDetails(this.isEnabled, this.priority, this.samplingRate, this.sourceCidr, this.destinationCidr, this.protocol, this.icmpOptions, this.tcpOptions, this.udpOptions, this.flowLogType, this.ruleAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FlowLogCaptureFilterRuleDetails model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("priority")) {
                this.priority(model.getPriority());
            }
            if (model.wasPropertyExplicitlySet("samplingRate")) {
                this.samplingRate(model.getSamplingRate());
            }
            if (model.wasPropertyExplicitlySet("sourceCidr")) {
                this.sourceCidr(model.getSourceCidr());
            }
            if (model.wasPropertyExplicitlySet("destinationCidr")) {
                this.destinationCidr(model.getDestinationCidr());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("icmpOptions")) {
                this.icmpOptions(model.getIcmpOptions());
            }
            if (model.wasPropertyExplicitlySet("tcpOptions")) {
                this.tcpOptions(model.getTcpOptions());
            }
            if (model.wasPropertyExplicitlySet("udpOptions")) {
                this.udpOptions(model.getUdpOptions());
            }
            if (model.wasPropertyExplicitlySet("flowLogType")) {
                this.flowLogType(model.getFlowLogType());
            }
            if (model.wasPropertyExplicitlySet("ruleAction")) {
                this.ruleAction(model.getRuleAction());
            }
            return this;
        }
    }
}

