/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changesets.core;

import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.regex.Pattern;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.AbstractChangeSet;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;

public class XmlChangeSet
extends AbstractChangeSet {
    public static final String CHANGE_TYPE = "%CHANGE_TYPE%";
    public static final String SOURCE_TYPE_STRING = "sourceType=\"STRING\"";
    public static final String SOURCE_TYPE = "%SOURCE_TYPE%";
    public static final String SCRIPT = "SCRIPT";
    String rawchange = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n <changeSet id=\"%ID%\" author=\"%AUTHOR%\" %FAILONERROR% %CONTEXTS% %LABELS% %RUNOPTIONS% >\n  <n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n    <n0:source><![CDATA[%SOURCE%]]></n0:source>\n      </n0:%CHANGE_TYPE%>\n </changeSet>\n</databaseChangeLog>\n";

    public XmlChangeSet(ChangeData data) throws ObjectNotFoundException, SQLException {
        super(data);
    }

    @Override
    public String getChange() throws LiquibaseException {
        try {
            String dSchema = this.getData().getSCHEMA();
            String schema = dSchema == null ? LbUtils.getLbConnection().getConnectionUserName() : dSchema;
            if (null == schema) {
                throw new LiquibaseException("Unable to generate changelog can not determine schema.");
            }
            this.rawchange = LiquibaseStringUtils.replaceVal("%ID%", this.getSha1fromString(this.getData().getDDL()), this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%AUTHOR%", "(" + schema + ")-Generated", this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_NAME%", this.getData().getONAME().replaceAll("\"", ""), this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_TYPE%", this.getData().getOTYPE(), this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%OWNER_NAME%", schema, this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE%", this.getData().getDDL().replaceAll("\\]\\]\\>", "]]]]><![CDATA[>"), this.rawchange);
            if (DbmsMetaUtils.isSxmlType(this.getData().getOTYPE().toUpperCase())) {
                this.rawchange = LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "createSxmlObject", this.rawchange);
            } else if ("COMMENT".equalsIgnoreCase(this.getData().getOTYPE())) {
                this.rawchange = LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "createOracleComment", this.rawchange);
                this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange);
            } else if (SCRIPT.equalsIgnoreCase(this.getData().getOTYPE()) && "ORDS".equals(this.getData().getONAME())) {
                this.rawchange = LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "runOrdsScript", this.rawchange);
                this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange);
            } else if (SCRIPT.equalsIgnoreCase(this.getData().getOTYPE()) && "APEX".equals(this.getData().getONAME())) {
                this.rawchange = LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "runApexScript", this.rawchange);
                this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange);
            } else if (SCRIPT.equalsIgnoreCase(this.getData().getOTYPE())) {
                this.rawchange = LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "runOracleScript", this.rawchange);
                this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange);
            } else {
                this.rawchange = "SYNONYM".equalsIgnoreCase(this.getData().getOTYPE()) && this.getData().getDDL().trim().toUpperCase().startsWith("CREATE OR REPLACE NONEDITIONABLE PUBLIC SYNONYM") ? LiquibaseStringUtils.replaceVal(CHANGE_TYPE, "createOraclePublicSynonym", this.rawchange) : LiquibaseStringUtils.replaceVal(CHANGE_TYPE, SchemaGenerator.ddlChangeTypes.get(this.getData().getOTYPE().toUpperCase()), this.rawchange);
            }
            this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, "", this.rawchange);
            if ("TRIGGER".equals(this.getData().getOTYPE())) {
                this.rawchange = this.rawchange.replace("END;\\nALTER TRIGGER", "END;\n/\nALTER TRIGGER");
            }
            this.rawchange = this.getData().isFAIL() ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"false\"", this.rawchange);
            this.rawchange = this.getData().isREPLACE() ? LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"false\"", this.rawchange);
            this.rawchange = null != this.getData().getCONTEXT() && !this.getData().getCONTEXT().isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + this.getData().getCONTEXT() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, this.rawchange);
            this.rawchange = null != this.getData().getLABEL() && !this.getData().getLABEL().isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + this.getData().getLABEL() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%LABELS%", null, this.rawchange);
            String runOptions = this.getRunOptions();
            this.rawchange = LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", runOptions, this.rawchange);
            this.rawchange = this.rawchange.replaceAll("(\"?)(.*)(\"?\\.)(\"?" + Pattern.quote(this.getData().getONAME()) + "\"?)", "$1%USER_NAME%$3$4");
            return this.rawchange;
        }
        catch (Exception e) {
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e), (Throwable)e);
        }
    }

    private String getRunOptions() {
        String runChange = this.getData().isRUNONCHANGE() ? " runOnChange=\"true\" " : " runOnChange=\"false\" ";
        String runAlways = this.getData().isRUNALWAYS() ? " runAlways=\"true\" " : " runAlways=\"false\" ";
        String runInTrans = " runInTransaction=\"false\" ";
        String runOptions = runChange + runAlways + runInTrans;
        return runOptions;
    }
}

