/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changesets.core;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Objects;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.generator.changesets.interfaces.ChangeSet;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public abstract class AbstractChangeSet
implements ChangeSet {
    ChangeData _data;

    protected AbstractChangeSet(ChangeData data) throws ObjectNotFoundException, SQLException {
        this._data = data;
        this.cleanDdlParam();
        if (this.isNull(this._data.getOTYPE()) || this.isNull(this._data.getONAME()) || this.isNull(this._data.getDDL())) {
            LbUtils.report(Messages.format(Messages.get("BAD_CL_DATA"), this._data.getOTYPE(), this._data.getONAME(), this._data.getDDL()));
        }
    }

    private boolean isNull(String value) {
        return null == value || value.isEmpty();
    }

    public ChangeData getData() {
        return this._data;
    }

    protected String getSha1fromString(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    private void cleanDdlParam() throws ObjectNotFoundException, SQLException {
        Object ddl = this._data.getDDL();
        String oType = this._data.getOTYPE();
        String oName = this._data.getONAME();
        if (null == ddl || ((String)ddl).isEmpty()) {
            if (this._data.getCHANGETYPE().equalsIgnoreCase("XML")) {
                ddl = !SchemaGenerator.ddlChangeTypes.containsKey(oType) ? DbmsMetaUtils.getSxmlFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), Objects.requireNonNull(oType), Objects.requireNonNull(oName)) : DbmsMetaUtils.getDdlFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), Objects.requireNonNull(oType), Objects.requireNonNull(oName));
            } else {
                ddl = DbmsMetaUtils.getDdlFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), Objects.requireNonNull(oType), Objects.requireNonNull(oName));
                if (null == ddl || ((String)ddl).isEmpty()) {
                    throw new ObjectNotFoundException(Messages.getString("LB_NO_OBJECT"));
                }
            }
        }
        if ("JOB".equalsIgnoreCase(oType)) {
            ddl = ((String)ddl).replace("\"", "");
        } else if ("TRIGGER".equalsIgnoreCase(oType)) {
            ddl = ((String)ddl).replace("\n\n/", "\n/");
            try {
                String status = DbmsMetaUtils.getTriggerStatus(LbUtils.getLbConnection().getUnderlyingConnection(), oName);
                if ("DISABLED".equalsIgnoreCase(status)) {
                    ddl = (String)ddl + "\nALTER TRIGGER " + oName + " DISABLE;";
                } else if ("ENABLED".equalsIgnoreCase(status)) {
                    ddl = (String)ddl + "\nALTER TRIGGER " + oName + " ENABLE;";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._data.setDDL((String)ddl);
    }
}

