/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.generator;

import java.util.LinkedList;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractCommonSxmlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreateInternalSxmlStatement;
import oracle.dbtools.raptor.liquibase.generator.MetadataSqlGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.util.Logger;

public abstract class AbstractCommonSxmlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonSxmlStatement> {
    public ValidationErrors validate(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors priorErrors = statement.getValidation();
        ValidationErrors validationErrors = new ValidationErrors();
        if (priorErrors != null) {
            return priorErrors;
        }
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        validationErrors.checkRequiredField("source", (Object)statement.getSource());
        validationErrors.checkRequiredField("objectType", (Object)statement.getObjectType());
        if (validationErrors.hasErrors()) {
            statement.setValidation(validationErrors);
            return validationErrors;
        }
        if (ACTIONS.CREATE == this.createOrDrop()) {
            try {
                statement.setSqls(MetadataSqlGenerator.getCreateSqlSxml(statement, database));
            }
            catch (Exception e) {
                validationErrors.addError(LbUtils.getRoot(e).getMessage());
                statement.setValidation(validationErrors);
            }
        } else {
            try {
                statement.setSqls(MetadataSqlGenerator.getDropSqlSxml(statement, database));
            }
            catch (Exception e) {
                validationErrors.addError(e.getMessage());
                statement.setValidation(validationErrors);
            }
        }
        return validationErrors;
    }

    public Sql[] generateSql(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        if (!(database instanceof OracleDatabase)) {
            return new Sql[0];
        }
        Sql[] sqls = statement.getSqls();
        if (sqls == null || sqls.length == 0) {
            if (ACTIONS.CREATE == this.createOrDrop()) {
                try {
                    sqls = MetadataSqlGenerator.getCreateSqlSxml(statement, database);
                }
                catch (Exception e) {
                    Logger.warn(AbstractCommonSxmlGenerator.class, (Throwable)e);
                    return EMPTY_SQL;
                }
            }
            try {
                sqls = MetadataSqlGenerator.getDropSqlSxml(statement, database);
            }
            catch (Exception e) {
                Logger.warn(AbstractCommonSxmlGenerator.class, (Throwable)e);
                return EMPTY_SQL;
            }
        }
        LinkedList<UnparsedSql> stmts = new LinkedList<UnparsedSql>();
        for (Sql sql : sqls) {
            if (sql == null) continue;
            String sqlStr = statement instanceof CreateInternalSxmlStatement ? LbUtils.replaceLiquibaseSchema(sql.toSql()) : LbUtils.replaceUserSchema(sql.toSql(), statement.getOwnerName());
            stmts.add(new UnparsedSql(sqlStr, new DatabaseObject[0]));
        }
        return stmts.toArray(new Sql[0]);
    }

    public abstract ACTIONS createOrDrop();

    public boolean supports(AbstractCommonSxmlStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public static enum ACTIONS {
        CREATE,
        DROP;

    }
}

