/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.generator.RunInternalScriptGenerator;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunInternalScriptStatement;

@DatabaseChange(name="runInternalScript", description="Run Oracle Script", priority=1)
public class RunInternalScriptChange
extends AbstractCommonPlSqlChange {
    public RunInternalScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunInternalScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    protected Change[] createInverses() {
        return null;
    }

    public SqlStatement[] generateStatements(Database database) {
        RunInternalScriptStatement stmt = new RunInternalScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully {0}", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    public CheckSum generateCheckSum() {
        try {
            return this.getCheckSum(this);
        }
        catch (LiquibaseException e) {
            return null;
        }
    }

    private CheckSum getCheckSum(AbstractCommonPlSqlChange change) throws LiquibaseException {
        RunInternalScriptGenerator generator = new RunInternalScriptGenerator();
        return CheckSum.compute((String)generator.getSqlString(change));
    }
}

