/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropSynonymChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreateSynonymStatement;

@DatabaseChange(name="createOracleSynonym", description="Create oracle synonym", priority=1)
public class CreateSynonymChange
extends AbstractCommonPlSqlChange {
    public CreateSynonymChange() {
        this.setObjectType("SYNONYM");
    }

    public CreateSynonymChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SYNONYM");
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateSynonymStatement stmt = new CreateSynonymStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Synonym {0} created", this.getObjectName());
    }

    protected Change[] createInverses() {
        DropSynonymChange inverse = new DropSynonymChange(this);
        return new Change[]{inverse};
    }
}

