/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.arbori.util.Array;
import oracle.dbtools.extension.project.diff.ColProperties;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public abstract class ParseDiff {
    public Map<String, String> add = new TreeMap<String, String>();
    public Map<String, String> modify = new TreeMap<String, String>();
    public List<String> delete = new LinkedList<String>();
    public Map<String, String> rename = new TreeMap<String, String>();

    public ParseDiff(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2) {
        int i2;
        int i1;
        int[] matches1 = null;
        int[] matches2 = null;
        block0: for (i1 = 0; i1 < dl1.size(); ++i1) {
            if (matches1 != null && matches1[Array.indexOf(matches1, (int)i1)] == i1) continue;
            for (i2 = 0; i2 < dl2.size(); ++i2) {
                ColProperties cp2;
                String def2;
                if (matches2 != null && matches2[Array.indexOf(matches2, (int)i2)] == i2) continue;
                String def1 = t1.content(dl1.get(i1));
                if (LexerToken.equals((String)def1, (String)(def2 = t2.content(dl2.get(i2))))) {
                    matches1 = Array.insert(matches1, (int)i1);
                    matches2 = Array.insert(matches2, (int)i2);
                    continue block0;
                }
                ColProperties cp1 = new ColProperties(t1, dl1.get(i1));
                if (!ColProperties.sameName(cp1, cp2 = new ColProperties(t2, dl2.get(i2)))) continue;
                if (cp1.type != null && (cp1.type.contains("ANSI_supported_datatypes") || cp1.type.contains("Oracle_built_in_datatypes") || cp1.type.contains("XML_types") && cp1.type.to - cp1.type.from == cp2.type.to - cp2.type.from)) {
                    Object newChange = new ColProperties(t2, dl2.get(i2)).reduce(cp1);
                    if (def1.contains("not null") && !def2.contains("not null")) {
                        newChange = (String)newChange + " null";
                    }
                    this.modify.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content, (String)newChange);
                } else {
                    this.delete.add(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content);
                    this.add.put(((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + this.nameIndex()))).content, new ColProperties(t2, dl2.get(i2)).reduce(cp1));
                }
                matches1 = Array.insert((int[])matches1, (int)i1);
                matches2 = Array.insert((int[])matches2, (int)i2);
                continue block0;
            }
            this.delete.add(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content);
        }
        block2: for (i1 = 0; i1 < dl1.size(); ++i1) {
            if (matches1 != null && matches1[Array.indexOf(matches1, (int)i1)] == i1) continue;
            for (i2 = 0; i2 < dl2.size(); ++i2) {
                ColProperties cp2;
                ColProperties cp1;
                if (matches2 != null && matches2[Array.indexOf(matches2, (int)i2)] == i2 || !ColProperties.sameType(cp1 = new ColProperties(t1, dl1.get(i1)), cp2 = new ColProperties(t2, dl2.get(i2))) || !ColProperties.sameConstraint(cp1, cp2) || ParseDiff.adjustedPos(i1, matches1) != ParseDiff.adjustedPos(i2, matches2)) continue;
                this.rename.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content, ((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + this.nameIndex()))).content);
                this.delete.remove(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content);
                matches1 = Array.insert((int[])matches1, (int)i1);
                matches2 = Array.insert((int[])matches2, (int)i2);
                continue block2;
            }
        }
        for (int i22 = 0; i22 < dl2.size(); ++i22) {
            if (matches2 != null && matches2[Array.indexOf(matches2, (int)i22)] == i22) continue;
            this.add.put(((LexerToken)t2.getSrc().get((int)(dl2.get((int)i22).from + this.nameIndex()))).content, new ColProperties(t2, dl2.get(i22)).reduce(null));
        }
    }

    static int adjustedPos(int p, int[] skip) {
        if (skip == null) {
            return 0;
        }
        int ret = 0;
        for (int s : skip) {
            if (s >= p) continue;
            ++ret;
        }
        return ret;
    }

    public abstract int nameIndex();
}

