/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.stage.objectclasses.SrcSnapShot;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import org.apache.commons.io.FileUtils;

public class VerifySnapshotService
implements VerifyServiceInterface {
    String[] fileTypes = new String[]{"sql", "pks", "pkb", "pls"};
    boolean DEBUG = false;
    Pattern apex_yaml_pattern = Pattern.compile(".*\\/apex_apps\\/.*\\/readable");

    @Override
    public String getName() {
        return "verifysnapshot";
    }

    @Override
    public String getGroup() {
        return "snapshot";
    }

    private boolean processFiles(Collection<File> files) {
        boolean error = false;
        ArrayList errorFiles = new ArrayList();
        for (File file : files) {
            SrcSnapShot snap;
            block10: {
                if (file.isDirectory()) {
                    error = this.processFiles(FileUtils.listFiles((File)file, (String[])this.fileTypes, (boolean)true));
                    continue;
                }
                if (this.apex_yaml_pattern.matcher(file.getParent()).find()) {
                    this.addMessage(VerifyServiceInterface.MessageLevel.HIDDEN, "SKIPPING_FILE", "file", file);
                    continue;
                }
                try {
                    snap = SrcSnapShot.loadSnapShot(file);
                    if (snap == null) {
                        this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "NO_SNAPSHOT", "file", file);
                    }
                    break block10;
                }
                catch (IOException e) {
                    this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "LOAD_SNAPSHOT_FAILED\n" + e.getMessage(), "file", file);
                    error = true;
                }
                continue;
            }
            if (snap.getName() == null) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "NULL_NAME", "file", file);
                error = true;
            }
            if (snap.getType() == null) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "NULL_TYPE", "file", file);
                error = true;
            }
            if (snap.getSchemaName() == null) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "NULL_SCHEMA", "file", file);
                error = true;
            }
            if (snap.getHash() != null) continue;
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "NULL_HASH", "file", file);
            error = true;
        }
        if (!error) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, "Snapshot validation found no issues.");
        }
        return error;
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            Path root = ProjectConfig.getCurrentWorkingProjectRoot().resolve("src").resolve("database");
            return this.processFiles(FileUtils.listFiles((File)root.toFile(), (String[])this.fileTypes, (boolean)true));
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, e.getMessage(), "exception", e);
            return false;
        }
    }
}

