/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.console.statusbar;

import java.util.stream.Stream;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.raptor.console.StatusBarComponent;
import org.jline.utils.AttributedString;

public class StatusComponent
implements StatusBarComponent {
    private final String[] widget = new String[]{"|", "/", "--", "\\", "|"};
    private final int bCount = 0;
    private final int wCount = 0;

    public String getBar(int length, int pos) {
        char incomplete = '\u2591';
        char complete = '\u2588';
        StringBuilder builder = new StringBuilder();
        Stream.generate(() -> Character.valueOf(incomplete)).limit(length).forEach(builder::append);
        for (int i = 0; i < pos; ++i) {
            builder.replace(i, i + 1, String.valueOf(complete));
        }
        String progressBar = "\r" + String.valueOf(builder);
        return progressBar;
    }

    public String getName() {
        return "status";
    }

    public String getDescription() {
        return ProjectMessages.getString("NO_ROOT_FOR_CONFIG");
    }

    private AttributedString updateBar(StatusBarComponent.Context context) {
        Object message;
        String status = context.getScriptRunnerContext().getStringProperty("STATUSBARSTATUS", "idle");
        int pos = context.getScriptRunnerContext().getIntegerProperty("STATUSBARPOSITION", 0);
        int size = 15;
        try {
            size = context.getScriptRunnerContext().getIntegerProperty("STATUSBARSIZE", 15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (status.equalsIgnoreCase("idle")) {
            message = "Idle";
            pos = 0;
        } else {
            message = this.getBar(size, pos) + status;
            pos = pos == size ? 0 : ++pos;
        }
        context.getScriptRunnerContext().putProperty("STATUSBARPOSITION", (Object)pos);
        return new AttributedString((CharSequence)message);
    }

    private AttributedString updateGuage(StatusBarComponent.Context context) {
        Object message;
        String status = context.getScriptRunnerContext().getStringProperty("STATUSBARSTATUS", "idle");
        int pos = context.getScriptRunnerContext().getIntegerProperty("STATUSBARPOSITION", 0);
        if (status.equalsIgnoreCase("idle")) {
            message = "Idle";
            pos = 0;
        } else {
            message = this.widget[pos] + status;
            pos = pos == 4 ? 0 : ++pos;
        }
        context.getScriptRunnerContext().putProperty("STATUSBARPOSITION", (Object)pos);
        return new AttributedString((CharSequence)message);
    }

    public void updateLocal(StatusBarComponent.Context context) {
        String style = context.getScriptRunnerContext().getStringProperty("STATUSBARSTYLE", "guage");
        AttributedString message = style == null ? new AttributedString((CharSequence)"null") : (style.equalsIgnoreCase("bar") ? this.updateBar(context) : this.updateGuage(context));
        context.append(message);
    }

    public void update(StatusBarComponent.Context context) {
        Thread statusThread = new Thread("ProgressBarThread"){

            @Override
            public void run() {
            }
        };
    }
}

